/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: INKFRequestReadOnly.java,v $
 * Version:       $Name:  $ $Revision: 1.12 $
 * Last Modified: $Date: 2004/10/06 10:40:34 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.nkf;

import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.urii.IURRepresentation;
import java.util.Iterator;
import java.net.URI;
/**
 * A Read/Only Wrapper around the calling request that initiated the invocation of the accessor
 * @author  pjr
 */
public interface INKFRequestReadOnly
{   
	/** a request to get the data for a URI */
    public static final int RQT_SOURCE=URRequest.RQT_SOURCE;
	/** a request to set the data for a URI */
    public static final int RQT_SINK=URRequest.RQT_SINK;
	/** a request to see if a resource exists */
    public static final int RQT_EXISTS=URRequest.RQT_EXISTS;
	/** a request to delete a resource */
    public static final int RQT_DELETE=URRequest.RQT_DELETE;
	/** a request to create a new resource */
    public static final int RQT_NEW=URRequest.RQT_NEW;
	/** a request to transpresent data for a resource to a new aspect */
    public static final int RQT_TRANSREPRESENT=URRequest.RQT_TRANSREPRESENT;
	/** a request to fragment a resource */
    public static final int RQT_FRAGMENT=URRequest.RQT_FRAGMENT;
	/** the URI for system arguments */
	public static final String URI_SYSTEM = URRequest.URI_SYSTEM.toString();

	/** Return the request type (one the static final int constants) */
	int getRequestType();
	
	/** Return the URI of the request */
	String getURI();
	
	/** Return a fragment on the URI, null if none */
	String getFragment();
	
	/** Return the URI of the request without the fragment (if any) */
	String getURIWithoutFragment();
	
	/** Return the current working URI of the request **/
	String getCWU();
	
	/** Return the aspect class that the client expects in the response */
	Class getAspectClass();
	
	
	/** Return true if the URI is in the form of an active URI with named
	 * arguments */
	boolean isActiveURI();
	
	/** Return the base of the active URI
	 */
	String getActiveType();
	
	/** Return an iterator over a set of argument names (String) */
	Iterator getArguments();
	
	/** Return true if the given argument is available on the request
	 * @param aName
	 */
	boolean argumentExists(String aName);
	
	/** Return the URI of the given argument, null if it doesn't exist.
	 * @param aName
	 */
	String getArgument(String aName);
	
	/** Return the value of a by-value argument
	 * @param aURI
	 */
	IURRepresentation getArgumentValue(String aURI);
}