/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: AccessorMeta.java,v $
  Version:       $Name:  $ $Revision: 1.2 $
  Last Modified: $Date: 2004/07/19 16:33:34 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.meta;

import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.urii.*;
/**
 * An implementation of IURAccessorMeta for active accessors, i.e. accessors that only
 * implement the <code>URRequest.RQT_SOURCE</code> request.
 * @author  tab
 */
public class AccessorMeta extends MetaImpl implements IURAccessorMeta
{
	private int mRequestTypes;
	private static final int THREADSAFE_MASK=0x1000;
	
	/** Creates a new instance of ActiveAccessorMeta */
	public AccessorMeta(int aCost, boolean aIsThreadSafe, int aRequestTypes)
	{	super(MIME_TYPE,Long.MAX_VALUE,aCost);
		mRequestTypes=aRequestTypes;
		setThreadSafe(aIsThreadSafe);
	}
	
	public void setThreadSafe(boolean aIsThreadSafe)
	{	if (aIsThreadSafe)
		{	mRequestTypes|=THREADSAFE_MASK;
		}
		else
		{	mRequestTypes&=~THREADSAFE_MASK;
		}
	}
	
	/** returns true if the request type is RRequest.RQT_SOURCE
	 */
	public boolean supportsRequestType(int aRequestType)
	{	return (mRequestTypes&aRequestType)!=0;
	}
	
	/** returns true if the accessor is thread safe
	 */
	public boolean isThreadSafe()
	{	return supportsRequestType(THREADSAFE_MASK);
	}
	
	/** accessors are never intermediate
	 */
	public boolean isIntermediate()
	{	return false;
	}	
	/** accessors are never context sensitive
	 */
	public boolean isContextSensitive()
	{	return false;
	}
}