/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: NewSimpleNetAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.7 $
  Last Modified: $Date: 2004/10/04 11:30:38 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.accessor;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.urii.aspect.NetKernelExceptionAspect;
import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;
import com.ten60.netkernel.urii.aspect.IAspectBinaryStream;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.util.Utils;

import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;

import java.net.*;
import java.io.*;
import java.util.*;

/**
 *  Returns an IAspectReadableBinaryStream
 * be resolved as a URL using javas inbuilt resolver. Expiry times
 * are determined from the URLConnection. Results are
 * not buffered in anyway
 * @author  pjr
 */
public class NewSimpleNetAccessor extends AccessorImpl
{
	private URIdentifier mURI;
	private static final int VALID_TYPES=URRequest.RQT_DELETE|URRequest.RQT_SOURCE|URRequest.RQT_SINK|URRequest.RQT_EXISTS;
	
	/** Creates a new instance of NewSimpleNetAccessor */
	public NewSimpleNetAccessor()
	{	super(new ActiveAccessorMeta(2, true)
		{		public boolean supportsRequestType(int aRequestType)
				{	return (aRequestType|VALID_TYPES)==VALID_TYPES;
				}
		});
		//Experiment with timeout values
		String CONNECT_TIMEOUT="sun.net.client.defaultConnectTimeout";
		String READ_TIMEOUT="sun.net.client.defaultReadTimeout";
		Properties p = System.getProperties();
		String v=p.getProperty(CONNECT_TIMEOUT);
		if (v==null)
		{	p.setProperty(CONNECT_TIMEOUT,"20000");
		}
		 v=p.getProperty(READ_TIMEOUT);
		if (v==null)
		{	p.setProperty(READ_TIMEOUT,"20000");
		}
		System.setProperties(p);

	}
	
	public void requestAsync(URRequest aRequest)
	{	IURRepresentation result=null;
		boolean error=false;
		if(aRequest.getType()==aRequest.RQT_SOURCE)
		{	try
			{	if(aRequest.getArgs().size()==0)
				{	result=sourceGET(aRequest.getURI());
				}
				else
				{	result=sourcePOST(aRequest);
				}
			}
			catch(Throwable e)
			{	NetKernelException nke=new NetKernelException("Error Sourcing "+aRequest.getURI().toString());
				nke.addCause(e);
				result=NetKernelExceptionAspect.create(nke);
				error=true;
			}
		}
		else if(aRequest.getType()==aRequest.RQT_SINK && aRequest.getURI().getScheme().equals("file"))
		{	try
			{	result=sinkFile(aRequest);
			}
			catch(Throwable e)
			{	NetKernelException nke=new NetKernelException("Error Sourcing "+aRequest.getURI().toString());
				nke.addCause(e);
				result=NetKernelExceptionAspect.create(nke);
				error=true;
			}
		}
		else if(aRequest.getType()==aRequest.RQT_DELETE && aRequest.getURI().getScheme().equals("file"))
		{	try
			{	result=deleteFile(aRequest);
			}
			catch(Throwable e)
			{	NetKernelException nke=new NetKernelException("Error Deleting "+aRequest.getURI().toString());
				nke.addCause(e);
				result=NetKernelExceptionAspect.create(nke);
				error=true;
			}
		}
		else if(aRequest.getType()==aRequest.RQT_EXISTS && aRequest.getURI().getScheme().equals("file"))
		{	try
			{	result=existsFile(aRequest);
			}
			catch(Throwable e)
			{	NetKernelException nke=new NetKernelException("Error Deleting "+aRequest.getURI().toString());
				nke.addCause(e);
				result=NetKernelExceptionAspect.create(nke);
				error=true;
			}
		}
		else
		{	NetKernelException nke=new NetKernelException("Unsupported operation for NewSimpleNetAccessor on URI "+aRequest.getURI().toString());
			result=NetKernelExceptionAspect.create(nke);
			error=true;
		}
		
		URResult urr=new URResult(aRequest, result);
		if(error)
		{	getScheduler().receiveAsyncException(urr);
		}
		else getScheduler().receiveAsyncResult(urr);
	}
	
	private IURRepresentation sourceGET(URIdentifier aURI) throws Throwable
	{	URL src= new URL(aURI.toString());
		ReadableURLAspect aspect = new ReadableURLAspect(src);
		long expiration = aspect.getExpiration();
		IURMeta meta = new MetaImpl(aspect.getContentType(), expiration, 4);
		IURRepresentation result = new MonoRepresentationImpl(meta, aspect);
		return result;
	}
	
	private IURRepresentation sourcePOST(URRequest aRequest) throws Throwable
	{	Collection args=aRequest.getArgs();
		if(args.size()>1) throw new Exception("Multipart POST not supported");
		URI src=URI.create(aRequest.getURI().toString());
		if(!src.getScheme().equals("http")) throw new Exception("POST only supported for http: scheme");
		HttpURLConnection urlcon=(HttpURLConnection)src.toURL().openConnection();
		urlcon.setRequestMethod("POST");
		urlcon.setDoOutput(true);
		urlcon.setDoInput(true);
		urlcon.connect();
		
		IURRepresentation rep=aRequest.getArg((URIdentifier)args.toArray()[0]);
		IAspectNVP nvp=null;
		if(!rep.hasAspect(IAspectNVP.class))
		{	nvp= (IAspectNVP)transrepresent(URIdentifier.getUnique("literal:nvp"),rep,IAspectNVP.class,aRequest).getAspect((IAspectNVP.class));
		}
		StringBuffer sb=new StringBuffer();
		Iterator names=nvp.getNames().iterator();
		while(names.hasNext())
		{	String name=(String)names.next();
			List values=nvp.getValues(name);
			Iterator vi=values.iterator();
			while(vi.hasNext())
			{	sb.append(name);
				sb.append("=");
				sb.append(CompoundURIdentifier.encode((String)vi.next()));
				if(vi.hasNext()) sb.append("&");
			}	
			if(names.hasNext()) sb.append("&");
		}
		BufferedOutputStream bos=new BufferedOutputStream(urlcon.getOutputStream());
		bos.write(sb.toString().getBytes());
		bos.flush();
		bos.close();
		
		ByteArrayOutputStream baos=new ByteArrayOutputStream();
		BufferedInputStream is= new BufferedInputStream(urlcon.getInputStream());
		Utils.pipe(is, baos);
		IURMeta meta = new MetaImpl(urlcon.getContentType(), 0, 64);
		ByteArrayAspect aspect = new ByteArrayAspect(baos);
		return new MonoRepresentationImpl( meta , aspect );
	}
	
	private IURRepresentation deleteFile(URRequest aRequest) throws Throwable
	{	URI target=URI.create(aRequest.getURI().toString());
		File f=new File(target);
		BooleanAspect aspect = new BooleanAspect( f.delete() );
		return new MonoRepresentationImpl(new AlwaysExpiredMeta("content/unknown",1),aspect);
	}
	private IURRepresentation existsFile(URRequest aRequest) throws Throwable
	{	URI target=URI.create(aRequest.getURI().toString());
		File f=new File(target);
		BooleanAspect aspect = new BooleanAspect( f.exists() );
		return new MonoRepresentationImpl(new AlwaysExpiredMeta("content/unknown",1),aspect);
	}
	private IURRepresentation sinkFile(URRequest aRequest) throws Throwable
	{	URI target=URI.create(aRequest.getURI().toString());
		if(!target.getScheme().equals("file")) throw new Exception("Expected file: URI");
		File f=new File(target);
		if(!f.exists())
		{	f.getParentFile().mkdirs();
			f.createNewFile();
		}
		
		FileOutputStream fos=new FileOutputStream(f);
		
		IURRepresentation representation = aRequest.getArg(URRequest.URI_SYSTEM);
		IAspectBinaryStream data;
		if (representation.hasAspect(IAspectBinaryStream.class))
		{	data = (IAspectBinaryStream)representation.getAspect(IAspectBinaryStream.class);
		}
		else
		{
			data = (IAspectBinaryStream)transrepresent(URIdentifier.getUnique("literal:sink"),representation,IAspectBinaryStream.class,aRequest).getAspect((IAspectBinaryStream.class));
		}
		try
		{	data.write(fos);
		}
		finally
		{	fos.close();
		}
		return org.ten60.netkernel.layer1.representation.VoidAspect.create();
	}
}
