/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: LinkTableParser.java,v $
 * Version:       $Name:  $ $Revision: 1.4 $
 * Last Modified: $Date: 2005/10/25 11:30:24 $
 *****************************************************************************/
package org.ten60.docxter2;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.urii.aspect.IAspectBinaryStream;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;

import org.ten60.netkernel.xml.representation.IAspectXDA;
import org.ten60.netkernel.xml.xda.XPathLocationException;
import org.ten60.netkernel.xml.transrepresentation.DOMXDAParser;

import org.ten60.netkernel.layer1.representation.MultiRepresentationImpl;
import org.ten60.netkernel.layer1.meta.DependencyMeta;
import org.ten60.netkernel.layer1.transrepresentation.SimpleTransreptorImpl;

/**
 * LinkTableParser
 * @author  tab
 */
public class LinkTableParser extends NKFTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return aTo.isAssignableFrom(ILinkTableAspect.class);
	}

	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	try
		{	IAspectXDA xda = (IAspectXDA)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM, IAspectXDA.class);
			LinkTable table = new LinkTable(xda.getXDA());
			context.createResponseFrom(table).setCreationCost(32);
			
		} catch (XPathLocationException e)
		{	NetKernelException e2 = new NetKernelException("Failed to parse links");
			e2.addCause(e);
			throw e2;
		}
	}
	
}