/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: XSLTAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.12 $
  Last Modified: $Date: 2008/03/25 11:04:19 $
 *****************************************************************************/
package org.ten60.ura.xslt2;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import org.ten60.netkernel.layer1.util.SuperStackClassLoader;
import com.ten60.netkernel.util.PairList;
import java.util.*;
import org.xml.sax.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;
import org.ten60.netkernel.xml.representation.*;
import java.io.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.urii.*;
import java.net.*;

/**
 *  XSLT2 Accessor 
 */
public class XSLTAccessor extends NKFAccessorImpl
{
	public  XSLTAccessor()
	{	super(256, true, INKFRequestReadOnly.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	XSLT2TransformerAspect ta = (XSLT2TransformerAspect)context.sourceAspect("this:param:operator", XSLT2TransformerAspect.class);	
		// put values into transformer
		PairList params = new PairList(1);
		List paramNames = ta.getParameters();
		if (paramNames.size()>0)
		{	Iterator i=context.getThisRequest().getArguments();
			while(i.hasNext())
			{	String name=(String)i.next();
				if(!name.equals("operator") && !name.equals("operand"))
				{	params.put(name, getSource(context.getThisRequest().getArgument(name), context));
				}
			}
		}
		//Set outputURIresolver for XSLT2 secondary outputs
		//problem need to get the scratch path of the module containing the XSLT source!
		String cwu=context.getCWU();
		if(cwu==null)
		{	cwu=context.getThisRequest().getArgument("operator");
		}
		ta.setOutputURIResolver(new OutputURIResolverImpl(context.getKernelHelper().getOwningModule().getScratchDirURI(), context.getCWU()));
		Source source = getSource("this:param:operand",context);
		StringWriter sw = new StringWriter(1024);
		StreamResult sr = new StreamResult(sw);
		synchronized(ta)
		{	ta.transform(source, sr, getResolver(context), getClassLoader(context), params);
		}
		StringAspect aspect = new StringAspect(sw.toString());
		INKFResponse resp=context.createResponseFrom(aspect);
		resp.setMimeType(ta.getMimeType());
		context.setResponse(resp);
	}
	
	private ClassLoader getClassLoader(INKFConvenienceHelper aContext) throws Exception
	{	return new SuperStackClassLoader(aContext.getKernelHelper().getThisKernelRequest());

	}

	private URIResolver getResolver(INKFConvenienceHelper aContext)
	{	return new LocalURIResolver(aContext);
	}
	
	private Source getSource(String aURI, INKFConvenienceHelper aContext) throws Exception
	{	Source result=null;
		IURRepresentation resourceRep = aContext.source(aURI);
		TinyTreeAspect tta = (TinyTreeAspect)aContext.sourceAspect(aURI,TinyTreeAspect.class);
		return tta.getTree();
	}
	
	/**
	 * A local URI resolver that always produces a Stream Source
	 */
	class LocalURIResolver implements javax.xml.transform.URIResolver
	{	INKFConvenienceHelper mHelper;

		public LocalURIResolver(INKFConvenienceHelper aHelper)
		{	mHelper = aHelper;				
		}

		public Source resolve(String href, String base) throws TransformerException
		{	URI resource=URI.create(href);
			if(!resource.isAbsolute() && mHelper.getCWU()!=null)
			{	resource=URI.create(mHelper.getCWU()).resolve(resource);
			}
			try
			{	return getSource(resource.toString(), mHelper);
			}
			catch(Exception e)
			{	throw new TransformerException("Resource "+base+" "+href+" could not be accessed");
			}
		}
	}
}
