/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: XSLT2TransformerAspect.java,v $
 * Version:       $Name:  $ $Revision: 1.14 $
 * Last Modified: $Date: 2008/03/25 11:04:19 $
 *****************************************************************************/
package org.ten60.ura.xslt2;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.PairList;

import org.ten60.netkernel.xml.representation.IXAspect;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.ura.util.LocalErrorListener;
import net.sf.saxon.*;

import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.sax.*;
import org.xml.sax.*;
import org.w3c.dom.*;
import java.io.*;
import java.util.*;
import javax.xml.parsers.*;

/**
 * XSLTTransformerAspect
 * @author  tab
 */
public class XSLT2TransformerAspect implements IURAspect
{
	private Templates mTemplates;
	private Configuration mConfiguration;
	private List mParameters;
	private String mMime;
	private OutputURIResolver mOutputResolver;
	private static String SYNCH_LOCK="";
	private static final String TRANSFORMERFACTORY="javax.xml.transform.TransformerFactory";
	
	/** Creates a new instance of XSLTTransformerAspect */
	protected XSLT2TransformerAspect(IXAspect aXML, URIResolver aResolver, String aURI, Configuration aConfig) throws TransformerConfigurationException
	{	
		// get mime
		mMime ="text/xml";
		IXDAReadOnly xda=aXML.getXDA();
		try
		{	if(xda.isTrue("/*/xsl:output"))
			{	String method=xda.getText("/*/xsl:output/@method",false);
				if(method.equals("html")) mMime="text/html";
				else if(method.equals("text")) mMime="text/plain";
			}
		}
		catch(XPathLocationException e)
		{	//OK we have no output method
		}
		
		// get parameters
		mParameters = new ArrayList();
		try
		{	IXDAReadOnlyIterator i = xda.readOnlyIterator("/*/xsl:param[@name]");
			while (i.hasNext())
			{	i.next();
				String name = i.getText("@name",false);
				mParameters.add(name);
			}
		}
		catch(XPathLocationException e)
		{	//some of the params are malformed
		}
		
		//build the transformer
		synchronized(SYNCH_LOCK)
		{	net.sf.saxon.TransformerFactoryImpl tf=new net.sf.saxon.TransformerFactoryImpl(aConfig);
			mConfiguration = tf.getConfiguration();
			if (tf.getFeature(DOMSource.FEATURE))
			{	Source source = new DOMSource(aXML.getReadOnlyDocument());
				source.setSystemId(aURI);
				tf.setURIResolver(aResolver);
				mTemplates   = tf.newTemplates(source);
			}
			else throw new TransformerConfigurationException("DOMSource not accepted by transformer");
		}
	}
	
	public synchronized void transform(Source aSource, Result aResult, URIResolver aResolver, ClassLoader aLoader, PairList aParams) throws TransformerException, TransformerConfigurationException
	{	Transformer transformer = mTemplates.newTransformer();
		transformer.setErrorListener(new LocalErrorListener());
		transformer.clearParameters();
		transformer.setURIResolver(aResolver);
		mConfiguration.setClassLoader(aLoader);
		if (mOutputResolver!=null)
		{	net.sf.saxon.Controller Controller=(net.sf.saxon.Controller)transformer;
			Controller.setOutputURIResolver(mOutputResolver);	    
		}
		for (int i=0; i<aParams.size(); i++)
		{	net.sf.saxon.xpath.XPathEvaluator xe=new net.sf.saxon.xpath.XPathEvaluator(mConfiguration);
			transformer.setParameter((String)aParams.getValue1(i),xe.setSource((Source)aParams.getValue2(i)));
		}
		transformer.transform(aSource, aResult);
	}
	
	public List getParameters()
	{	return mParameters;
	}
	
	public String getMimeType()
	{	return mMime;
	}
	
	public void setOutputURIResolver(OutputURIResolver aResolver)
	{   //Need to Set OutputURIResolver for xsl:result output etc
	    mOutputResolver=aResolver;
	}
}
