/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: XMLToXSLTransformer.java,v $
 * Version:       $Name:  $ $Revision: 1.10 $
 * Last Modified: $Date: 2008/05/30 08:39:17 $
 *****************************************************************************/
package org.ten60.ura.xslt2;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.urii.aspect.IAspectBinaryStream;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.scheduler.*;
import com.ten60.netkernel.module.ModuleDefinition;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;

import org.ten60.netkernel.layer1.transrepresentation.ComplexTransreptorImpl;
import org.ten60.netkernel.layer1.meta.DependencyMeta;
import org.ten60.netkernel.layer1.representation.MultiRepresentationImpl;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.transrepresentation.DOMXDAParser;
import org.ten60.netkernel.xml.xda.*;
import com.ten60.netkernel.module.ModuleDefinition;

import net.sf.saxon.Configuration;
import javax.xml.transform.*;
import java.net.*;
import org.w3c.dom.*;

/**
 * XMLToXSLTransformer
 * @author  tab
 */
public class XMLToXSLTransformer extends NKFTransreptorImpl
{
	private static Configuration sConfig;
	
	public static Configuration getSharedSaxonConfiguration()
	{	if(sConfig==null)
		{	sConfig=new Configuration();			
		}
		return sConfig;
	}
	
	public void destroy()
	{	// safe to clearup static config here because this instance is a singleton
		sConfig=null;
	}
	
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return aTo.isAssignableFrom(XSLT2TransformerAspect.class);
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IXAspect from = (IXAspect)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM, IXAspect.class);
		try
		{	XSLT2TransformerAspect aspect;
			aspect = new XSLT2TransformerAspect(
				from,
				new StyleSheetResolver(context),
				context.getThisRequest().getURI(),
				getSharedSaxonConfiguration()
			);
			context.createResponseFrom(aspect).setCreationCost(32);
		} catch (TransformerConfigurationException e)
		{	NetKernelException nke = new NetKernelException("Failed to compile XSL");
			nke.addCause(e);
			throw nke;
		}
	}
	
	private class StyleSheetResolver implements URIResolver
	{	private INKFConvenienceHelper mContext;
		
		public StyleSheetResolver(INKFConvenienceHelper aContext)
		{	mContext = aContext;
		}
		
		public Source resolve(String href, String base) throws TransformerException
		{	URI resource=URI.create(href);
			try
			{	if(!resource.isAbsolute() && mContext.getThisRequest().getCWU()!=null)
				{	resource=URI.create(mContext.getThisRequest().getCWU().toString()).resolve(resource);
				}
				IURRepresentation resourceRep = mContext.source(resource.toString(), IAspectDOM.class);
				Document d = ((IAspectDOM)resourceRep.getAspect(IAspectDOM.class)).getReadOnlyDocument();
				return new javax.xml.transform.dom.DOMSource(d);
			}
			catch(Exception e)
			{	System.out.println(e.toString());
				throw new TransformerException("Resource "+href+" could not be accessed");
			}
		}
	}
}