package org.ten60.ura.xslt2;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.XMLUtils;
import org.ten60.netkernel.xml.xda.*;

import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.NetKernelException;

import org.apache.xml.serializer.*;
import javax.xml.transform.*;
import javax.xml.transform.sax.*;
import javax.xml.transform.stream.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.io.*;
import java.util.*;
import org.w3c.dom.*;

import net.sf.saxon.*;
import net.sf.saxon.om.*;
import net.sf.saxon.tinytree.*;
import net.sf.saxon.trans.*;
import net.sf.saxon.xpath.*;

/**
 * Creates a DOM from a TinyTree Aspect
 * @author maw
 */
public class TinyTree2DOM extends NKFTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( aFrom.hasAspect(TinyTreeAspect.class) && (aTo.isAssignableFrom(DOMXDAAspect.class) || aTo.isAssignableFrom(IAspectXDA.class)));
	}
	
	public void transrepresent(INKFConvenienceHelper aContext) throws NetKernelException
	{	try
		{	TinyTreeAspect tta = (TinyTreeAspect)aContext.sourceAspect(INKFRequestReadOnly.URI_SYSTEM,TinyTreeAspect.class);

			StringWriter     w = new StringWriter(2048);

			net.sf.saxon.TransformerFactoryImpl tfi =new net.sf.saxon.TransformerFactoryImpl(XMLToXSLTransformer.getSharedSaxonConfiguration());
            TransformerFactory tfactory = tfi.newInstance();
            Transformer serializer = tfactory.newTransformer();
            serializer.transform(tta.getTree(), new StreamResult(w));

            w.flush();

			Document d = XMLUtils.getInstance().parse(new StringReader(w.toString()));
            DOMXDA domXDA = new DOMXDA(d,false);
            IURAspect aspect = new DOMXDAAspect(domXDA);
			
			aContext.createResponseFrom(aspect).setCreationCost(32);
		} catch (Exception e)
		{	NetKernelException nke = new NetKernelException("Unhandled Exception in TinyTree2DOM");
			nke.addCause(e);
			throw nke;
		}
	}
}
