/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: DumpAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.2 $
  Last Modified: $Date: 2005/01/21 16:41:15 $
 *****************************************************************************/
package org.ten60.ura.sys;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.IAspectBinaryStream;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;

import java.util.*;
import java.io.*;
import java.net.*;

/**
 *
 * @author  pjr
 */
public class DumpAccessor extends XAccessor
{
	
	/** Creates a new instance of DumpAccessor */
	public DumpAccessor()
	{	declareArgument(OPERATOR, false, false);
		declareArgument(OPERAND, true, true);
	}
	
	/** Abstract method to be implemented in subclass.
	 * @return Either the result as a Document or a Reader.
	 * @param aHelper The helper class that provides access to the operator,
	 * operand, and parameters.
	 * @throws AccessViolationException Thrown if we fail to access any of the beans
	 * @throws DocumentAccessorException Thrown if we fail for any reason.
	 *
	 */
	public IURRepresentation source(XAHelper aHelper) throws Exception
	{	String dir, ext;
		if(aHelper.hasOperator())
		{	IXDAReadOnly opt=aHelper.getOperator().getXDA();
			try{
				dir=opt.getText("/path", true);
			}
			catch(Exception e){
				try{
					dir=opt.getText("/target/path", true);
				}
				catch(Exception ee){
					dir="/xtmp/log";
				}
			}
			try{
				ext=opt.getText("/target/extension", true);
			}
			catch(Exception e){
				ext="xml";
			}
		}
		else {
			dir="/xtmp/log";
			ext="xml";
		}
		URI path=URI.create("ffcpl:"+dir);
		Date d=new Date();
		Calendar cal=Calendar.getInstance();
		String filename="dumplog"+cal.get(cal.YEAR)+cal.get(cal.MONTH)+cal.get(cal.DAY_OF_MONTH)+cal.get(cal.HOUR_OF_DAY)+cal.get(cal.MINUTE)+cal.get(cal.SECOND)+cal.get(cal.MILLISECOND)+"."+ext;
		path=path.resolve(filename);
		
		IURRepresentation p=aHelper.getOperand(IAspectBinaryStream.class);
		aHelper.setResource(path, p);
		IURMeta meta=aHelper.getDependencyMeta("text/xml", 4);
		IURAspect aspect = new StringAspect("<uri>"+path+"</uri>");
		return new MonoRepresentationImpl(meta,aspect);
	}
}
