/******************************************************************************
  (c) Copyright 2002-2004, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: BeanShellEngine2.java,v $
  Version:       $Name:  $ $Revision: 1.14 $
  Last Modified: $Date: 2004/12/07 13:53:12 $
 *****************************************************************************/
package org.ten60.netkernel.script.engine;

import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.urii.IURRepresentation;

import org.ten60.netkernel.layer1.nkf.INKFConvenienceHelper;
import org.ten60.netkernel.script.representation.IScriptEngine;
import org.ten60.netkernel.layer1.util.SuperStackClassLoader;

import bsh.*;
import java.io.*;

/**
 * Beanshell script engine requiring a main method to aid efficiency
 * @author  tab
 */
public class BeanShellEngine2 implements IScriptEngine
{   
    private Interpreter mInterpreter;
	private ClassLoader mLastClassLoader;
	private static boolean sOneshot;
    
	public synchronized void execute(INKFConvenienceHelper aContext, ClassLoader aClassLoader) throws Exception
	{	ClassLoader cl=Thread.currentThread().getContextClassLoader();
		try
		{   mInterpreter.set("context", aContext);
			if (mLastClassLoader==null || !mLastClassLoader.equals(aClassLoader))
			{	// reuse same classloader if it hasn't changed- big performance boost
				mLastClassLoader=aClassLoader;
				mInterpreter.setClassLoader(mLastClassLoader);
			}
			Thread.currentThread().setContextClassLoader(mLastClassLoader);
			mInterpreter.eval("main();");
		}
		catch(TargetError e)
		{	Throwable t = e.getTarget();
			if (!(t instanceof Error))
			{	NetKernelException n=new NetKernelException("Unhandled Exception in BeanShellEngine", e.getMessage(), "line: "+e.getErrorLineNumber());
				n.addCause(e.getTarget());
				throw n;
			}
			else
			{	throw (Error)t;
			}
		}
		catch (bsh.EvalError e)
		{	NetKernelException n=new NetKernelException("Unhandled Exception in BeanShellEngine", e.getMessage(), "line: "+e.getErrorLineNumber());
			n.addCause(e);
			throw n;
		}
		finally
		{	mInterpreter.set("context", Boolean.FALSE);
			Thread.currentThread().setContextClassLoader(cl);
		}
	}
	
	public void initialise(String aScript, INKFConvenienceHelper aContext, ClassLoader aClassLoader) throws Exception
	{	if (!sOneshot)
		{	Interpreter i=new Interpreter();
			sOneshot=true;
		}
		
		mInterpreter=new Interpreter();
		ClassLoader cl=aClassLoader;
		mInterpreter.setClassLoader(cl);
		mInterpreter.set("context", aContext);
		Thread.currentThread().setContextClassLoader(cl);
		try
		{   mInterpreter.eval(aScript);
		}
		catch(TargetError e)
		{	NetKernelException n=new NetKernelException("Unhandled Exception in BeanShellEngine", e.getMessage(), "line: "+e.getErrorLineNumber());
			n.addCause(e.getTarget());
			throw n;
		}
	}
	
	public void finalize()
	{	
		((SuperStackClassLoader)mLastClassLoader).cleanup();
		mLastClassLoader=null;
		mInterpreter.setNameSpace(null);
		mInterpreter.setClassLoader(getClass().getClassLoader().getSystemClassLoader());
		try
		{	mInterpreter.set("context", Boolean.FALSE);
		} catch (EvalError e)
		{	// ignore
		}
		mInterpreter=null;
	}
}