/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: Utils.java,v $
  Version:       $Name:  $ $Revision: 1.5 $
  Last Modified: $Date: 2004/09/03 14:38:32 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.util;

import java.text.*;
import java.util.*;
import java.io.*;

/** General utility methods
 * @author tab
 */
public class Utils
{
    static String major;
    static String minor;
    static String minorminor;
	
    /**
     * Static intialised to get JVM version
     */
    static{
        String jre_version=System.getProperty("java.version");
        StringTokenizer st=new StringTokenizer(jre_version,".");
        if(st.countTokens()>=3){
            major=st.nextToken();
            minor=st.nextToken();
            minorminor=st.nextToken();
       }
    }
    
    private static final DateFormat sTimeStampFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");

    /** Returns a standard format Timestamp String representing the gi8ven date.
     * @param aDate The date to create the timestamp string for.
     * @return The timestamp string.
     */    
    public static String getTimeStampString(Date aDate)
    {   return sTimeStampFormat.format(aDate);
    }
     
    /** Returns a string with the \ replaced by /
    */
    public static String fixSlash(String uri){
        return uri.replace('\\','/');
    }
    
    /** @return the JRE major version */
    public static int getJREMajorVersion(){
        int result=0;
        try{
            result=Integer.parseInt(major);
        }
        catch(Exception e){
            e.printStackTrace();
        }        
        return result;
    }
    
    /** @return the JRE minor version */
    public static int getJREMinorVersion(){
        int result=0;
        try{
            result=Integer.parseInt(minor);
        }
        catch(Exception e){
            e.printStackTrace();
        }
        return result;
    }
    
    /** @return the JRE minor minor version */
    public static int getJREMinorMinorVersion(){
        int result=0;
        try{
            result=Integer.parseInt(minorminor);
        }
        catch(Exception e){
            e.printStackTrace();
        }
        return result;
    }
	
	/** copy an input stream to an outputsteam and close streams when finished
	 * @throws IOException if there are any problems
	 */
	public static void pipe(InputStream aInput, OutputStream aOutput) throws IOException
	{	byte b[] = new byte[256];
		int c;
		try
		{	while ( (c=aInput.read(b))>0 )
			{	aOutput.write(b,0,c);
			}
		}
		finally
		{	try
			{	aInput.close();
			}
			finally
			{	aOutput.close();
			}
		}
	}	
}