/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: BinaryStreamToString.java,v $
  Version:       $Name:  $ $Revision: 1.5 $
  Last Modified: $Date: 2004/08/20 11:23:38 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.transrepresentation;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.aspect.IAspectBinaryStream;
import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;
import com.ten60.netkernel.urii.aspect.StringAspect;

import org.ten60.netkernel.layer1.nkf.INKFConvenienceHelper;
import org.ten60.netkernel.layer1.nkf.INKFRequestReadOnly;
import org.ten60.netkernel.layer1.nkf.INKFResponse;
import org.ten60.netkernel.layer1.nkf.impl.NKFTransreptorImpl;

import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
/**
 * Read and input stream, assuming character data, into an in-memory String
 * @author  tab
 */
public class BinaryStreamToString extends NKFTransreptorImpl
{	
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( aFrom.hasAspect(IAspectBinaryStream.class) && ( aTo.isAssignableFrom(StringAspect.class)) );
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IURRepresentation aFrom = context.source(INKFRequestReadOnly.URI_SYSTEM);
		String result;
		if (aFrom.hasAspect(IAspectReadableBinaryStream.class))
		{	// create from readable binary stream
			IAspectReadableBinaryStream bs = (IAspectReadableBinaryStream)aFrom.getAspect(IAspectReadableBinaryStream.class);
			String encoding = bs.getEncoding();
			if (encoding==null) encoding="UTF-8";
			InputStreamReader br = new InputStreamReader(bs.getInputStream(),encoding);
			int length = bs.getContentLength();
			char[] buffer = new char[length];
			br.read(buffer,0, length);
			result = new String(buffer);
		}
		else
		{	// create from regular binary stream
			IAspectBinaryStream bs = (IAspectBinaryStream)aFrom.getAspect(IAspectBinaryStream.class);
			ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
			bs.write(baos);
			String encoding = bs.getEncoding();
			if (encoding==null) encoding="UTF-8";
			result = baos.toString(encoding);		
		}
		INKFResponse response = context.createResponseFrom(new StringAspect(result));
		response.setCreationCost(4);
		response.setMimeType(aFrom.getMeta().getMimeType());
		context.setResponse(response);
	}
}