/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: MultiPartAspect.java,v $
  Version:       $Name:  $ $Revision: 1.7 $
  Last Modified: $Date: 2004/09/01 10:46:30 $
 *****************************************************************************/

package org.ten60.netkernel.layer1.representation;
import com.ten60.netkernel.urii.*;
import org.ten60.netkernel.layer1.meta.*;

import java.util.*;

/**
 * Aspect for holding multiple sub-representations.
 * <br/>Usage example see HTTP cookies
 * @author  tab
 */
public class MultiPartAspect implements IAspectMultipart
{
	private Map mParts;
	
	
	public MultiPartAspect()
	{	this(new HashMap());
	}
	
	/** Creates a new instance of MultiPartAspect
	  * @param aOthers a map of named IURRepresentations
	 */
	public MultiPartAspect(Map aParts)
	{	mParts=aParts;
		Iterator i=mParts.keySet().iterator();
		while(i.hasNext())
		{	Object key=i.next();
			if(! ( key instanceof String) ) throw new IllegalArgumentException("Map keys must be String");
			else if(!( mParts.get(key) instanceof IURRepresentation ) ) throw new IllegalArgumentException("One of the Map Entries is not an IURRepresentation");
		}
	}
	
	/**
	 * Add a named part.
	 */
	public void addPart(String aName, IURRepresentation aPart)
	{	if(mParts.get(aName)==null)
		{	mParts.put(aName, aPart);
		}
		else throw new IllegalArgumentException("Name "+aName+" has already been taken");
	}
	
	/** @returns an IURRepresentation
	 */
	public IURRepresentation getPartWithName(String aName)
	{	return (IURRepresentation)mParts.get(aName);
	}
	
	/** @returns a String[] of part names
	 */
	public String[] getPartNames()
	{	int size=mParts.keySet().size();
		String[] names=new String[size];
		Iterator it=mParts.keySet().iterator();
		int i=0;
		while(it.hasNext())
		{	names[i]=(String)it.next();
			i++;
		}
		return names;
	}
	
	/** @returns an array of IURRepresentation subparts
	 */
	public IURRepresentation[] getParts()
	{	int size=mParts.values().size();
		IURRepresentation[] parts=new IURRepresentation[size];
		Iterator it=mParts.values().iterator();
		int i=0;
		while(it.hasNext())
		{	parts[i]=(IURRepresentation)it.next();
			i++;
		}
		return parts;
	}
	
	
	/** A convenience helper to create an IURRepresentation with all aspects from the primary plus
	 * a MultiPartAspect containing the list of other aspects
	 */
	public static IURRepresentation create(IURRepresentation aPrimary, Map aOthers)
	{	IURMeta pmeta = aPrimary.getMeta();
		DependencyMeta meta = new DependencyMeta(pmeta.getMimeType(), 2,0);
		meta.addDependency(aPrimary);
		for (Iterator i=aOthers.entrySet().iterator(); i.hasNext(); )
		{	IURRepresentation item=(IURRepresentation)(((Map.Entry)i.next()).getValue());
			meta.addDependency(item);
		}
		MultiRepresentationImpl rep = new MultiRepresentationImpl(meta, 2);
		rep.addAspectsOf(aPrimary);
		rep.addAspect(new MultiPartAspect(aOthers));
		return rep;
	}
}