<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>
	<xsl:param name="param"/>
	
	<xsl:key name="modules" match="/modules/module" use="concat(uri,version)"/>
	
    <xsl:template match="/modules">
		<modules>
			<xsl:for-each select="/modules/module[generate-id(.)=generate-id(key('modules',concat(uri,version)))]">
				<xsl:variable name="uri" select="uri/text()"/>
				<xsl:variable name="version" select="version/text()"/>
				<xsl:for-each select="$param/modules/module[identity/uri=$uri and identity/version=$version]">
					<xsl:call-template name="module"/>
				</xsl:for-each>
			</xsl:for-each>
		</modules>
    </xsl:template>
	
	<xsl:template name="module">
		<module>
			<uri><xsl:value-of select="identity/uri"/></uri>
			<version><xsl:value-of select="identity/version"/></version>
			<name><xsl:value-of select="info/name"/></name>
			<desc><xsl:value-of select="info/description"/></desc>
			<xsl:if test="info/editable='true'">
				<editable/>
			</xsl:if>
		</module>
	</xsl:template>

</xsl:stylesheet> 
