/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: InitAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.5 $
 * Last Modified: $Date: 2004/08/05 10:39:42 $
 *****************************************************************************/
package org.ten60.netkernel.ext_install;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;

import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.module.ModuleManager;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.NetKernelException;

import java.net.*;
import org.w3c.dom.*;
/**
 *	Init process, detects changes in installed modules and runs
 * entrypoint on first install
 * @author  tab
 */
public class InitAccessor extends XAccessor
{
	public static final URI INSTALL_STATUS_URI=URI.create("ffcpl:/org/ten60/netkernel/ext_install/pub/status.xml");
	private static final URI MODULE_MANAGER_URI=URI.create(ModuleManager.URI.toString());
	
	protected IURRepresentation source(XAHelper aHelper) throws Exception
	{	
		String type = aHelper.getType();
		IURRepresentation result;
		if (type.endsWith("install"))
		{	result = install(aHelper);
		}
		else if (type.endsWith("postInstall"))
		{	result = postInstall(aHelper);
		}
		else
		{	throw new NetKernelException("Unsupported operation",null, type);
		}
		return result;
	}
	
	private IURRepresentation install(XAHelper aHelper) throws Exception
	{		
		IXDAReadOnly status = aHelper.getXResource(INSTALL_STATUS_URI).getXDA();
		IXDAReadOnly modules = aHelper.getXResource(MODULE_MANAGER_URI).getXDA();
		Document resultDoc = XMLUtils.newDocument();
		DOMXDA result = new DOMXDA(resultDoc,false);
		result.appendPath("/", "modules", null);
		// find all new modules
		for (IXDAReadOnlyIterator i = modules.readOnlyIterator("/modules/module"); i.hasNext(); )
		{	i.next();
			String uri = i.getText("identity/uri",true);
			String version = i.getText("identity/version",true);
			long timestamp = Long.parseLong(i.getText("info/timestamp",true));
			String match = "/modules/module[uri='"+uri+"' and version='"+version+"' and status!='removed']";
			boolean justInstalled = !status.isTrue(match);
			String statusText = justInstalled?"new":"stable";
			if (!justInstalled)
			{	match+="/timestamp";
				long oldTimestamp = Long.parseLong(status.getText(match, true));
				if (timestamp>oldTimestamp)
				{	statusText="modified";
				}
			}
				
			result.appendPath("/modules", "module/uri", uri);
			IXDAIterator module = result.iterator("/modules/module[last()]");
			module.appendPath(".", "version", version);
			module.appendPath(".", "status", statusText);
			module.appendPath(".", "timestamp", Long.toString(timestamp));
			
			if (justInstalled)
			{	// do install stuff here
			}
		}
		// find all removed modules
		for (IXDAReadOnlyIterator i = status.readOnlyIterator("/modules/module[status!='removed']"); i.hasNext(); )
		{	i.next();
			String uri = i.getText("uri",true);
			String version = i.getText("version",true);
			String match = "/modules/module[uri='"+uri+"' and version='"+version+"']";
			boolean removed = !result.isTrue(match);
			if (removed)
			{
				result.appendPath("/modules", "module/uri", uri);
				IXDAIterator module = result.iterator("/modules/module[last()]");
				module.appendPath(".", "version", version);
				module.appendPath(".", "status", "removed");
			}
		}
		IURMeta meta = new AlwaysExpiredMeta("text/xml", 0);
		aHelper.setResource(INSTALL_STATUS_URI, DOMXDAAspect.create(meta, result));
		return VoidAspect.create();
	}	
	
	private IURRepresentation postInstall(XAHelper aHelper) throws Exception
	{
		IXDAReadOnly status = aHelper.getXResource(INSTALL_STATUS_URI).getXDA();
		for (IXDAReadOnlyIterator i = status.readOnlyIterator("/modules/module[status='new']"); i.hasNext(); )
		{	i.next();
			String uri = i.getText("uri",true);
			String version = i.getText("version",true);
			CompoundURIdentifier entrypointURI = new CompoundURIdentifier("active","entrypoint");
			entrypointURI.addArg("module", uri);
			entrypointURI.addArg("version", version);
			entrypointURI.addArg("name", "postInstall");
			try
			{	aHelper.getResource(entrypointURI.toJavaURI(), IURAspect.class);
			} catch (NetKernelException e)
			{	// no postInstall for this module
			}
		}
		return VoidAspect.create();
	}
}