<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_license_FAQ.xsl
    Created on : 22 April 2003, 12:46
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/section">
		<table width="600">
		<tr><td>
		<a name="menu"><hr/></a>
		<xsl:apply-templates select="content/faq"/>
		</td></tr>
		</table>
    </xsl:template>
	
	<xsl:template match="faq">
		<xsl:for-each select="group">
			<xsl:call-template name="groupmenu"/>
		</xsl:for-each>
		<xsl:for-each select="group">
			<xsl:call-template name="group"/>
		</xsl:for-each>
    </xsl:template>
	
	<xsl:template name="groupmenu">
		<h2><xsl:value-of select="title"/></h2>
		<ul>
			<xsl:for-each select="item">
				<xsl:call-template name="menuitem"/>
			</xsl:for-each>
		</ul>
	</xsl:template>
	
	<xsl:template name="menuitem">
		<li>
			<a>
			<xsl:attribute name="href">#<xsl:value-of select="name"/>
			</xsl:attribute>
			<xsl:value-of select="title"/>
			</a>
		</li>
	</xsl:template>
    
	<xsl:template name="group">
		<h1><xsl:value-of select="title"/></h1>
		<xsl:for-each select="item">
				<xsl:call-template name="item"/>
			</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="item">
			<a>
			<xsl:attribute name="name">
			<xsl:value-of select="name"/>
			</xsl:attribute>
			<h2>
			<xsl:value-of select="title"/>
			</h2>
			</a>
			<xsl:copy-of select="content/*"/>
			<a href="#menu">[top]</a>
	</xsl:template>
	
</xsl:stylesheet> 
