/*
 * CaseAccessor.java
 *
 */

package org.ten60.netkernel.demo.sax;

import com.ten60.netkernel.urii.*;
import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;

import org.ten60.netkernel.xml.util.XMLUtils;
import org.ten60.netkernel.layer1.meta.DependencyMeta;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 * Case Accessor changes case of all text entries an XML document
 */
public class CaseAccessor extends XAccessor
{
	
	/** Creates a new instance of CaseAccessor */
	public CaseAccessor()
	{	declareArgument(OPERAND, true, false);
		declareArgument(OPERATOR, false, false);
		declareThreadSafe();
	}
	
	/**source request**/
	protected IURRepresentation source(XAHelper aHelper) throws Exception
	{	
		IURRepresentation operandRep = aHelper.getOperand(IAspectSAX.class);
		IAspectSAX operandSAX = (IAspectSAX)operandRep.getAspect(IAspectSAX.class);
		
		//boolean toUpper=true;
		//if (aHelper.hasOperator())
		//{   toUpper = aHelper.getOperator().getXDA().isTrue("/case[text()=='upper']");
		//}
		
		XMLFilterImpl filter = new XMLFilterImpl()
		{	public void characters(char[] ch, int start, int length) throws SAXException
			{	for (int i=start; i<start+length; i++)
				{	ch[i]=Character.toUpperCase(ch[i]);
				}
				super.characters(ch,start,length);
			}
		};
		
		DependencyMeta meta = new DependencyMeta(operandRep.getMeta().getMimeType(), 2, 8);
		meta.addUsageDependency(operandRep);
		return SAXFilterAspect.create(meta, operandSAX, filter);
		
		
	}
}
