<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
	<xsl:output method="xml" omit-xml-declaration="no"/>
	
<xsl:template match="/">
	<xsl:call-template name="exception"/>
</xsl:template>
	
	
<xsl:template name="exception">
	<div>
		<script language="JavaScript">
		<xsl:comment>
		function showException()
		{	if (document.getElementById( 'exception' ).style.visibility=="visible")
			{	document.getElementById( 'exception' ).style.visibility= "hidden";
			}
			else
			{	document.getElementById( 'exception' ).style.visibility= "visible";
			}
		}
		</xsl:comment>
		</script>
	
		<table border="0" cellspacing="0" cellpadding="2">
		<tr>
		<td valign="top"><img src="[[xrl:img_bugxter_error]]" xrl:resolve="src"/></td>
		<td>
		<xsl:variable name="deepest" select="/descendant::ex[count(/descendant::ex)]"/>
		<xsl:variable name="id" select="$deepest/id"/>
		<xsl:variable name="message" select="$deepest/message"/>
		<xsl:variable name="idoc-level" select="(//ex[id='Unhandled exception in DPML'])[last()]"/>
		<xsl:variable name="idoc" select="$idoc-level/requestid"/>
		<xsl:variable name="instr" select="$idoc-level/message"/>

		<p><br/>
		<xsl:choose>
			<xsl:when test="$id='com.ten60.netkernel.util.NetKernelException'">
				<font size="+1" color="#CC0000"><b><xsl:value-of select="$message"/></b></font>
			</xsl:when>
			<xsl:otherwise>
				<font size="+1" color="#CC0000"><b><xsl:value-of select="$id"/></b></font>
				<br/><xsl:value-of select="$message"/>
			</xsl:otherwise>
		</xsl:choose>
		</p>


		<xsl:if test="$idoc">
			executing instruction<br/><code><xsl:value-of select="$instr"/></code>
			<br/>in idoc<br/><code><xsl:value-of select="$idoc"/></code>
		</xsl:if>

		<p><br/><a href="{requestURI}">Retry</a> the request.</p>

		<p>A detailed exception trace is available, please report this
		to the system adminstrator or use it to identify the source of
		the problem. <a href="javascript:showException()">Click Here.</a>
		<div id="exception" style="width:75%; visibility:hidden; background-color:black; padding:2">

		<table border="0" cellspacing="0" width="100%">
				<tr><td bgcolor="black" colspan="2">
					<font color="white"><b>Detailed Exception Trace</b></font>
				</td></tr>
				<xsl:apply-templates select="ex"/>
		</table>
		</div></p>
		</td></tr></table>

	</div>
	</xsl:template>

	
	<xsl:template match="ex">
			<tr bgcolor="black"><td colspan="2"/></tr>
			<xsl:if test="id">
				<tr bgcolor="#E0D0FF"><td valign="top" align="right">Id:</td><td><xsl:value-of select="id"/></td></tr>
			</xsl:if>
			<xsl:if test="string-length(message)>0">
				<tr bgcolor="FFFFFF"><td valign="top" align="right">Message:</td><td><xsl:value-of select="message"/></td></tr>
			</xsl:if>
			<xsl:if test="requestid">
				<tr bgcolor="FFFFFF"><td valign="top" align="right">Request:</td>
				<td>
					<xsl:call-template name="wrapped">
						<xsl:with-param name="text" select="requestid"/>
					</xsl:call-template>
				</td></tr>
			</xsl:if>
			<xsl:if test="stack">
				<tr bgcolor="FFFFFF"><td valign="top" align="right" width="0%">Callstack:</td><td>
					<table cellpadding="0" cellspacing="0">
						<xsl:apply-templates select="stack"/>
					</table>
				</td></tr>
			</xsl:if>
			<xsl:if test="trace">
				<tr bgcolor="FFFFFF"><td valign="top" align="right" width="0%">Trace:</td><td>
				<xsl:apply-templates select="trace"/>
				</td></tr>
			</xsl:if>
			<xsl:apply-templates select="ex"/>
	</xsl:template>
	
	<xsl:template match="stack">
		<xsl:apply-templates select="level"/>
	</xsl:template>
	
	<xsl:template match="level">
		<tr><td><font size="-2"><xsl:value-of select="."/></font></td></tr>
	</xsl:template>
	

	
	<xsl:template name="path">
		<xsl:param name="text"/>
		<span class="code">
			<xsl:call-template name="subpath">
				<xsl:with-param name="text" select="$text"/>
			</xsl:call-template>
		</span>
	</xsl:template>
	
	<xsl:template name="subpath">
		<xsl:param name="text"/>
		<xsl:choose>
			<xsl:when test="contains($text,'/')">
				<xsl:value-of select="substring-before($text,'/')"/>/<wbr/><xsl:call-template name="subpath">
					<xsl:with-param name="text" select="substring-after($text,'/')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="wrapped">
		<xsl:param name="text"/>
		<xsl:choose>
			<xsl:when test="string-length($text)>60">
				<xsl:value-of select="substring($text,1,60)"/><wbr/><xsl:call-template name="wrapped">
					<xsl:with-param name="text" select="substring($text,60+1)"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="trace">
		<table cellpadding="0" cellspacing="0">
			<xsl:apply-templates select="step"/>
		</table>
	</xsl:template>
	  
	<xsl:template match="step">
		<tr><td><font size="-2"><xsl:value-of select="."/></font></td></tr>
	</xsl:template>

</xsl:stylesheet>

