<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xforms="http://www.w3.org/2002/xforms"
    xmlns:chiba="http://chiba.sourceforge.net/2003/08/xforms"
    xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:xrl="http://1060.org/xrl"
    exclude-result-prefixes="chiba xforms xlink xsl">

    <xsl:variable name="data-prefix" select="'d_'" />
    <xsl:variable name="trigger-prefix" select="'t_'"/>
    <xsl:param name="scripted" select="'false'"/>

    <!-- This stylesheet contains a collection of templates which map XForms controls to HTML controls. -->
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

    <!-- ######################################################################################################## -->
    <!-- This stylesheet serves as a 'library' for HTML form controls. It contains only named templates and may   -->
    <!-- be re-used in different layout-stylesheets to create the naked controls.                                 -->
    <!-- ######################################################################################################## -->

    <!-- build input control -->
    <xsl:template name="input">

<!--        <xsl:if test="chiba:data/@chiba:enabled != 'false'">-->

            <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
            <xsl:variable name="pos" select="position()"/>
            <xsl:variable name="id" select="@id" />

            <xsl:if test="$debug-enabled='true'">
                <xsl:message>###repeat-id:
                    <xsl:value-of select="$repeat-id"/>
                </xsl:message>
                <xsl:message>###has repeat-id:
                    <xsl:value-of select="boolean(string-length($repeat-id) > 0)"/>
                </xsl:message>
                <xsl:message>###position:
                    <xsl:value-of select="position()"/>
                </xsl:message>
            </xsl:if>

            <xsl:element name="input">
                <xsl:attribute name="id"><xsl:value-of select="concat($id,'-value')"/></xsl:attribute>
                <xsl:attribute name="name">
                    <xsl:value-of select="concat($data-prefix,$id)"/>
                </xsl:attribute>
                <xsl:attribute name="type">text</xsl:attribute>
                <xsl:attribute name="value">
                    <xsl:value-of select="chiba:data/text()"/>
                </xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:value-of select="normalize-space(xforms:hint)"/>
                </xsl:attribute>
                <xsl:if test="chiba:data/@chiba:readonly='true'">
                    <xsl:attribute name="readonly">true</xsl:attribute>
                </xsl:if>
                <xsl:call-template name="assembleRepeatClasses">
                    <xsl:with-param name="repeat-id" select="$repeat-id"/>
                    <xsl:with-param name="pos" select="$pos"/>
                    <xsl:with-param name="classes" select="'value'"/>
                </xsl:call-template>
                <xsl:if test="$scripted='true'">
                    <xsl:attribute name="onchange">javascript:setXFormsValue('<xsl:value-of select="$id"/>');</xsl:attribute>
                </xsl:if>
            </xsl:element>

<!--
            <xsl:if test="chiba:data/@chiba:required='true'">
                <span class="required-symbol">*</span>
            </xsl:if>
-->
<!--        </xsl:if>-->
    </xsl:template>

    <!-- build image trigger / submit -->
    <xsl:template name="image-trigger">
        <xsl:element name="input">
            <xsl:variable name="id" select="@id" />
            <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
            <xsl:attribute name="id"><xsl:value-of select="concat($id,'-value')"/></xsl:attribute>
            <xsl:attribute name="name">
                <xsl:value-of select="concat($trigger-prefix,$id)"/>
            </xsl:attribute>
            <xsl:attribute name="type">image</xsl:attribute>
            <xsl:attribute name="value">
                <xsl:value-of select="xforms:label"/>
            </xsl:attribute>
            <xsl:attribute name="title">
                <xsl:value-of select="normalize-space(xforms:hint)"/>
            </xsl:attribute>
            <xsl:attribute name="src">
                <xsl:value-of select="xforms:label/@xlink:href"/>
            </xsl:attribute>
            <xsl:attribute name="class">image-trigger-widget value</xsl:attribute>
            <xsl:if test="chiba:data/@chiba:readonly='true'">
                <xsl:attribute name="readonly">true</xsl:attribute>
            </xsl:if>
            <xsl:if test="$scripted='true'">
                <xsl:attribute name="onclick">javascript:activate('<xsl:value-of select="$id"/>');</xsl:attribute>
            </xsl:if>
<!--            <xsl:call-template name="eval-actions"/>-->
        </xsl:element>

    </xsl:template>

    <!-- build output -->
    <xsl:template name="output">
<!--        <xsl:if test="chiba:data/@chiba:enabled != 'false'">-->

<!--            <span class="output value">-->
            <xsl:element name="span">
                <xsl:attribute name="id"><xsl:value-of select="concat(@id,'-value')"/></xsl:attribute>
                <xsl:value-of select="chiba:data/text()"/>
            </xsl:element>
<!--        </xsl:if>-->
    </xsl:template>

    <!-- build range -->
    <xsl:template name="range">
<!--        <xsl:if test="chiba:data/@chiba:enabled != 'false'">-->
            <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
            <xsl:variable name="pos" select="position()"/>
            <xsl:variable name="id" select="@id" />

            <xsl:if test="$debug-enabled='true'">
                <xsl:message>WARN: range not supported yet</xsl:message>
            </xsl:if>
            <xsl:element name="input">
                <xsl:attribute name="id"><xsl:value-of select="concat($id,'-value')"/></xsl:attribute>
                <xsl:attribute name="name">
                    <xsl:value-of select="concat($data-prefix,$id)"/>
                </xsl:attribute>
                <xsl:attribute name="type">text</xsl:attribute>
                <xsl:attribute name="value">WARN: range not supported yet</xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:value-of select="normalize-space(xforms:hint)"/>
                </xsl:attribute>
                <xsl:call-template name="assembleRepeatClasses">
                    <xsl:with-param name="repeat-id" select="$repeat-id"/>
                    <xsl:with-param name="pos" select="$pos"/>
                    <xsl:with-param name="classes" select="'value'"/>
                </xsl:call-template>
                <xsl:if test="$scripted='true'">
                    <xsl:attribute name="onchange">javascript:setXFormsValue('<xsl:value-of select="$id"/>');</xsl:attribute>
                </xsl:if>
            </xsl:element>

<!--
            <xsl:if test="chiba:data/@chiba:required='true'">
                <font color="red">*</font>
            </xsl:if>
-->
<!--        </xsl:if>-->
    </xsl:template>

    <!-- build secret control -->
    <xsl:template name="secret">
        <xsl:param name="maxlength"/>

<!--        <xsl:if test="chiba:data/@chiba:enabled != 'false'">-->
            <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
            <xsl:variable name="pos" select="position()"/>
            <xsl:variable name="id" select="@id" />

            <xsl:element name="input">
                <xsl:attribute name="id"><xsl:value-of select="concat($id,'-value')"/></xsl:attribute>
                <xsl:attribute name="name">
                    <xsl:value-of select="concat($data-prefix,$id)"/>
                </xsl:attribute>
                <xsl:attribute name="type">password</xsl:attribute>
                <xsl:attribute name="value">
                    <xsl:value-of select="chiba:data/text()"/>
                </xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:value-of select="normalize-space(./xforms:hint)"/>
                </xsl:attribute>
                <xsl:if test="$maxlength">
                    <xsl:attribute name="maxlength">
                        <xsl:value-of select="$maxlength"/>
                    </xsl:attribute>
                </xsl:if>
                <xsl:if test="chiba:data/@chiba:readonly='true'">
                    <xsl:attribute name="readonly">true</xsl:attribute>
                </xsl:if>
                <xsl:call-template name="assembleRepeatClasses">
                    <xsl:with-param name="repeat-id" select="$repeat-id"/>
                    <xsl:with-param name="pos" select="$pos"/>
                    <xsl:with-param name="classes" select="'value'"/>
                </xsl:call-template>
                <xsl:if test="$scripted='true'">
                    <xsl:attribute name="onchange">javascript:setXFormsValue('<xsl:value-of select="$id"/>');</xsl:attribute>
                </xsl:if>
            </xsl:element>

<!--
            <xsl:if test="chiba:data/@chiba:required='true'">
                <font color="red">*</font>
            </xsl:if>
-->
<!--        </xsl:if>-->
    </xsl:template>


    <xsl:template name="select1">

<!--        <xsl:if test="chiba:data/@chiba:enabled != 'false'">-->
            <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
            <xsl:variable name="pos" select="position()"/>
            <xsl:variable name="id" select="@id" />

            <xsl:variable name="parent" select="."/>
            <xsl:choose>
                <xsl:when test="@xforms:appearance='compact'">
                    <xsl:element name="select">
                        <xsl:attribute name="id"><xsl:value-of select="concat($id,'-value')"/></xsl:attribute>
                        <xsl:attribute name="name">
                            <xsl:value-of select="concat($data-prefix,$id)"/>
                        </xsl:attribute>
                        <xsl:attribute name="size">5</xsl:attribute>
                        <xsl:attribute name="title">
                            <xsl:value-of select="normalize-space(./xforms:hint)"/>
                        </xsl:attribute>

                        <xsl:call-template name="assembleRepeatClasses">
                            <xsl:with-param name="repeat-id" select="$repeat-id"/>
                            <xsl:with-param name="pos" select="$pos"/>
                            <xsl:with-param name="classes" select="'value'"/>
                        </xsl:call-template>
                        <xsl:if test="chiba:data/@chiba:readonly='true'">
                            <xsl:attribute name="readonly">true</xsl:attribute>
                        </xsl:if>
                        <xsl:call-template name="build-items">
                            <xsl:with-param name="parent" select="$parent"/>
                        </xsl:call-template>
                        <xsl:if test="$scripted='true'">
                            <xsl:attribute name="onchange">javascript:setXFormsValue('<xsl:value-of select="$id"/>');</xsl:attribute>
                        </xsl:if>
                    </xsl:element>
                    <!-- create hidden parameter for deselection -->
                    <input type="hidden" name="{concat($data-prefix,$id)}" value=""/>
<!--
                    <xsl:if test="./chiba:data/@chiba:required='true'">
                        <span style="font-color:red;">*</span>
                    </xsl:if>
-->
                </xsl:when>
                <xsl:when test="@xforms:appearance='full'">
                    <xsl:call-template name="build-radiobuttons">
                        <xsl:with-param name="id" select="$id"/>
                        <xsl:with-param name="name" select="concat($data-prefix,$id)"/>
                        <xsl:with-param name="parent" select="$parent"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="select">
                        <xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
                        <xsl:attribute name="name">
                            <xsl:value-of select="concat($data-prefix,$id)"/>
                        </xsl:attribute>
                        <xsl:attribute name="size">1</xsl:attribute>
                        <xsl:attribute name="title">
                            <xsl:value-of select="normalize-space(./xforms:hint)"/>
                        </xsl:attribute>
                        <xsl:call-template name="assembleRepeatClasses">
                            <xsl:with-param name="repeat-id" select="$repeat-id"/>
                            <xsl:with-param name="pos" select="$pos"/>
                            <xsl:with-param name="classes" select="'value'"/>
                        </xsl:call-template>
                        <xsl:if test="chiba:data/@chiba:readonly='true'">
                            <xsl:attribute name="readonly">true</xsl:attribute>
                        </xsl:if>
                        <xsl:call-template name="build-items">
                            <xsl:with-param name="parent" select="$parent"/>
                        </xsl:call-template>
                        <xsl:if test="$scripted='true'">
                            <xsl:attribute name="onchange">javascript:setXFormsValue('<xsl:value-of select="$id"/>');</xsl:attribute>
                        </xsl:if>
                    </xsl:element>
                    <!-- create hidden parameter for deselection -->
                    <input type="hidden" name="{concat($data-prefix,$id)}" value=""/>
<!--
                    <xsl:if test="./chiba:data/@chiba:required='true'">
                        <font color="red">*</font>
                    </xsl:if>
-->
                </xsl:otherwise>
            </xsl:choose>
<!--        </xsl:if>-->
    </xsl:template>


    <xsl:template name="select">

<!--        <xsl:if test="chiba:data/@chiba:enabled != 'false'">-->
            <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
            <xsl:variable name="pos" select="position()"/>
            <xsl:variable name="id" select="@id" />

            <xsl:variable name="parent" select="."/>
            <xsl:choose>
                <xsl:when test="@xforms:appearance='compact'">
                    <xsl:element name="select">
                        <xsl:attribute name="id"><xsl:value-of select="concat($id,'-value')"/></xsl:attribute>
                        <xsl:attribute name="name">
                            <xsl:value-of select="concat($data-prefix,$id)"/>
                        </xsl:attribute>
                        <xsl:attribute name="title">
                            <xsl:value-of select="normalize-space(./xforms:hint)"/>
                        </xsl:attribute>
                        <xsl:attribute name="multiple">true</xsl:attribute>
                        <xsl:attribute name="size">5</xsl:attribute>
                        <xsl:if test="chiba:data/@chiba:readonly='true'">
                            <xsl:attribute name="readonly">true</xsl:attribute>
                        </xsl:if>
                        <xsl:attribute name="class">select-widget value</xsl:attribute>
                        <xsl:call-template name="assembleRepeatClasses">
                            <xsl:with-param name="repeat-id" select="$repeat-id"/>
                            <xsl:with-param name="pos" select="$pos"/>
                            <xsl:with-param name="classes" select="'value'"/>
                        </xsl:call-template>
                        <xsl:call-template name="build-items">
                            <xsl:with-param name="value" select="chiba:data/text()"/>
                            <xsl:with-param name="parent" select="$parent"/>
                        </xsl:call-template>
                        <xsl:if test="$scripted='true'">
                            <xsl:attribute name="onchange">javascript:setXFormsValue('<xsl:value-of select="$id"/>');</xsl:attribute>
                        </xsl:if>
                    </xsl:element>
                    <!-- create hidden parameter for deselection -->
                    <input type="hidden" name="{concat($data-prefix,$id)}" value=""/>
<!--
                    <xsl:if test="./chiba:data/@chiba:required='true'">
                        <font color="red">*</font>
                    </xsl:if>
-->
                </xsl:when>
                <xsl:when test="@xforms:appearance='full'">
                    <xsl:call-template name="build-checkboxes">
                        <xsl:with-param name="id" select="$id"/>
                        <xsl:with-param name="name" select="concat($data-prefix,$id)"/>
                        <xsl:with-param name="parent" select="$parent"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="select">
                        <xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
                        <xsl:attribute name="name">
                            <xsl:value-of select="concat($data-prefix,$id)"/>
                        </xsl:attribute>
                        <xsl:attribute name="title">
                            <xsl:value-of select="normalize-space(./xforms:hint)"/>
                        </xsl:attribute>
                        <xsl:attribute name="multiple">true</xsl:attribute>
                        <xsl:attribute name="size">3</xsl:attribute>
                        <xsl:if test="chiba:data/@chiba:readonly='true'">
                            <xsl:attribute name="readonly">true</xsl:attribute>
                        </xsl:if>

                        <xsl:call-template name="assembleRepeatClasses">
                            <xsl:with-param name="repeat-id" select="$repeat-id"/>
                            <xsl:with-param name="pos" select="$pos"/>
                            <xsl:with-param name="classes" select="'value'"/>
                        </xsl:call-template>
                        <xsl:call-template name="build-items">
                            <xsl:with-param name="value" select="chiba:data/text()"/>
                            <xsl:with-param name="parent" select="$parent"/>
                        </xsl:call-template>
                        <xsl:if test="$scripted='true'">
                            <xsl:attribute name="onchange">javascript:setXFormsValue('<xsl:value-of select="$id"/>');</xsl:attribute>
                        </xsl:if>
                    </xsl:element>
                    <!-- create hidden parameter for deselection -->
                    <input type="hidden" name="{concat($data-prefix,$id)}" value=""/>
<!--
                    <xsl:if test="./chiba:data/@chiba:required='true'">
                        <font color="red">*</font>
                    </xsl:if>
-->
                </xsl:otherwise>
            </xsl:choose>

<!--        </xsl:if>-->
    </xsl:template>

    <!-- build submit -->
    <xsl:template name="submit">
        <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
        <xsl:variable name="pos" select="position()"/>
        <xsl:variable name="id" select="@id" />

        <xsl:element name="input">
            <xsl:attribute name="id"><xsl:value-of select="concat($id,'-value')"/></xsl:attribute>
            <xsl:choose>
                <xsl:when test="$scripted='true'">
                    <xsl:attribute name="type">button</xsl:attribute>
                    <xsl:attribute name="onclick">javascript:activate('<xsl:value-of select="$id"/>');</xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="type">submit</xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:attribute name="name">
                   <xsl:value-of select="concat($trigger-prefix,$id)"/>
            </xsl:attribute>
            <xsl:attribute name="value">
                <xsl:value-of select="xforms:label"/>
            </xsl:attribute>
            <xsl:attribute name="title">
                <xsl:value-of select="normalize-space(xforms:hint)"/>
            </xsl:attribute>
            <xsl:if test="chiba:data/@chiba:readonly='true'">
                <xsl:attribute name="readonly">true</xsl:attribute>
            </xsl:if>
<!--            <xsl:if test="chiba:data/@chiba:enabled='false'">-->
<!--                <xsl:attribute name="disabled">true</xsl:attribute>-->
<!--            </xsl:if>-->
            <xsl:call-template name="assembleRepeatClasses">
                <xsl:with-param name="repeat-id" select="$repeat-id"/>
                <xsl:with-param name="pos" select="$pos"/>
                <xsl:with-param name="classes" select="'value'"/>
            </xsl:call-template>

        </xsl:element>
    </xsl:template>

    <!-- build textarea control -->
    <xsl:template name="textarea">
<!--        <xsl:if test="chiba:data/@chiba:enabled != 'false'">-->
            <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
            <xsl:variable name="pos" select="position()"/>
            <xsl:variable name="id" select="@id" />

            <xsl:element name="textarea">
                <xsl:attribute name="id"><xsl:value-of select="concat($id,'-value')"/></xsl:attribute>
                <xsl:attribute name="name">
                    <xsl:value-of select="concat($data-prefix,$id)"/>
                </xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:value-of select="normalize-space(xforms:hint)"/>
                </xsl:attribute>
                <xsl:if test="chiba:data/@chiba:readonly='true'">
                    <xsl:attribute name="readonly">true</xsl:attribute>
                </xsl:if>
                <xsl:call-template name="assembleRepeatClasses">
                    <xsl:with-param name="repeat-id" select="$repeat-id"/>
                    <xsl:with-param name="pos" select="$pos"/>
                    <xsl:with-param name="classes" select="'value'"/>
                </xsl:call-template>
                <xsl:value-of select="chiba:data/text()"/>
                <xsl:if test="$scripted='true'">
                    <xsl:attribute name="onchange">javascript:setXFormsValue('<xsl:value-of select="$id"/>');</xsl:attribute>
                </xsl:if>
            </xsl:element>

<!--
            <xsl:if test="chiba:data/@chiba:required='true'">
                <font color="red">*</font>
            </xsl:if>
-->
<!--        </xsl:if>-->
    </xsl:template>

    <!-- build trigger -->
    <!-- ### please note that triggers are always submit buttons cause this stylesheet assumes no javascript ### -->
    <xsl:template name="trigger">
        <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
        <xsl:variable name="pos" select="position()"/>
        <xsl:variable name="id" select="@id" />

        <xsl:variable name="img" select="xforms:label/@xforms:src"/>
		<xsl:choose>
			<xsl:when test="$img">
				<input type="image" class="imgbut" onmouseover="this.oldsrc=this.src; this.src=this.src+'&amp;highlight=true'" onmouseout="this.src=this.oldsrc" border="0" src="{$img}" xrl:resolve="src">
					<xsl:attribute name="name">
						<xsl:value-of select="concat($trigger-prefix,$id)" />
					</xsl:attribute>
					<xsl:attribute name="value">
						<xsl:value-of select="concat($trigger-prefix,$id)" />
					</xsl:attribute>
				</input>
			</xsl:when>
			<xsl:otherwise>
<!--        <xsl:element name="input">-->
        <xsl:element name="button">
            <xsl:attribute name="id"><xsl:value-of select="concat($id,'-value')"/></xsl:attribute>
            <xsl:attribute name="name">
                <xsl:value-of select="concat($trigger-prefix,$id)" />
            </xsl:attribute>
            <xsl:choose>
				<xsl:when test="xforms:imgsrc">
					<a href="#" onClick="javscript:submit()"><img id="{$id}" border="0" src="{xforms:imgsrc}"/></a>
				</xsl:when>
                <xsl:when test="$scripted='true'">
                    <xsl:attribute name="type">button</xsl:attribute>
                    <xsl:attribute name="onclick">javascript:activate('<xsl:value-of select="$id"/>');</xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="type">submit</xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
<!--            <xsl:attribute name="value">-->
<!--                <xsl:value-of select="xforms:label"/>-->
<!--            </xsl:attribute>-->
            <xsl:attribute name="title">
                <xsl:value-of select="normalize-space(xforms:hint)"/>
            </xsl:attribute>
            <xsl:call-template name="assembleRepeatClasses">
                <xsl:with-param name="repeat-id" select="$repeat-id"/>
                <xsl:with-param name="pos" select="$pos"/>
                <xsl:with-param name="classes" select="'value'"/>
            </xsl:call-template>
            <xsl:if test="chiba:data/@chiba:readonly='true'">
                <xsl:attribute name="readonly">true</xsl:attribute>
            </xsl:if>
<!--            <xsl:if test="chiba:data/@chiba:enabled='false'">-->
<!--                <xsl:attribute name="disabled">true</xsl:attribute>-->
<!--            </xsl:if>-->
            <xsl:if test="@xforms:accesskey">
                <xsl:attribute name="accesskey">
                    <xsl:value-of select="@xforms:accesskey"/>
                </xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:value-of select="normalize-space(xforms:hint)"/> - KEY: [ALT]+ <xsl:value-of select="@xforms:accesskey"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:if test="contains(@xforms:src,'.gif') or contains(@xforms:src,'.jpg') or contains(@xforms:src,'.png')">
                <img src="{@xforms:src}" id="{@id}-label"/>
            </xsl:if>

            <xsl:choose>
                <xsl:when test="boolean($img) and ( contains($img,'.gif') or contains($img,'.jpg') or contains($img,'.png') )">
                    <img src="{$img}" id="{@id}-label"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="xforms:label"/>
                </xsl:otherwise>
            </xsl:choose>
<!--            <xsl:call-template name="eval-actions"/>-->
        </xsl:element>
		</xsl:otherwise>
		</xsl:choose>
    </xsl:template>

    <!-- build upload control -->
    <xsl:template name="upload">
        <!-- the stylesheet using this template has to take care, that form enctype is set to 'multipart/form-data' -->

<!--        <xsl:if test="chiba:data/@chiba:enabled != 'false'">-->
            <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
            <xsl:variable name="pos" select="position()"/>
            <xsl:variable name="id" select="@id" />

            <xsl:if test="$debug-enabled='true'">
                <xsl:message>WARN: upload partially supported</xsl:message>
            </xsl:if>
            <xsl:element name="input">
                <xsl:attribute name="id"><xsl:value-of select="concat($id,'-value')"/></xsl:attribute>
                <xsl:attribute name="name">
                    <xsl:value-of select="concat($data-prefix,$id)"/>
                </xsl:attribute>
                <xsl:attribute name="type">file</xsl:attribute>
                <xsl:attribute name="value"></xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:value-of select="normalize-space(xforms:hint)"/>
                </xsl:attribute>
				<!-- Content types accepted, from mediatype xforms:upload attribute
                to accept input attribute -->
                <xsl:attribute name="accept">
                    <xsl:value-of select="translate(normalize-space(@xforms:mediatype),' ',',')"/>
                </xsl:attribute>
				
                <xsl:if test="chiba:data/@chiba:readonly='true'">
                    <xsl:attribute name="readonly">true</xsl:attribute>
                </xsl:if>
				
                <xsl:call-template name="assembleRepeatClasses">
                    <xsl:with-param name="repeat-id" select="$repeat-id"/>
                    <xsl:with-param name="pos" select="$pos"/>
                    <xsl:with-param name="classes" select="'value'"/>
                </xsl:call-template>

                
                <xsl:if test="$scripted='true'">
                    <xsl:attribute name="onchange">javascript:setXFormsValue('<xsl:value-of select="$id"/>');</xsl:attribute>
                </xsl:if>
            </xsl:element>

<!--
            <xsl:if test="chiba:data/@chiba:required='true'">
                <font color="red">*</font>
            </xsl:if>
-->

<!--        </xsl:if>-->
    </xsl:template>


    <!-- ######################################################################################################## -->
    <!-- ########################################## HELPER TEMPLATES FOR SELECT, SELECT1 ######################## -->
    <!-- ######################################################################################################## -->

    <xsl:template name="build-items">
        <xsl:param name="parent"/>

        <!-- add an empty item in case the item is optional, cause otherwise deselection is not possible -->
        <xsl:if test="chiba:data/@chiba:required='false'">
            <option value=""/>
        </xsl:if>

        <xsl:variable name="items" select="$parent//xforms:item"/>
        <xsl:for-each select="$items">
            <xsl:choose>
                <xsl:when test="@xforms:selected='true'">
                    <option value="{./xforms:value}" selected="selected">
                        <xsl:apply-templates select="./xforms:label"/>
                    </option>
                </xsl:when>
                <xsl:otherwise>
                    <option value="{./xforms:value}">
                        <xsl:apply-templates select="./xforms:label"/>
                    </option>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>

    <!-- overwrite/change this template, if you don't like the
    way labels are rendered for checkboxes -->
    <!-- todo: consider readonly attribute -->
    <xsl:template name="build-checkboxes">
        <xsl:param name="id"/>
        <xsl:param name="name"/>
        <xsl:param name="parent"/>

        <xsl:variable name="items" select="$parent//xforms:item"/>
        <xsl:for-each select="$items">
            <xsl:choose>
                <xsl:when test="@xforms:selected='true'">
                    <input class="checkbox-widget value" type="checkbox" name="{$name}" value="{./xforms:value}" checked="checked" title="{./xforms:label}">
                        <xsl:if test="$scripted='true'">
                            <xsl:attribute name="onchange">javascript:setXFormsValue('<xsl:value-of select="$parent/@id"/>');</xsl:attribute>
                        </xsl:if>
                    </input>
                </xsl:when>
                <xsl:otherwise>
                    <input class="checkbox-widget value" type="checkbox" name="{$name}" value="{./xforms:value}" title="{./xforms:label}">
                        <xsl:if test="$scripted='true'">
                            <xsl:attribute name="onchange">javascript:setXFormsValue('<xsl:value-of select="$parent/@id"/>');</xsl:attribute>
                        </xsl:if>
                    </input>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:apply-templates select="./xforms:label"/>
        </xsl:for-each>
        <!-- create hidden parameter for identification and deselection -->
        <!--<input id="{$id}-value" type="hidden" name="{$name}" value=""/>-->
        <xsl:if test="./@chiba:required='true'">
            <font color="red">*</font>
        </xsl:if>
    </xsl:template>

    <!-- overwrite/change this template, if you don't the way labels are rendered for checkboxes -->
    <!-- todo: consider readonly attribute -->
    <xsl:template name="build-radiobuttons">
        <xsl:param name="id"/>
        <xsl:param name="name"/>
        <xsl:param name="parent"/>

        <xsl:variable name="items" select="$parent//xforms:item"/>
        <xsl:for-each select="$items">
            <xsl:choose>
                <xsl:when test="@xforms:selected='true'">
                    <input class="radiobutton-widget value" type="radio" name="{$name}" value="{./xforms:value}" checked="checked" title="{$parent/xforms:hint}">
                        <xsl:if test="$scripted='true'">
                            <xsl:attribute name="onchange">javascript:setXFormsValue('<xsl:value-of select="$parent/@id"/>');</xsl:attribute>
                        </xsl:if>
                    </input>
                </xsl:when>
                <xsl:otherwise>
                    <input class="radiobutton-widget value" type="radio" name="{$name}" value="{./xforms:value}" title="{$parent/xforms:hint}">
                        <xsl:if test="$scripted='true'">
                            <xsl:attribute name="onchange">javascript:setXFormsValue('<xsl:value-of select="$parent/@id"/>');</xsl:attribute>
                        </xsl:if>
                    </input>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:apply-templates select="./xforms:label">
                <xsl:with-param name="class"></xsl:with-param>
            </xsl:apply-templates>
            <!-- create hidden parameter for identification and deselection -->
            <!--<input id="{$id}-value" type="hidden" name="{$name}" value=""/>-->
        </xsl:for-each>
<!--
        <xsl:if test="./chiba:data/@chiba:required='true'">
            <font color="red">*</font>
        </xsl:if>
-->
    </xsl:template>

    <!-- ########## builds indexed classname for styling repeats rendered as tables ########## -->
    <xsl:template name="assembleRepeatClasses">
        <xsl:param name="repeat-id"/>
        <xsl:param name="pos"/>
        <xsl:param name="classes"/>
        <xsl:choose>
            <xsl:when test="boolean(string-length($repeat-id) > 0)">
                <xsl:attribute name="class">
                    <xsl:value-of select="concat($repeat-id,'-',$pos,' ',$classes)"/>
                </xsl:attribute>
            </xsl:when>
            <xsl:when test="boolean(string-length(@class) > 0)">
                <xsl:attribute name="class">
                    <xsl:value-of select="concat(@class, ' ',$classes)"/>
                </xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">
                <xsl:value-of select="$classes"/>
              </xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
