<?xml version="1.0" encoding="UTF-8" ?>

<!--
    <comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Blogxter Non-commerical-Use License v1.0 -
		You are permitted to use this software only for non-commercial applications.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

    <xsl:template match="/fls">
		<xsl:variable name="sum" select="100*sum( /descendant::length ) div 2097152"/>
		<chart>
		  <properties>
			<type>bar-stacked</type>
			<title>Resource Allocation</title>
			<width>200</width>
			<height>200</height>
			<xAxisTitle>-</xAxisTitle>
			<yAxisTitle>Used %</yAxisTitle>
			<xAxisLabels>
			  <label>File Space</label>
			</xAxisLabels>
		  </properties>
		  <data>
			<dataset color="0000FF66" name="Used">
			  <point>
				<xsl:attribute name="y">
					<xsl:value-of select="$sum"/>
				</xsl:attribute>
			</point>
			</dataset>
			<dataset color="00AA0066" name="Free">
			  <point>
				<xsl:attribute name="y">
					<xsl:value-of select="100-$sum"/>
				</xsl:attribute>
			</point>
			</dataset>
			
			<!--
			<dataset color="FFFFFFFF" name="bg">	
			  <point y="100"/>
			</dataset>
			-->
		  </data>
		</chart>
        
    </xsl:template>

</xsl:stylesheet> 
