<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_stats_to_popularity_table.xsl
    Created on : 05 December 2003, 16:26
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

    <xsl:template match="/stats">
		<table>
			<tr>
			<td>
				<xsl:if test="topentries/results/row">
					<h3>Most Popular Entries</h3>
					<table width="100%" cellspacing="0" cellpadding="2">
						<tr bgcolor="#afaf9a">
							<td/>
							<td width="300">
								Title
							</td>
						</tr>
						<xsl:for-each select="topentries/results/row">
							<tr bgcolor="#dcdcc1">
								<td><xsl:value-of select="position()"/></td>
								<td>
									<a>
										<xsl:attribute name="href">entry?publicid=<xsl:value-of select="publicid"/></xsl:attribute>
										<xsl:value-of select="title"/>
									</a>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</xsl:if>
			</td>
			<td>
				<xsl:if test="topblogs/results/row">
					<h3>Top Ten Blogs</h3>
					<table width="100%" cellspacing="0" cellpadding="2">
						<tr bgcolor="#afaf9a">
							<td/>
							<td width="300">
								Name
							</td>
						</tr>
						<xsl:for-each select="topblogs/results/row">
							<tr bgcolor="#dcdcc1">
								<td><xsl:value-of select="position()"/></td>
								<td>
									<a>
										<xsl:attribute name="href">publish?blogid=<xsl:value-of select="id"/>&amp;myblog=1&amp;page=1</xsl:attribute>
										<xsl:value-of select="name"/>
									</a>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</xsl:if>
			</td>
			</tr>
			
			
		</table>
    </xsl:template>

</xsl:stylesheet> 
