<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_pjr.xsl
    Created on : 17 October 2003, 20:10
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

	<xsl:param name="param"/>
		
	<xsl:include href="/www/I18N/language.xsl"/>
	<xsl:variable name="language" select="'eng'"/>
	
    <xsl:template match="/blog">
        <div xmlns:xrl="http://1060.org/xrl">
			<div id="replacebystyle"/>  <!--Must include so that it can be replaced by users style-->
			
			<!--
			//////////////
			//PopUp Script
			//////////////
			-->
			
			<script language="JavaScript">
				<xsl:comment>
				function popUp(URL) {
				day = new Date();
				id = day.getTime();
				eval("page" + id + " = window.open(URL, '" + id + "', 'toolbar=0,scrollbars=0,location=0,statusbar=0,menubar=0,resizable=0,width=300,height=200');");
				}
				</xsl:comment>
			</script>
			
			<xrl:include href="xrl:myblog_menu"/>
			<table width="100%">
			<tr>
			<td colspan="2">
				<h1>Edit Blog: <xrl:include href="xrl:myblog_blog_metadata"/></h1>
			</td>
			</tr>
			<tr>
				<td>
					<table width="100%">
						<tr>
						<td valign="top" width="100%">
						<xrl:include href="xrl:myblog_new_entry_form"/>
						</td>
						<td >
							<form action="xrl:myblog_preview" xrl:resolve="action" method="post">
								<input type="submit" value="Preview Blog"/>
							</form>
							<xsl:if test="$param/nvp/editor">
								<xrl:include href="xrl:myblog_form_manage_resources"/>
								<form action="xrl:myblog_manage_polls" xrl:resolve="action" method="post">
									<input type="submit" value="Manage Polls"/>
								</form>
								<form action="xrl:myblog_process_comments_pending" xrl:resolve="action" method="post">
									<input type="submit" value="Approve Comments"/>
								</form>
							</xsl:if>
							
						</td>
						</tr>
					</table>
				</td>
			</tr>
			
			<tr>
			<td>
				<table>
					<xsl:variable name="total" select="/blog/stats-blog/results/row/total_entries"/>
					<tr>
						<td>
							<span style="font-weight: bold;">
							
							Showing
							<xsl:value-of select="$param/nvp/offset + 1"/> 
							- 
							<xsl:choose>
								<xsl:when test="$param/nvp/offset + $param/nvp/count &gt; $total">
									<xsl:value-of select="$total"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$param/nvp/count + $param/nvp/offset"/>
								</xsl:otherwise>
							</xsl:choose>
							of <xsl:value-of select="$total"/>
							</span>
						</td>
						<td>
							<form action="xrl:myblog_edit_set_pointer" xrl:resolve="action" method="post" >
								<input name="total" type="hidden">
									<xsl:attribute name="value"><xsl:value-of select="$total"/></xsl:attribute>
								</input>
								<label style="margin-left: 20px; font-weight: bold; font-size: 9px;">
								show entry <input name="offset" style="width: 20px; font-size: 9px;"/>
								</label>
							</form>
						</td>
					</tr>
				</table>
			<table cellpadding="0" cellspacing="0" width="100%">
				<xsl:apply-templates select="entries/results/row"/>
			</table>
			</td>
			</tr>
			</table>
			<a style="display: none;" href="help-edit" id="help">Help</a>
		</div>
    </xsl:template>
	
	<xsl:template match="row">
		<tr >
		<td colspan="10">
		<table style="border-top: 1px solid silver; border-bottom: 1px solid silver;">
		<tr>
		<td width="5%">
			<xsl:value-of select="dateDayName"/>
		</td>
		<td>
			<xsl:value-of select="dateDayOfMonth"/>
		</td>
		<td>
			<xsl:value-of select="dateMonthName"/>
		</td>
		<td>
			<xsl:value-of select="dateYear"/>
		</td>
		<td width="80%" align="center">
			<b><xsl:value-of select="title"/></b>
			<xsl:if test="status='pending'">
				<div style="color: red; ">Publication Pending</div>
			</xsl:if>
		</td>
		<td>
			<xsl:if test="$param/nvp/editor">
				<xsl:choose>
					<xsl:when test="status='pending'">
						<form action="publishentry" method="post">
							<input type="submit" value="Approve Publication"/>
							<input type="hidden" name="publicid">
								<xsl:attribute name="value">
									<xsl:value-of select="publicid"/>
								</xsl:attribute>
							</input>
							<input type="hidden" name="status" value="approved"/>
						</form>
					</xsl:when>
					<xsl:when test="status='approved'">
						<form action="publishentry" method="post">
							<input type="submit" value="Withdraw Publication"/>
							<input type="hidden" name="publicid">
								<xsl:attribute name="value">
									<xsl:value-of select="publicid"/>
								</xsl:attribute>
							</input>
							<input type="hidden" name="status" value="pending"/>
						</form>
					</xsl:when>
				</xsl:choose>
			</xsl:if>
		</td>
		</tr>
		<tr>
		</tr>
		</table>
		
		</td>
		</tr>
		<tr>
		<td colspan="3">
			<table width="100%">
			<tr>
			<td width="100%">
			<xsl:copy-of select="entry"/>
			</td>
				<!--
				/////////////////////////////////////////
				//Polls - pulled in from the poll service
				/////////////////////////////////////////
				-->
				<xrl:include href="xrl:blog_poll_publish">
					<nvp>
						<publicid><xsl:value-of select="publicid"/></publicid>
					</nvp>
				</xrl:include>
			</tr>
			<tr>
				<td colspan="4">
				<span class="blog-posted-bar">
					Posted by <xsl:value-of select="userid"/> at
					<xsl:call-template name="addzero">
						<xsl:with-param name="n" select="timeHour"/>
					</xsl:call-template>:<xsl:call-template name="addzero">
						<xsl:with-param name="n" select="timeMinute"/>
					</xsl:call-template>
				</span>
				<xsl:variable name="publicid" select="publicid"/>
				<xsl:variable name="id" select="id"/>
				<span class="blog-comment-bar">
					comments [
					<xsl:variable name="count" select="/blog/stats-comment/results/row[id=$id]/tc"/>
					<xsl:choose>
						<xsl:when test="$count">
							<xsl:value-of select="$count"/>
						</xsl:when>
						<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
					]
					trackbacks [
					<xsl:variable name="count" select="/blog/stats-trackback/results/row[id=$id]/tt"/>
					<xsl:choose>
						<xsl:when test="$count">
							<xsl:value-of select="$count"/>
						</xsl:when>
						<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
					]
					<a>
						<xsl:attribute name="href">entry?publicid=<xsl:value-of select="publicid"/>&amp;token=<xsl:value-of select="$param/nvp/token"/></xsl:attribute>
						view
					</a>
				</span>
				</td>
			</tr>
			</table>
		</td>
		<td valign="bottom" width="10%">
			<form action="xrl:myblog_starteditor" xrl:resolve="action" method="post">
				<input type="submit">
				<xsl:attribute name="value">Edit</xsl:attribute>
				<!--
				<xsl:value-of select="$lang/lang/pack[@language=$language]/button-edit"/>
				-->
				</input>
				<input type="hidden" name="publicid">
					<xsl:attribute name="value">
						<xsl:value-of select="publicid"/>
					</xsl:attribute>
				</input>
			</form>
			<form action="spellcheck" method="post">
				<input type="submit" value="Spellcheck"/>
				<input type="hidden" name="publicid">
					<xsl:attribute name="value">
						<xsl:value-of select="publicid"/>
					</xsl:attribute>
				</input>
			</form>
			<xsl:if test="$param/nvp/editor">
				<form action="xrl:myblog_startpoll" method="post" xrl:resolve="action">
					<input type="submit" value="Add Poll"/>
					<input type="hidden" name="publicid">
						<xsl:attribute name="value">
							<xsl:value-of select="publicid"/>
						</xsl:attribute>
					</input>
				</form>
				<form action="xrl:myblog_entry_comments" method="post" xrl:resolve="action">
					<input type="submit" value="Edit Comments"/>
					<input type="hidden" name="publicid">
						<xsl:attribute name="value">
							<xsl:value-of select="publicid"/>
						</xsl:attribute>
					</input>
				</form>
				<form>
				<input type="button" value="Post Trackback" xrl:resolve="onclick">
					<xsl:attribute name="onclick">
					javascript:popUp('[[xrl:myblog_post_trackback]]?publicid=<xsl:value-of select="publicid"/>')
					</xsl:attribute>
				</input>
				</form>
				<input type="button" value="Delete" xrl:resolve="onclick">
					<xsl:attribute name="onclick">
					javascript:popUp('[[xrl:myblog_delete_entry_confirm]]?publicid=<xsl:value-of select="publicid"/>')
					</xsl:attribute>
				</input>
				
			</xsl:if>
		</td>
		</tr>
		<tr height="10"/>
	</xsl:template>

	<!--
	//////////////////////////////////////////////
	//Utility to add Zero to a number less than 10
	//////////////////////////////////////////////
	-->
	<xsl:template name="addzero">
		<xsl:param name="n"/>
		<xsl:if test="$n &lt; 10">0</xsl:if><xsl:value-of select="$n"/>
	</xsl:template>
	
</xsl:stylesheet> 
