<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_resources.xsl
    Created on : 11 November 2003, 16:14
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

	<xsl:param name="param"/>
	
	<xsl:template match="/">
		<div>
			<xsl:apply-templates select="results"/>
		</div>
	</xsl:template>
	
    <xsl:template match="results">
	<form action="xrl:myblog_set_css" method="post" xrl:resolve="action">
        <table>
			<tr><td>Live</td><td>Test</td><td>ID</td><td>URI</td><td>Description</td></tr>
			<tr>
			<td>
			<input name="css-live" type="radio" checked="true" value="default-css"/>
			</td>
			<td>
			<input name="css-test" type="radio" checked="true" value="default-css"/>
			</td>
			<td>
			Default CSS
			</td>
			<td>
			-
			</td>
			<td>
			The system default CSS stylesheet
			</td>
			</tr>
			<xsl:apply-templates select="row" mode="css"/>
		</table>
	</form>
	<form action="xrl:myblog_set_xsl" method="post" xrl:resolve="action">
        <table>
			<tr>
			<td>
			<input name="xsl-live" type="radio" checked="true" value="default-xsl"/>
			</td>
			<td>
			<input name="xsl-test" type="radio" checked="true" value="default-xsl"/>
			</td>
			<td>
			Default XSL
			</td>
			<td>
			-
			</td>
			<td>
			The system default XSL stylesheet
			</td>
			</tr>
			<xsl:apply-templates select="row" mode="xsl"/>
		</table>
	</form>
	<h3>Resource List</h3>
	<form action="xrl:myblog_delete_resources" method="post" xrl:resolve="action">
	<table>
			<xsl:apply-templates select="row" mode="res"/>
	</table>
	</form>
	</xsl:template>
	
	<xsl:template match="row" mode="css">
		<xsl:if test="contains(URI,'.css')">
			<tr>
			<td>
			<input name="css-live" type="radio">
				<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
				<xsl:if test="$param/results/row[type='css'][status='live']/resourceid = id">
					<xsl:attribute name="checked">true</xsl:attribute>
				</xsl:if>
			</input>
			</td>
			<td>
			<input name="css-test" type="radio">
				<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
				<xsl:if test="$param/results/row[type='css'][status='test']/resourceid = id">
					<xsl:attribute name="checked">true</xsl:attribute>
				</xsl:if>
				
			</input>
			</td>
			<td>
			<xsl:value-of select="id"/>
			</td>
			<td>
			<xsl:value-of select="URI"/>
			</td>
			<td>
			<xsl:value-of select="descr"/>
			</td>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
			<td colspan="4">
			<input type="submit" value="Use as CSS Stylesheet"/><input type="reset"/>
			</td>
			</tr>
		</xsl:if>
		
	</xsl:template>
	
	<xsl:template match="row" mode="xsl">
		<xsl:if test="contains(URI,'.xsl')">
			<tr>
			<td>
			<input name="xsl-live" type="radio">
				<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
				<xsl:if test="$param/results/row[type='xslt'][status='live']/resourceid = id">
					<xsl:attribute name="checked">true</xsl:attribute>
				</xsl:if>
			</input>
			</td>
			<td>
			<input name="xsl-test" type="radio">
				<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
				<xsl:if test="$param/results/row[type='xslt'][status='test']/resourceid = id">
					<xsl:attribute name="checked">true</xsl:attribute>
				</xsl:if>
			</input>
			</td>
			<td>
			<xsl:value-of select="id"/>
			</td>
			<td>
			<xsl:value-of select="URI"/>
			</td>
			<td>
			<xsl:value-of select="descr"/>
			</td>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
			<td colspan="4">
			<input type="submit" value="Use as XSL Stylesheet"/><input type="reset"/>
			</td>
			</tr>
		</xsl:if>
		
	</xsl:template>
	
	<xsl:template match="row" mode="res">
			<tr>
			<td>
			<xsl:value-of select="id"/>
			</td>
			<td>
			<xsl:value-of select="URI"/>
			</td>
			<td>
			<xsl:value-of select="descr"/>
			</td>
			<td>
				<input name="resourceid" type="checkbox">
				<xsl:attribute name="value"><xsl:value-of select="id"/>,<xsl:value-of select="URI"/></xsl:attribute>
				</input>
			</td>
			</tr>
			<xsl:if test="position()=last()">
				<tr>
				<td colspan="4">
				<input type="submit" value="Delete Resources"/><input type="reset"/>
				</td>
				</tr>
			</xsl:if>
	</xsl:template>

</xsl:stylesheet> 
