<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_polls.xsl
    Created on : 15 November 2003, 17:01
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

    <xsl:template match="/">
        <div>
			<xsl:apply-templates select="results"/>
		</div>
    </xsl:template>
	
	<xsl:key name="threaded-answers" match="row" use="question"/>
	
	<xsl:template match="results">
		
			<xsl:for-each select="row[count(. | key('threaded-answers', question)[1]) = 1]">
				<table  style="border: 1px solid silver;" width="400">
					<xsl:choose>
						<xsl:when test="status='pending'">
							<xsl:attribute name="style">border: 1px solid silver; background-color: #eeeeee;</xsl:attribute>
						</xsl:when>
						<xsl:when test="status='live'">
							<xsl:attribute name="style">border: 1px solid silver;</xsl:attribute>
						</xsl:when>
					</xsl:choose>
					<tr>
					<td>
						<span class="blog-title"><xsl:value-of select="title"/></span>
					</td>
					</tr>
					<tr>
					<td>
						<b><xsl:value-of select="question"/></b>
					</td>
					<td>
						<table>
							<xsl:for-each select="key('threaded-answers', question)">
									<tr>
									<td><input type="radio" disabled="true"/><xsl:value-of select="choice"/></td>
									<td><xsl:value-of select="votes"/></td>
									</tr>
							</xsl:for-each>
						</table>
					</td>
					<td>
						<form action="togglepollstatus" method="post">
						<input type="hidden" name="publicid">
							<xsl:attribute name="value"><xsl:value-of select="publicid"/></xsl:attribute>
						</input>
						<input type="hidden" name="pollid">
							<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
						</input>
						<xsl:choose>
							<xsl:when test="status='pending'">
								<input type="hidden" name="status" value="live"/>
								<input type="submit" value="Enable Poll"/>
							</xsl:when>
							<xsl:when test="status='live'">
								<input type="hidden" name="status" value="pending"/>
								<input type="submit" value="Disable Poll"/>
							</xsl:when>
						</xsl:choose>
						</form>
					</td>
					</tr>
					<tr>
					<td>
						Total votes: <xsl:value-of select="sum(key('threaded-answers', question)/votes)"/>
					</td>
					</tr>
				</table>
			</xsl:for-each>
		
	</xsl:template>

</xsl:stylesheet> 
