<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xforms="http://www.w3.org/2002/xforms"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:chiba="http://chiba.sourceforge.net/2003/08/xforms"
	xmlns:xrl="http://1060.org/xrl"
    exclude-result-prefixes="chiba xforms xlink xsl">

    <xsl:include href="ffcpl:/org/chiba/xslt/html-form-controls.xsl"/>
    <xsl:output method="xml" encoding="UTF-8"/>

    <xsl:variable name="action-url" select="''"/>
    <xsl:variable name="form-id" select="'chiba-form'"/>
    <xsl:variable name="debug-enabled" select="'false'"/>

    <xsl:template match="/">
        <html>
            <xsl:apply-templates/>
        </html>
    </xsl:template>

    <xsl:template match="body">
        <div>
			<form name="{$form-id}" action="xrl:myblog_newpoll" xrl:resolve="action" method="post" enctype="application/x-www-form-urlencoded">
                <xsl:apply-templates/>
            </form>
        </div>
    </xsl:template>

    <xsl:template match="xforms:model"/>

    <xsl:template match="xforms:group">
        <table>
			<xsl:for-each select="xforms:input|xforms:secret|xforms:textarea|xforms:select1|xforms:repeat">
				<tr>
					<td class="control-label">
						<xsl:apply-templates select="xforms:label"/>
					</td>
					<td>
						<xsl:apply-templates select="."/>
						<!--<xsl:apply-templates select="xforms:alert"/>-->
					</td>
				</tr>
			</xsl:for-each>
			<tr>
			<td colspan="2">
				<xsl:for-each select="xforms:trigger">
				    <input type="submit" name="{chiba:data/@chiba:name}" value="{xforms:label}" class="action-button"/>
				</xsl:for-each>
			</td>
			</tr>
        </table>
    </xsl:template>

    <xsl:template match="xforms:select1">
        <xsl:call-template name="select1">
            <xsl:with-param name="name" select="chiba:data/@chiba:name"/>
            <xsl:with-param name="value" select="chiba:data"/>
            <xsl:with-param name="appearance" select="@xforms:appearance"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="xforms:input">
        <xsl:call-template name="input">
            <xsl:with-param name="name" select="chiba:data/@chiba:name"/>
            <xsl:with-param name="value" select="chiba:data"/>
            <xsl:with-param name="size" select="40"/>
        </xsl:call-template>
        <xsl:apply-templates select="xforms:alert"/>
    </xsl:template>
	
	<xsl:template match="xforms:secret">
        <xsl:call-template name="secret">
            <xsl:with-param name="name" select="chiba:data/@chiba:name"/>
            <xsl:with-param name="value" select="chiba:data"/>
            <xsl:with-param name="size" select="40"/>
        </xsl:call-template>
        <xsl:apply-templates select="xforms:alert"/>
    </xsl:template>

    <xsl:template match="xforms:textarea">
        <xsl:call-template name="textarea">
            <xsl:with-param name="name" select="chiba:data/@chiba:name"/>
            <xsl:with-param name="value" select="chiba:data"/>
            <xsl:with-param name="rows" select="10"/>
            <xsl:with-param name="cols" select="70"/>
        </xsl:call-template>
		<xsl:apply-templates select="xforms:alert"/>
    </xsl:template>

    <xsl:template match="xforms:label">
        <xsl:copy-of select="*|text()"/>
    </xsl:template>

    <xsl:template match="xforms:alert[../chiba:data/@chiba:valid='false']">
        <div class="alert">
            <xsl:copy-of select="*|text()"/>
        </div>
    </xsl:template>

    <xsl:template match="xforms:alert"/>

</xsl:stylesheet>
