<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

    <xsl:template match="/">
        <div>
			<h2>Public Blogs</h2>
			<xsl:apply-templates/>
		</div>
    </xsl:template>
	
	<xsl:template match="null">
	<div style="font-size: 20px; font-weight: bold; background-color: #aaaa88; width: 200px; height: 200px; text-align: center; vertical-align: middle;">No Public Blogs</div>
	</xsl:template>
	
	<xsl:template match="results">
		<table cellpadding="1" cellspacing="0" width="100%">
				<tr bgcolor="#afaf9a">
					<td>
						<b>Name</b>
					</td>
					<td>
						<b>Description</b>
					</td>
					<td>
						<b>User</b>
					</td>
					<td colspan="10"/>
				</tr>
				<xsl:apply-templates/>
			</table>
	</xsl:template>
	
	<xsl:template match="row">
		<tr bgcolor="#dcdcc1">
		<td>
			<a>
				<xsl:attribute name="href">/blogxter/publish/<xsl:value-of select="id"/></xsl:attribute>
				<xsl:value-of select="name"/>
			</a>
		</td>
		<td>
			<xsl:value-of select="descr"/>
		</td>
		<td>
			<xsl:value-of select="userid"/>
		</td>
		</tr>
	</xsl:template>

</xsl:stylesheet> 
