<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : fls_to_pie.xsl
    Created on : 11 November 2003, 17:16
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

    <xsl:template match="/fls">
		<xsl:variable name="sum" select="100*sum( /descendant::length ) div 2097152"/>
		<chart>
		  <properties>
			<type>bar-stacked</type>
			<title>Resource Allocation</title>
			<width>200</width>
			<height>200</height>
			<xAxisTitle>-</xAxisTitle>
			<yAxisTitle>Used %</yAxisTitle>
			<xAxisLabels>
			  <label>File Space</label>
			</xAxisLabels>
		  </properties>
		  <data>
			<dataset color="0000FF66" name="Used">
			  <point>
				<xsl:attribute name="y">
					<xsl:value-of select="$sum"/>
				</xsl:attribute>
			</point>
			</dataset>
			<dataset color="00AA0066" name="Free">
			  <point>
				<xsl:attribute name="y">
					<xsl:value-of select="100-$sum"/>
				</xsl:attribute>
			</point>
			</dataset>
			
			<!--
			<dataset color="FFFFFFFF" name="bg">	
			  <point y="100"/>
			</dataset>
			-->
		  </data>
		</chart>
        
    </xsl:template>

</xsl:stylesheet> 
