/******************************************************************************
  (c) Copyright 2003-2004, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: SMTPAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2004/02/10 18:16:42 $
 *****************************************************************************/

package org.ten60.blogxter.mail.accessor;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import com.ten60.netkernel.urii.*;

import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;


import java.io.*;
import java.util.*;
import org.w3c.dom.*;

import java.sql.*;
import java.security.*;
import java.net.*;

import javax.mail.*;
import javax.mail.internet.*;
import javax.activation.*;


/**
 * An SMTP post service that holds an Outbox of XHTML mail messages.
 * A mail processor thread periodically posts queued messages.
 *
 * @author  pjr
 */
public class SMTPAccessor extends XAccessor
{
	Session mSession;
	MailProcessor mMailProcessor;
	ArrayList mOutBox;
	String mMailAddress;
	String mSMTPGateway;
	String mSMTPUser;
	String mSMTPPassword;
	int mPollInterval=10000;
	
	int	mGuestID=-1;
	
	boolean mConfigured=false;
	
	/** Creates a new instance of SMTPAccessor */
	public SMTPAccessor()
	{	declareArgument(OPERAND, false, false);
		declareArgument(OPERATOR, false, false);
		declareArgument(PARAMETER, false, false);
	}
	
	/**Configure Database connection and setup common Email settings
	 * @param aHelper The helper class that provides access to the config,
	 */
	private void configure(XAHelper aHelper)
	{	try
		{	URI configURI=URI.create("ffcpl:/etc/SMTPConfig.xml");
			IURRepresentation rep=aHelper.getResource(configURI, IAspectXDA.class);
			IAspectXDA config=(IAspectXDA)rep.getAspect(IAspectXDA.class);
			IXDAReadOnly aConfig=config.getXDA();
			
			mSMTPGateway=aConfig.getText("/SMTPConfig/SMTPGateway", true);
			mSMTPUser=aConfig.getText("/SMTPConfig/SMTPUser", true);
			mSMTPPassword=aConfig.getText("/SMTPConfig/SMTPPassword", true);
			mMailAddress=aConfig.getText("/SMTPConfig/sender", true);
			mPollInterval=Integer.parseInt(aConfig.getText("/SMTPConfig/pollInterval", true));
			
			
		}
		catch(Exception e)
		{	e.printStackTrace();
		}
		
		//Create mail session
		StringBuffer mailsettings=new StringBuffer("mail.store.protocol=pop3\n");
		mailsettings.append("mail.transport.protocol=smtp\n");
		/*Debug*/
		//mailsettings.append("mail.debug=true\n");
		ByteArrayInputStream bis=new ByteArrayInputStream(mailsettings.toString().getBytes());
		java.util.Properties ps=new java.util.Properties();
		try
		{	ps.load(bis);
		}
		catch(IOException e)
		{	e.printStackTrace();
		};
		mSession=Session.getInstance(ps);
		mOutBox=new ArrayList(10);
		mMailProcessor=new MailProcessor();
		
		//Start mailprocessor thread
		mMailProcessor.start();
	}
	
	
	/** Abstract method to be implemented in subclass.
	 * @return Either the result as a Document or a Reader.
	 * @param aHelper The helper class that provides access to the operator,
	 * operand, and parameters.
	 * @throws AccessViolationException Thrown if we fail to access any of the beans
	 * @throws DocumentAccessorException Thrown if we fail for any reason.
	 *
	 */
	public IURRepresentation source(XAHelper aHelper) throws Throwable
	{	if(!mConfigured || (aHelper.hasOperator() && aHelper.getOperator().getXDA().isTrue("/reconfigure")))
		{	if(mMailProcessor!=null)
			{	mMailProcessor.terminate();
			}
			configure(aHelper);
		}
		if(!aHelper.hasOperator())
		{	IXDAReadOnly opd=aHelper.getOperand().getXDA();

			MimeMessage message=new MimeMessage(mSession);
			message.setSubject(opd.getText("/email/subject",true));
			String from=null;
			if(opd.isTrue("/email/from"))
			{	from=opd.getText("/email/from",true);
			}
			else from=mMailAddress;
			InternetAddress IAfrom=new InternetAddress(from);
			message.setSender(IAfrom);
			message.setFrom(IAfrom);
			Map map=new HashMap(5);
			IXDAReadOnlyIterator ir=opd.readOnlyIterator("/email/to");
			while(ir.hasNext())
			{	ir.next();
				String to=ir.getText(".", true);
				if(!map.containsKey(to))
				{	message.addRecipient(Message.RecipientType.TO, new InternetAddress(to));
					map.put(to, new Boolean(true));
				}
			}
			ir=opd.readOnlyIterator("/email/cc");
			map=new HashMap(5);
			while(ir.hasNext())
			{	ir.next();
				String cc=ir.getText(".", true);
				if(!map.containsKey(cc))
				{	message.addRecipient(Message.RecipientType.CC, new InternetAddress(cc));
					map.put(cc, new Boolean(true));
				}
			}
			MimeMultipart replymp=new MimeMultipart();
			//Append processed document to reply message
			String resptype="text/html";
			StringBuffer text=new StringBuffer();
			ir=opd.readOnlyIterator("/email/message/*");
			while(ir.hasNext())
			{	ir.next();
				DataHandler dh=new DataHandler(ir.toString(),resptype);
				MimeBodyPart mbp=new MimeBodyPart();
				mbp.setDataHandler(dh);
				replymp.addBodyPart(mbp);
			}
			message.setContent(replymp);
			message.saveChanges();

			synchronized(mOutBox)
			{	mOutBox.add(message);
			}
		}
		return VoidAspect.create();
	}
	
	private boolean sendMessage(MimeMessage message)
	{	//MimeMessage reply=new MimeMessage(mSession);
		try
		{	Transport t=mSession.getTransport();
			t.connect(mSMTPGateway,-1,mSMTPUser,mSMTPPassword);
			if(!t.isConnected())
			{	//SysLogger.log(SysLogger.WARNING, this, "Failed to get SMTP Connection");
				return false;
			}
			message.setSentDate(new java.util.Date());
			message.saveChanges();
			t.sendMessage(message, message.getAllRecipients());
			return true;
		}
		catch(Exception e)
		{	//SysLogger.log(SysLogger.WARNING, this, "SMTP message not delivered:"+e.getMessage());
			e.printStackTrace();
			return false;
		}
	}
	
	protected void finalize()
	{	mMailProcessor.terminate();
	}	
	
	/*Outbox Mail Processor Thread*/
	class MailProcessor extends Thread
	{
		boolean mRun=true;
		
		public MailProcessor()
		{
		}
		
		public void terminate()
		{	interrupt();
			while(!mOutBox.isEmpty()){}
			mRun=false;
			interrupt();
		}
		
		/** When an object implementing interface <code>Runnable</code> is used
		 * to create a thread, starting the thread causes the object's
		 * <code>run</code> method to be called in that separately executing
		 * thread.
		 * <p>
		 * The general contract of the method <code>run</code> is that it may
		 * take any action whatsoever.
		 *
		 * @see     java.lang.Thread#run()
		 *
		 */
		public void run()
		{	while(mRun)
			{	synchronized(mOutBox)
				{	Iterator i=mOutBox.iterator();
					while(i.hasNext())
					{	MimeMessage message=(MimeMessage)i.next();
						if(sendMessage(message))
						{	//Log message success;
							//System.err.println("message sent successfully");
						}
						else
						{	//Log message failure
							//System.err.println("Error sending message");
						}
						i.remove();
					}
				}
				try
				{	sleep(mPollInterval);
				}
				catch(InterruptedException e){};
			}
		}
		
	}
}
