<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
	<xsl:output method="xml"/>
	<xsl:param name="param"/>
	<xsl:key name="forums" match="row" use="groupid"/>
	<xsl:template match="/">
		<div title="Advanced Search" desc=" ">
		<script language="javascript" type="text/javascript">
		<xsl:comment>
		function searchsubmit()
		{	searchform.submit();
		}
		function init()
		{	searchform.search.focus();
		}
			</xsl:comment>
		</script>
		
			<form name="searchform" action="xrl:search-new-submit" method="POST" xrl:resolve="action" >
				<table style="background: url([[xrl:img-flat]]);" xrl:resolve="style">
					<tr>
						<td>Search Terms:</td><td colspan="4"><input name="search" style="width: 400px;"/></td>
					</tr>
					<tr>
						<td>User ID:</td>
						<td ><input name="userid"/></td>
						<td>Period:</td>
						<td colspan="4">
							<select name="duration">
								<option selected="true" value="0">All</option>
								<option value="1">last hour</option>
								<option value="6">last 6 hours</option>
								<option value="12">last 12 hours</option>
								<option value="24">last day</option>
								<option value="72">last 3 days</option>
								<option value="168">last week</option>
								<option value="720">last month</option>
								<option value="2160">last 3 months</option>
								<option value="8760">last year</option>
							</select>
						</td>
					</tr>
					<tr>
						<td>Forum:</td>
						<td>
							<select name="forumid">
								<option selected="true" value="0">All</option>
								<xsl:apply-templates/>
							</select>
						</td>
						<td>Search Type:</td>
						<td>
							topic <input type="radio"  value="0" name="type"/>
							entry <input type="radio" CHECKED="true" value="1" name="type"/>
						</td>
					</tr>
					<tr>
						<td colspan="5" class="titlebar" style="text-align: right;">
							<a href="#" onclick="searchsubmit()"><span class="aa">&#160;</span><span class="bb">Search</span><span class="cc">&#160;</span></a>
						</td>
					</tr>
				</table>
			</form>
		</div>
	</xsl:template>
	<xsl:template match="null">
		<option disabled="true">No Forums Set Up</option>
	</xsl:template>
	<xsl:template match="results">
		<xsl:for-each select="row[count(. | key('forums', groupid)[1]) = 1]">
			<optgroup label="{groupname}">
				<xsl:for-each select="key('forums',groupid)">
					<xsl:variable name="tempid" select="id"/>
					<xsl:variable name="temp" select="$param/results/row[forumid=$tempid]/topics"/>
					<option value="{$tempid}" label="{name}"> <xsl:value-of select="name"/> 
						[ <xsl:choose>
						  <xsl:when test="$temp > 0"><xsl:value-of select="$temp"/></xsl:when>
						  <xsl:otherwise>0</xsl:otherwise>
						  </xsl:choose>   ]
					</option>
				</xsl:for-each>
			</optgroup>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet> 
