package org.ten60.netkernel.protocolhandler.sjar;

import java.io.*;
import java.net.*;

public class EncryptedJarURLConnection extends URLConnection
{
	public EncryptedJarURLConnection(URL aURL)
	{	super(aURL);
	}
	
	@Override
	public void connect() throws IOException
	{
	}
	
	public InputStream getInputStream() throws IOException
	{	String urlString=getURL().toString();
		int i=urlString.indexOf('!');
		String classLoaderId=urlString.substring(5, i);
		String name=urlString.substring(i+1);
		try
		{	ClassLoader cl=Handler.getClassLoader(classLoaderId);
			if (cl==null)
			{	throw new IOException("Encrypted Classloader for "+classLoaderId+" no longer valid");
			}
			return cl.getResourceAsStream(name);
		}
		catch (Exception e)
		{	IOException e2=new IOException();
			e2.initCause(e);
			throw e2;
		}
	}
	
	public String getContentType()
	{	return URLConnection.getFileNameMap().getContentTypeFor(getURL().toString());	
	}

}
