﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/savingsplans/SavingsPlansRequest.h>
#include <aws/savingsplans/SavingsPlans_EXPORTS.h>

#include <utility>

namespace Aws {
namespace SavingsPlans {
namespace Model {

/**
 */
class DeleteQueuedSavingsPlanRequest : public SavingsPlansRequest {
 public:
  AWS_SAVINGSPLANS_API DeleteQueuedSavingsPlanRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteQueuedSavingsPlan"; }

  AWS_SAVINGSPLANS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ID of the Savings Plan.</p>
   */
  inline const Aws::String& GetSavingsPlanId() const { return m_savingsPlanId; }
  inline bool SavingsPlanIdHasBeenSet() const { return m_savingsPlanIdHasBeenSet; }
  template <typename SavingsPlanIdT = Aws::String>
  void SetSavingsPlanId(SavingsPlanIdT&& value) {
    m_savingsPlanIdHasBeenSet = true;
    m_savingsPlanId = std::forward<SavingsPlanIdT>(value);
  }
  template <typename SavingsPlanIdT = Aws::String>
  DeleteQueuedSavingsPlanRequest& WithSavingsPlanId(SavingsPlanIdT&& value) {
    SetSavingsPlanId(std::forward<SavingsPlanIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_savingsPlanId;
  bool m_savingsPlanIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SavingsPlans
}  // namespace Aws
