//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<T, 3>, 400> tgamma_ratio_data = { {
      { SC_(6.68193912506103515625), SC_(6.68193912506103515625), SC_(1) }, 
      { SC_(6.68193912506103515625), SC_(8.095367431640625), SC_(0.06544775114440229981894259276990196062764) }, 
      { SC_(6.68193912506103515625), SC_(8.50289630889892578125), SC_(0.02833082889188931171456297874515804727699) }, 
      { SC_(6.68193912506103515625), SC_(11.04233455657958984375), SC_(0.9977723749373989179839784596883914860086e-4) }, 
      { SC_(6.68193912506103515625), SC_(12.6096343994140625), SC_(0.2224848351207471598094573384811702572789e-5) }, 
      { SC_(6.68193912506103515625), SC_(15.36791515350341796875), SC_(0.1707401795086213382244662934709192347257e-8) }, 
      { SC_(6.68193912506103515625), SC_(16.792018890380859375), SC_(0.3420632447590243481697274715444998893408e-10) }, 
      { SC_(6.68193912506103515625), SC_(28.25031280517578125), SC_(0.1600680453581408921824330663433115251581e-25) }, 
      { SC_(6.68193912506103515625), SC_(28.2665882110595703125), SC_(0.1516395254249637529260062571562632237052e-25) }, 
      { SC_(6.68193912506103515625), SC_(32.353244781494140625), SC_(0.1435206894862598198928388181910160004221e-31) }, 
      { SC_(6.68193912506103515625), SC_(41.1067352294921875), SC_(0.3302103464979977987816033282184687805192e-45) }, 
      { SC_(6.68193912506103515625), SC_(42.080410003662109375), SC_(0.886133585915892288509502556440259057933e-47) }, 
      { SC_(6.68193912506103515625), SC_(45.4780120849609375), SC_(0.2445790945282646979483178649067515339092e-52) }, 
      { SC_(6.68193912506103515625), SC_(45.842041015625), SC_(0.6109956711604874877647044786673395753644e-53) }, 
      { SC_(6.68193912506103515625), SC_(47.9603271484375), SC_(0.1802664125152357631935884543327977871009e-56) }, 
      { SC_(6.68193912506103515625), SC_(48.314647674560546875), SC_(0.4585435903890089500439815393256424830955e-57) }, 
      { SC_(6.68193912506103515625), SC_(48.4493560791015625), SC_(0.2722991298511892486629788976421558265475e-57) }, 
      { SC_(6.68193912506103515625), SC_(48.50565338134765625), SC_(0.2189817526247552395152959212887295282992e-57) }, 
      { SC_(6.68193912506103515625), SC_(49.65830230712890625), SC_(0.2491707234921651072352951178714074480602e-59) }, 
      { SC_(6.68193912506103515625), SC_(49.830142974853515625), SC_(0.1275499540450052064566893368701946482382e-59) }, 
      { SC_(8.095367431640625), SC_(6.68193912506103515625), SC_(15.27936380569631379215981282038521263139) }, 
      { SC_(8.095367431640625), SC_(8.095367431640625), SC_(1) }, 
      { SC_(8.095367431640625), SC_(8.50289630889892578125), SC_(0.4328770415561089543785983031850532551013) }, 
      { SC_(8.095367431640625), SC_(11.04233455657958984375), SC_(0.001524532711194214483439552686740177905313) }, 
      { SC_(8.095367431640625), SC_(12.6096343994140625), SC_(0.3399426737060256217390151315994565352827e-4) }, 
      { SC_(8.095367431640625), SC_(15.36791515350341796875), SC_(0.2608801318962120302585268540253614111335e-7) }, 
      { SC_(8.095367431640625), SC_(16.792018890380859375), SC_(0.5226508761230075927654898387420647235484e-9) }, 
      { SC_(8.095367431640625), SC_(28.25031280517578125), SC_(0.2445737898693733797769611259209203584443e-24) }, 
      { SC_(8.095367431640625), SC_(28.2665882110595703125), SC_(0.2316955476291157102884553711299427658036e-24) }, 
      { SC_(8.095367431640625), SC_(32.353244781494140625), SC_(0.2192904828304937772446028970624034599691e-30) }, 
      { SC_(8.095367431640625), SC_(41.1067352294921875), SC_(0.5045404016547946090253729607520301559963e-44) }, 
      { SC_(8.095367431640625), SC_(42.080410003662109375), SC_(0.1353955743965516944489997901950715452755e-45) }, 
      { SC_(8.095367431640625), SC_(45.4780120849609375), SC_(0.3737012964565144972084775063603050427547e-51) }, 
      { SC_(8.095367431640625), SC_(45.842041015625), SC_(0.9335625143366679579486394992496451351018e-52) }, 
      { SC_(8.095367431640625), SC_(47.9603271484375), SC_(0.2754356098768014320479195593046571558735e-55) }, 
      { SC_(8.095367431640625), SC_(48.314647674560546875), SC_(0.7006254338323859447417411411637098417379e-56) }, 
      { SC_(8.095367431640625), SC_(48.4493560791015625), SC_(0.4160557468970861681934763285488463143071e-56) }, 
      { SC_(8.095367431640625), SC_(48.50565338134765625), SC_(0.3345901865162628968218063609001765927876e-56) }, 
      { SC_(8.095367431640625), SC_(49.65830230712890625), SC_(0.3807170133965351751944945486685393449817e-58) }, 
      { SC_(8.095367431640625), SC_(49.830142974853515625), SC_(0.1948882151253480684761778785767440869907e-58) }, 
      { SC_(8.50289630889892578125), SC_(6.68193912506103515625), SC_(35.29723764228744086812043153239973434675) }, 
      { SC_(8.50289630889892578125), SC_(8.095367431640625), SC_(2.310124825297257793166027233518450467265) }, 
      { SC_(8.50289630889892578125), SC_(8.50289630889892578125), SC_(1) }, 
      { SC_(8.50289630889892578125), SC_(11.04233455657958984375), SC_(0.003521860863107489503907274588697768037321) }, 
      { SC_(8.50289630889892578125), SC_(12.6096343994140625), SC_(0.7853100097062151498541705753484156861086e-4) }, 
      { SC_(8.50289630889892578125), SC_(15.36791515350341796875), SC_(0.6026656691202623868522041531664940403622e-7) }, 
      { SC_(8.50289630889892578125), SC_(16.792018890380859375), SC_(0.1207388763895121639743664392369700074862e-8) }, 
      { SC_(8.50289630889892578125), SC_(28.25031280517578125), SC_(0.564995983594274416859732458938454292755e-24) }, 
      { SC_(8.50289630889892578125), SC_(28.2665882110595703125), SC_(0.5352456364888634023094937531252471776606e-24) }, 
      { SC_(8.50289630889892578125), SC_(32.353244781494140625), SC_(0.5065883883381457468092824152960142285326e-30) }, 
      { SC_(8.50289630889892578125), SC_(41.1067352294921875), SC_(0.1165551307228190672944688371949229156942e-43) }, 
      { SC_(8.50289630889892578125), SC_(42.080410003662109375), SC_(0.3127806776488558533920147278994474194652e-45) }, 
      { SC_(8.50289630889892578125), SC_(45.4780120849609375), SC_(0.8632966421899642956616439002226661768323e-51) }, 
      { SC_(8.50289630889892578125), SC_(45.842041015625), SC_(0.2156645940336063790233453759917649217215e-51) }, 
      { SC_(8.50289630889892578125), SC_(47.9603271484375), SC_(0.636290640147289561320766371462864805633e-55) }, 
      { SC_(8.50289630889892578125), SC_(48.314647674560546875), SC_(0.1618532207930856030225979904296120628837e-55) }, 
      { SC_(8.50289630889892578125), SC_(48.4493560791015625), SC_(0.9611407096145512904645460867653415148676e-56) }, 
      { SC_(8.50289630889892578125), SC_(48.50565338134765625), SC_(0.7729450961720587246333022260051616437986e-56) }, 
      { SC_(8.50289630889892578125), SC_(49.65830230712890625), SC_(0.8795038240603645764255409327191808130351e-58) }, 
      { SC_(8.50289630889892578125), SC_(49.830142974853515625), SC_(0.4502161039189391004948453748106238664575e-58) }, 
      { SC_(11.04233455657958984375), SC_(6.68193912506103515625), SC_(10022.32598454873883529802018481680750483) }, 
      { SC_(11.04233455657958984375), SC_(8.095367431640625), SC_(655.9386969248226283606008285879854206903) }, 
      { SC_(11.04233455657958984375), SC_(8.50289630889892578125), SC_(283.9408025669864016979029738036125553433) }, 
      { SC_(11.04233455657958984375), SC_(11.04233455657958984375), SC_(1) }, 
      { SC_(11.04233455657958984375), SC_(12.6096343994140625), SC_(0.02229815544198706106548155624884338219975) }, 
      { SC_(11.04233455657958984375), SC_(15.36791515350341796875), SC_(0.1711213737695771757346056723032012217735e-4) }, 
      { SC_(11.04233455657958984375), SC_(16.792018890380859375), SC_(0.3428269346307424929677451108232473785575e-6) }, 
      { SC_(11.04233455657958984375), SC_(28.25031280517578125), SC_(0.1604254130288821602431198288556314166807e-21) }, 
      { SC_(11.04233455657958984375), SC_(28.2665882110595703125), SC_(0.1519780755951253359775307669534328048275e-21) }, 
      { SC_(11.04233455657958984375), SC_(32.353244781494140625), SC_(0.1438411135558492779877017607560708527594e-27) }, 
      { SC_(11.04233455657958984375), SC_(41.1067352294921875), SC_(0.3309475736073725983644333568012576866264e-41) }, 
      { SC_(11.04233455657958984375), SC_(42.080410003662109375), SC_(0.8881119663906199633527956939754857810864e-43) }, 
      { SC_(11.04233455657958984375), SC_(45.4780120849609375), SC_(0.2451251414368029552147021978423765349146e-48) }, 
      { SC_(11.04233455657958984375), SC_(45.842041015625), SC_(0.6123597791518550235695817819538449632323e-49) }, 
      { SC_(11.04233455657958984375), SC_(47.9603271484375), SC_(0.180668875029282936658813531008123567654e-52) }, 
      { SC_(11.04233455657958984375), SC_(48.314647674560546875), SC_(0.4595673341004037743757791338005707049264e-53) }, 
      { SC_(11.04233455657958984375), SC_(48.4493560791015625), SC_(0.2729070644677585167543616613362210307431e-53) }, 
      { SC_(11.04233455657958984375), SC_(48.50565338134765625), SC_(0.2194706509473108430521121242061760144749e-53) }, 
      { SC_(11.04233455657958984375), SC_(49.65830230712890625), SC_(0.2497270216644335227261900379388968235955e-55) }, 
      { SC_(11.04233455657958984375), SC_(49.830142974853515625), SC_(0.127834721875325319931113426696772699846e-55) }, 
      { SC_(12.6096343994140625), SC_(6.68193912506103515625), SC_(449468.8365871225090880637003804075021215) }, 
      { SC_(12.6096343994140625), SC_(8.095367431640625), SC_(29416.72456411801748141580864552978721433) }, 
      { SC_(12.6096343994140625), SC_(8.50289630889892578125), SC_(12733.82470158632612073644637648016869683) }, 
      { SC_(12.6096343994140625), SC_(11.04233455657958984375), SC_(44.84675885418828848059201630601876129123) }, 
      { SC_(12.6096343994140625), SC_(12.6096343994140625), SC_(1) }, 
      { SC_(12.6096343994140625), SC_(15.36791515350341796875), SC_(0.0007674238984241648745176133088803894583239) }, 
      { SC_(12.6096343994140625), SC_(16.792018890380859375), SC_(0.1537467686610548047972289678594381553999e-4) }, 
      { SC_(12.6096343994140625), SC_(28.25031280517578125), SC_(0.7194559812189834234873335855778439262532e-20) }, 
      { SC_(12.6096343994140625), SC_(28.2665882110595703125), SC_(0.6815724107338184201427157411756637985805e-20) }, 
      { SC_(12.6096343994140625), SC_(32.353244781494140625), SC_(0.6450807732957086655802565782661071132734e-26) }, 
      { SC_(12.6096343994140625), SC_(41.1067352294921875), SC_(0.1484192602694856741116728422617234274272e-39) }, 
      { SC_(12.6096343994140625), SC_(42.080410003662109375), SC_(0.3982894319223910751678842349927917812786e-41) }, 
      { SC_(12.6096343994140625), SC_(45.4780120849609375), SC_(0.1099306810711509945366434998730348639623e-46) }, 
      { SC_(12.6096343994140625), SC_(45.842041015625), SC_(0.274623513476272391811856859108919204364e-47) }, 
      { SC_(12.6096343994140625), SC_(47.9603271484375), SC_(0.810241347089573191684429945851439473934e-51) }, 
      { SC_(12.6096343994140625), SC_(48.314647674560546875), SC_(0.2061010540966299032852947974148368428554e-51) }, 
      { SC_(12.6096343994140625), SC_(48.4493560791015625), SC_(0.1223899730978998331529903787096767961407e-51) }, 
      { SC_(12.6096343994140625), SC_(48.50565338134765625), SC_(0.9842547358605779833538923712423232570025e-52) }, 
      { SC_(12.6096343994140625), SC_(49.65830230712890625), SC_(0.111994475199595046236871390285568219201e-53) }, 
      { SC_(12.6096343994140625), SC_(49.830142974853515625), SC_(0.5732972945134943081299851732612679934763e-54) }, 
      { SC_(15.36791515350341796875), SC_(6.68193912506103515625), SC_(585685222.3524258951890582394256083001576) }, 
      { SC_(15.36791515350341796875), SC_(8.095367431640625), SC_(38331780.68147549731194464361117084556401) }, 
      { SC_(15.36791515350341796875), SC_(8.50289630889892578125), SC_(16592947.81897472326464314439304676524505) }, 
      { SC_(15.36791515350341796875), SC_(11.04233455657958984375), SC_(58438.05352723185438142316878015214017381) }, 
      { SC_(15.36791515350341796875), SC_(12.6096343994140625), SC_(1303.060801277376142822908410792545798171) }, 
      { SC_(15.36791515350341796875), SC_(15.36791515350341796875), SC_(1) }, 
      { SC_(15.36791515350341796875), SC_(16.792018890380859375), SC_(0.02003413875652814571066652179078989954041) }, 
      { SC_(15.36791515350341796875), SC_(28.25031280517578125), SC_(0.9374948873710094212165195726862414559537e-17) }, 
      { SC_(15.36791515350341796875), SC_(28.2665882110595703125), SC_(0.8881302916593623546835793196764015323998e-17) }, 
      { SC_(15.36791515350341796875), SC_(32.353244781494140625), SC_(0.8405794693393355603396329554611706213959e-23) }, 
      { SC_(15.36791515350341796875), SC_(41.1067352294921875), SC_(0.1933993202117514403001606514962407598318e-36) }, 
      { SC_(15.36791515350341796875), SC_(42.080410003662109375), SC_(0.5189953463011018705972746440289999179347e-38) }, 
      { SC_(15.36791515350341796875), SC_(45.4780120849609375), SC_(0.1432463613615417012262764752176405209169e-43) }, 
      { SC_(15.36791515350341796875), SC_(45.842041015625), SC_(0.3578511355199998082650674837507222484761e-44) }, 
      { SC_(15.36791515350341796875), SC_(47.9603271484375), SC_(0.1055793738966599881515782984097509185645e-47) }, 
      { SC_(15.36791515350341796875), SC_(48.314647674560546875), SC_(0.2685622046952664085925475589049444464689e-48) }, 
      { SC_(15.36791515350341796875), SC_(48.4493560791015625), SC_(0.159481576413265866664196980708080144396e-48) }, 
      { SC_(15.36791515350341796875), SC_(48.50565338134765625), SC_(0.1282543764771536953500275331153719160188e-48) }, 
      { SC_(15.36791515350341796875), SC_(49.65830230712890625), SC_(0.1459356105922235513733892190510350897202e-50) }, 
      { SC_(15.36791515350341796875), SC_(49.830142974853515625), SC_(0.7470412319589057907037612756557718622482e-51) }, 
      { SC_(16.792018890380859375), SC_(6.68193912506103515625), SC_(29234359882.90635823391118605921737816835) }, 
      { SC_(16.792018890380859375), SC_(8.095367431640625), SC_(1913323110.482353290836130472488425746906) }, 
      { SC_(16.792018890380859375), SC_(8.50289630889892578125), SC_(828233647.6065332896125053819194270835445) }, 
      { SC_(16.792018890380859375), SC_(11.04233455657958984375), SC_(2916923.66901420963969346588479017097418) }, 
      { SC_(16.792018890380859375), SC_(12.6096343994140625), SC_(65042.01738409006356831104197838388691427) }, 
      { SC_(16.792018890380859375), SC_(15.36791515350341796875), SC_(49.9147985422706989087560343640323085763) }, 
      { SC_(16.792018890380859375), SC_(16.792018890380859375), SC_(1) }, 
      { SC_(16.792018890380859375), SC_(28.25031280517578125), SC_(0.4679486843753269411418228862517177379389e-15) }, 
      { SC_(16.792018890380859375), SC_(28.2665882110595703125), SC_(0.4433084458746519072299497981474666747637e-15) }, 
      { SC_(16.792018890380859375), SC_(32.353244781494140625), SC_(0.419573548708417442755623486522184770071e-21) }, 
      { SC_(16.792018890380859375), SC_(41.1067352294921875), SC_(0.9653488106581674908496338905387581380105e-35) }, 
      { SC_(16.792018890380859375), SC_(42.080410003662109375), SC_(0.2590554815499551621737548550309621496934e-36) }, 
      { SC_(16.792018890380859375), SC_(45.4780120849609375), SC_(0.7150113269274663476945386520712712949033e-42) }, 
      { SC_(16.792018890380859375), SC_(45.842041015625), SC_(0.1786206733760360075331184170337082524712e-42) }, 
      { SC_(16.792018890380859375), SC_(47.9603271484375), SC_(0.5269973178270857056559108922900691907527e-46) }, 
      { SC_(16.792018890380859375), SC_(48.314647674560546875), SC_(0.1340522834343228878166099251049916502985e-46) }, 
      { SC_(16.792018890380859375), SC_(48.4493560791015625), SC_(0.796049075787191615953018903526662612784e-47) }, 
      { SC_(16.792018890380859375), SC_(48.50565338134765625), SC_(0.6401791364021668688723017597840705133371e-47) }, 
      { SC_(16.792018890380859375), SC_(49.65830230712890625), SC_(0.7284346602854104489166470773879541649632e-49) }, 
      { SC_(16.792018890380859375), SC_(49.830142974853515625), SC_(0.372884125959984978120224998171471298247e-49) }, 
      { SC_(28.25031280517578125), SC_(6.68193912506103515625), SC_(62473431081298641804777214.01857405903626) }, 
      { SC_(28.25031280517578125), SC_(8.095367431640625), SC_(4088745570545801391196983.124699172800273) }, 
      { SC_(28.25031280517578125), SC_(8.50289630889892578125), SC_(1769924086253511285151384.459061053897955) }, 
      { SC_(28.25031280517578125), SC_(11.04233455657958984375), SC_(6233426370047525953488.420164061292416669) }, 
      { SC_(28.25031280517578125), SC_(12.6096343994140625), SC_(138993910135500892742.7864695002243476543) }, 
      { SC_(28.25031280517578125), SC_(15.36791515350341796875), SC_(106667248373404137.7424862606421119365799) }, 
      { SC_(28.25031280517578125), SC_(16.792018890380859375), SC_(2136986454689829.645294520260977067722367) }, 
      { SC_(28.25031280517578125), SC_(28.25031280517578125), SC_(1) }, 
      { SC_(28.25031280517578125), SC_(28.2665882110595703125), SC_(0.9473441440837306156894435405765205616538) }, 
      { SC_(28.25031280517578125), SC_(32.353244781494140625), SC_(0.8966229903360315432265785471347575366187e-6) }, 
      { SC_(28.25031280517578125), SC_(41.1067352294921875), SC_(0.2062937332427440980050647255152934022249e-19) }, 
      { SC_(28.25031280517578125), SC_(42.080410003662109375), SC_(0.553598055085405256821894026839771351121e-21) }, 
      { SC_(28.25031280517578125), SC_(45.4780120849609375), SC_(0.1527969520593797035600021603243532845096e-26) }, 
      { SC_(28.25031280517578125), SC_(45.842041015625), SC_(0.3817099595321652320717752915013554974954e-27) }, 
      { SC_(28.25031280517578125), SC_(47.9603271484375), SC_(0.1126186129854353240111534853152770388436e-30) }, 
      { SC_(28.25031280517578125), SC_(48.314647674560546875), SC_(0.2864679139193898490586764981708771633065e-31) }, 
      { SC_(28.25031280517578125), SC_(48.4493560791015625), SC_(0.1701146092225586121581280766773655435017e-31) }, 
      { SC_(28.25031280517578125), SC_(48.50565338134765625), SC_(0.1368054143066463441616962191169102146762e-31) }, 
      { SC_(28.25031280517578125), SC_(49.65830230712890625), SC_(0.1556655002156509726489852834384209795324e-33) }, 
      { SC_(28.25031280517578125), SC_(49.830142974853515625), SC_(0.7968483263453441686333408562785570804228e-34) }, 
      { SC_(28.2665882110595703125), SC_(6.68193912506103515625), SC_(65945867160790676450552857.01051299229165) }, 
      { SC_(28.2665882110595703125), SC_(8.095367431640625), SC_(4316008702941240037030002.970305100839337) }, 
      { SC_(28.2665882110595703125), SC_(8.50289630889892578125), SC_(1868301078659623070981861.405928035183232) }, 
      { SC_(28.2665882110595703125), SC_(11.04233455657958984375), SC_(6579896449432833748117.437551199783201593) }, 
      { SC_(28.2665882110595703125), SC_(12.6096343994140625), SC_(146719553821632082804.7687454166146662184) }, 
      { SC_(28.2665882110595703125), SC_(15.36791515350341796875), SC_(112596091968850970.8439271882044997354661) }, 
      { SC_(28.2665882110595703125), SC_(16.792018890380859375), SC_(2255765729946764.722783709551185452202524) }, 
      { SC_(28.2665882110595703125), SC_(28.25031280517578125), SC_(1.055582605587537593437732203893348754805) }, 
      { SC_(28.2665882110595703125), SC_(28.2665882110595703125), SC_(1) }, 
      { SC_(28.2665882110595703125), SC_(32.353244781494140625), SC_(0.946459632368597715724256879722277889397e-6) }, 
      { SC_(28.2665882110595703125), SC_(41.1067352294921875), SC_(0.2177600764527562358912888887116281649999e-19) }, 
      { SC_(28.2665882110595703125), SC_(42.080410003662109375), SC_(0.5843684774352452474934370286317541360408e-21) }, 
      { SC_(28.2665882110595703125), SC_(45.4780120849609375), SC_(0.1612898047806740956655833448766443166678e-26) }, 
      { SC_(28.2665882110595703125), SC_(45.842041015625), SC_(0.4029263936616765079754966175414281085225e-27) }, 
      { SC_(28.2665882110595703125), SC_(47.9603271484375), SC_(0.1188782489328203152284704530721443158468e-30) }, 
      { SC_(28.2665882110595703125), SC_(48.314647674560546875), SC_(0.3023905469922559656212402750407249939149e-31) }, 
      { SC_(28.2665882110595703125), SC_(48.4493560791015625), SC_(0.1795700224516541726982838382009867434233e-31) }, 
      { SC_(28.2665882110595703125), SC_(48.50565338134765625), SC_(0.1444094156922923406749087286540824516294e-31) }, 
      { SC_(28.2665882110595703125), SC_(49.65830230712890625), SC_(0.1643177943177242488575839919764428781058e-33) }, 
      { SC_(28.2665882110595703125), SC_(49.830142974853515625), SC_(0.8411392325816868751433694045787429766788e-34) }, 
      { SC_(32.353244781494140625), SC_(6.68193912506103515625), SC_(69676365378368432444795020485251.09307195) }, 
      { SC_(32.353244781494140625), SC_(8.095367431640625), SC_(4560161421929905356568615578557.279365205) }, 
      { SC_(32.353244781494140625), SC_(8.50289630889892578125), SC_(1973989185343316540308533930865.349847103) }, 
      { SC_(32.353244781494140625), SC_(11.04233455657958984375), SC_(6952115256058062860184065801.537866840414) }, 
      { SC_(32.353244781494140625), SC_(12.6096343994140625), SC_(155019346630192364869728602.8869080120199) }, 
      { SC_(32.353244781494140625), SC_(15.36791515350341796875), SC_(118965551322109150849363.3326200253802755) }, 
      { SC_(32.353244781494140625), SC_(16.792018890380859375), SC_(2383372362434005124341.330168450523485149) }, 
      { SC_(32.353244781494140625), SC_(28.25031280517578125), SC_(1115295.961377507593179097024286242566993) }, 
      { SC_(32.353244781494140625), SC_(28.2665882110595703125), SC_(1056569.097931216409235840463512256440074) }, 
      { SC_(32.353244781494140625), SC_(32.353244781494140625), SC_(1) }, 
      { SC_(32.353244781494140625), SC_(41.1067352294921875), SC_(0.230078567543121375786035848816303846874e-13) }, 
      { SC_(32.353244781494140625), SC_(42.080410003662109375), SC_(0.6174256750631954623455466167532501015427e-15) }, 
      { SC_(32.353244781494140625), SC_(45.4780120849609375), SC_(0.1704138235426188251628860349588581827493e-20) }, 
      { SC_(32.353244781494140625), SC_(45.842041015625), SC_(0.4257195762837957410297568654413945699168e-21) }, 
      { SC_(32.353244781494140625), SC_(47.9603271484375), SC_(0.1256030842385925502316656928127624131602e-24) }, 
      { SC_(32.353244781494140625), SC_(48.314647674560546875), SC_(0.3194965074585349909462871592988276775566e-25) }, 
      { SC_(32.353244781494140625), SC_(48.4493560791015625), SC_(0.1897281366372325269179364605155767999302e-25) }, 
      { SC_(32.353244781494140625), SC_(48.50565338134765625), SC_(0.1525785260707793657877269919853594083335e-25) }, 
      { SC_(32.353244781494140625), SC_(49.65830230712890625), SC_(0.1736131037163250671085653648527909187315e-27) }, 
      { SC_(32.353244781494140625), SC_(49.830142974853515625), SC_(0.8887217202033885362390904748570386562007e-28) }, 
      { SC_(41.1067352294921875), SC_(6.68193912506103515625), SC_(0.3028372704263715163504835952465575625009e46) }, 
      { SC_(41.1067352294921875), SC_(8.095367431640625), SC_(0.1982001831211522515605797569074004688054e45) }, 
      { SC_(41.1067352294921875), SC_(8.50289630889892578125), SC_(0.8579630890536342775918208432530877707955e44) }, 
      { SC_(41.1067352294921875), SC_(11.04233455657958984375), SC_(302162662532880029697903971434181885302200.0) }, 
      { SC_(41.1067352294921875), SC_(12.6096343994140625), SC_(6737670017922838675237007504871318596192.0) }, 
      { SC_(41.1067352294921875), SC_(15.36791515350341796875), SC_(5170648991449957677068866653769066986.814) }, 
      { SC_(41.1067352294921875), SC_(16.792018890380859375), SC_(103589499356010765818921585961423599.4406) }, 
      { SC_(41.1067352294921875), SC_(28.25031280517578125), SC_(48474569938744015282.50089093176414961015) }, 
      { SC_(41.1067352294921875), SC_(28.2665882110595703125), SC_(45922099968446387179.17575255265451239527) }, 
      { SC_(41.1067352294921875), SC_(32.353244781494140625), SC_(43463413853729.76037096250807199942469819) }, 
      { SC_(41.1067352294921875), SC_(41.1067352294921875), SC_(1) }, 
      { SC_(41.1067352294921875), SC_(42.080410003662109375), SC_(0.02683542763919013909823206518554211904957) }, 
      { SC_(41.1067352294921875), SC_(45.4780120849609375), SC_(0.7406766539029317836568766778650968264162e-7) }, 
      { SC_(41.1067352294921875), SC_(45.842041015625), SC_(0.1850322612965709134600999956420699350719e-7) }, 
      { SC_(41.1067352294921875), SC_(47.9603271484375), SC_(0.5459138831566829558309567482447033388885e-11) }, 
      { SC_(41.1067352294921875), SC_(48.314647674560546875), SC_(0.1388640892849156343838425312044005814203e-11) }, 
      { SC_(41.1067352294921875), SC_(48.4493560791015625), SC_(0.8246232522361025121401647179764922571392e-12) }, 
      { SC_(41.1067352294921875), SC_(48.50565338134765625), SC_(0.6631583623806379307271172259961006876675e-12) }, 
      { SC_(41.1067352294921875), SC_(49.65830230712890625), SC_(0.7545818177253144666989552303444049809065e-14) }, 
      { SC_(41.1067352294921875), SC_(49.830142974853515625), SC_(0.3862687992599850117573354058793833486253e-14) }, 
      { SC_(42.080410003662109375), SC_(6.68193912506103515625), SC_(0.1128498023203146467978663132245598816091e48) }, 
      { SC_(42.080410003662109375), SC_(8.095367431640625), SC_(0.7385765778954946234446180905963261307482e46) }, 
      { SC_(42.080410003662109375), SC_(8.50289630889892578125), SC_(0.3197128440020367682901023819522755999032e46) }, 
      { SC_(42.080410003662109375), SC_(11.04233455657958984375), SC_(0.1125984152723563361522473811515367817721e44) }, 
      { SC_(42.080410003662109375), SC_(12.6096343994140625), SC_(251073696626441144561432672710834135268300.0) }, 
      { SC_(42.080410003662109375), SC_(15.36791515350341796875), SC_(192679955056829556051143882191265710675.0) }, 
      { SC_(42.080410003662109375), SC_(16.792018890380859375), SC_(3860176955210130283165178693263746156.27) }, 
      { SC_(42.080410003662109375), SC_(28.25031280517578125), SC_(1806364727646535818340.866372759728419801) }, 
      { SC_(42.080410003662109375), SC_(28.2665882110595703125), SC_(1711249046815348640197.005994210828789221) }, 
      { SC_(42.080410003662109375), SC_(32.353244781494140625), SC_(1619628143739968.135644008131561755350781) }, 
      { SC_(42.080410003662109375), SC_(41.1067352294921875), SC_(37.26417232642165549644699320646567792716) }, 
      { SC_(42.080410003662109375), SC_(42.080410003662109375), SC_(1) }, 
      { SC_(42.080410003662109375), SC_(45.4780120849609375), SC_(0.2760070246919622084502054144846970360933e-5) }, 
      { SC_(42.080410003662109375), SC_(45.842041015625), SC_(0.6895074070902898582052114538188684005049e-6) }, 
      { SC_(42.080410003662109375), SC_(47.9603271484375), SC_(0.2034302901733665011405155578658520655719e-9) }, 
      { SC_(42.080410003662109375), SC_(48.314647674560546875), SC_(0.517465535306469911855720960451549000057e-10) }, 
      { SC_(42.080410003662109375), SC_(48.4493560791015625), SC_(0.3072890297570039577779595302220767564036e-10) }, 
      { SC_(42.080410003662109375), SC_(48.50565338134765625), SC_(0.2471204749545967182493992970099398863642e-10) }, 
      { SC_(42.080410003662109375), SC_(49.65830230712890625), SC_(0.2811886689010061319057349807717059302635e-12) }, 
      { SC_(42.080410003662109375), SC_(49.830142974853515625), SC_(0.1439398709994405511661643560149446774768e-12) }, 
      { SC_(45.4780120849609375), SC_(6.68193912506103515625), SC_(0.4088656890028821935919901994836518337329e53) }, 
      { SC_(45.4780120849609375), SC_(8.095367431640625), SC_(0.2675933986534521789761510399776556126331e52) }, 
      { SC_(45.4780120849609375), SC_(8.50289630889892578125), SC_(0.1158350387490508487939853781677669230181e52) }, 
      { SC_(45.4780120849609375), SC_(11.04233455657958984375), SC_(0.4079548895468217136146832577597417438435e49) }, 
      { SC_(45.4780120849609375), SC_(12.6096343994140625), SC_(0.9096641540433693005638689695820108869159e47) }, 
      { SC_(45.4780120849609375), SC_(15.36791515350341796875), SC_(0.6980980113526825114452345252512805269161e44) }, 
      { SC_(45.4780120849609375), SC_(16.792018890380859375), SC_(1398579242509600215742913467593142392453000.0) }, 
      { SC_(45.4780120849609375), SC_(28.25031280517578125), SC_(654463316527008747358588396.4182679727482) }, 
      { SC_(45.4780120849609375), SC_(28.2665882110595703125), SC_(620001990429478771085895798.1037439457856) }, 
      { SC_(45.4780120849609375), SC_(32.353244781494140625), SC_(586806855929683317050.5676281369409460724) }, 
      { SC_(45.4780120849609375), SC_(41.1067352294921875), SC_(13501168.08367843372640089979813166357169) }, 
      { SC_(45.4780120849609375), SC_(42.080410003662109375), SC_(362309.6191540960051341986274244167826597) }, 
      { SC_(45.4780120849609375), SC_(45.4780120849609375), SC_(1) }, 
      { SC_(45.4780120849609375), SC_(45.842041015625), SC_(0.2498151660668111540689474747194753397522) }, 
      { SC_(45.4780120849609375), SC_(47.9603271484375), SC_(0.7370475095711965601458985817834731176697e-4) }, 
      { SC_(45.4780120849609375), SC_(48.314647674560546875), SC_(0.1874827410222575337847664727987528665907e-4) }, 
      { SC_(45.4780120849609375), SC_(48.4493560791015625), SC_(0.1113337713414917784311428006709225517837e-4) }, 
      { SC_(45.4780120849609375), SC_(48.50565338134765625), SC_(0.8953412516597925726495934549425902859791e-5) }, 
      { SC_(45.4780120849609375), SC_(49.65830230712890625), SC_(0.1018773595399707309340785036193597106951e-6) }, 
      { SC_(45.4780120849609375), SC_(49.830142974853515625), SC_(0.5215079984289701440670869280863151951865e-7) }, 
      { SC_(45.842041015625), SC_(6.68193912506103515625), SC_(0.1636672806700351389166966484348185959914e54) }, 
      { SC_(45.842041015625), SC_(8.095367431640625), SC_(0.1071165545577350466693581364316974639417e53) }, 
      { SC_(45.842041015625), SC_(8.50289630889892578125), SC_(0.4636829723863588581596877067885310518951e52) }, 
      { SC_(45.842041015625), SC_(11.04233455657958984375), SC_(0.1633026913336868030298032554541971522606e50) }, 
      { SC_(45.842041015625), SC_(12.6096343994140625), SC_(0.3641348795453381662072737343405240900951e48) }, 
      { SC_(45.842041015625), SC_(15.36791515350341796875), SC_(0.2794458088128971087287924855975453115427e45) }, 
      { SC_(45.842041015625), SC_(16.792018890380859375), SC_(5598456108687816423912115950356573721138000.0) }, 
      { SC_(45.842041015625), SC_(28.25031280517578125), SC_(2619790170593476068793811656.868928241947) }, 
      { SC_(45.842041015625), SC_(28.2665882110595703125), SC_(2481842876839847202336902693.583137646128) }, 
      { SC_(45.842041015625), SC_(32.353244781494140625), SC_(2348964096810464721249.700341060019563492) }, 
      { SC_(45.842041015625), SC_(41.1067352294921875), SC_(54044629.46043736056008882051200656905718) }, 
      { SC_(45.842041015625), SC_(42.080410003662109375), SC_(1450310.743172410399712309717648498747175) }, 
      { SC_(45.842041015625), SC_(45.4780120849609375), SC_(4.002959531018055381158848354630788302898) }, 
      { SC_(45.842041015625), SC_(45.842041015625), SC_(1) }, 
      { SC_(45.842041015625), SC_(47.9603271484375), SC_(0.0002950371353251142667227927363208965076247) }, 
      { SC_(45.842041015625), SC_(48.314647674560546875), SC_(0.7504858250764355503501479690846801695332e-4) }, 
      { SC_(45.842041015625), SC_(48.4493560791015625), SC_(0.445664581115609343906506002728080870345e-4) }, 
      { SC_(45.842041015625), SC_(48.50565338134765625), SC_(0.3584014796845201975736657965677048039208e-4) }, 
      { SC_(45.842041015625), SC_(49.65830230712890625), SC_(0.4078109473654790474115572859782508178562e-6) }, 
      { SC_(45.842041015625), SC_(49.830142974853515625), SC_(0.2087575412813395090396811867054620783866e-6) }, 
      { SC_(47.9603271484375), SC_(6.68193912506103515625), SC_(0.5547345099107033950192422871427381318326e57) }, 
      { SC_(47.9603271484375), SC_(8.095367431640625), SC_(0.3630612615584768705211358221068447588014e56) }, 
      { SC_(47.9603271484375), SC_(8.50289630889892578125), SC_(0.1571608848070621347187887625096797686567e56) }, 
      { SC_(47.9603271484375), SC_(11.04233455657958984375), SC_(0.5534987694133365838168750903207890846419e53) }, 
      { SC_(47.9603271484375), SC_(12.6096343994140625), SC_(0.1234200159732713260948046406761773059092e52) }, 
      { SC_(47.9603271484375), SC_(15.36791515350341796875), SC_(0.9471546980178058047156855714701255799749e48) }, 
      { SC_(47.9603271484375), SC_(16.792018890380859375), SC_(0.1897542864398623534143203275335123231973e47) }, 
      { SC_(47.9603271484375), SC_(28.25031280517578125), SC_(8879526869411252931939692217335.027581608) }, 
      { SC_(47.9603271484375), SC_(28.2665882110595703125), SC_(8411967781970891444582659322657.818992988) }, 
      { SC_(47.9603271484375), SC_(32.353244781494140625), SC_(7961587934420658260532166.45718487462272) }, 
      { SC_(47.9603271484375), SC_(41.1067352294921875), SC_(183179074732.0103620164004788697886647854) }, 
      { SC_(47.9603271484375), SC_(42.080410003662109375), SC_(4915688804.984666890973837709880731741309) }, 
      { SC_(47.9603271484375), SC_(45.4780120849609375), SC_(13567.6464137540515576016263211181519026) }, 
      { SC_(47.9603271484375), SC_(45.842041015625), SC_(3389.403841987743187937133456134050275288) }, 
      { SC_(47.9603271484375), SC_(47.9603271484375), SC_(1) }, 
      { SC_(47.9603271484375), SC_(48.314647674560546875), SC_(0.254369953887141203430836876547041268469) }, 
      { SC_(47.9603271484375), SC_(48.4493560791015625), SC_(0.1510537243471104529394000568510709829461) }, 
      { SC_(47.9603271484375), SC_(48.50565338134765625), SC_(0.1214767352216804846003235483194497619607) }, 
      { SC_(47.9603271484375), SC_(49.65830230712890625), SC_(0.001382235991805215999328194183512147103345) }, 
      { SC_(47.9603271484375), SC_(49.830142974853515625), SC_(0.0007075636124628870328952976620778296772766) }, 
      { SC_(48.314647674560546875), SC_(6.68193912506103515625), SC_(0.2180817747668531093722592544925729126253e58) }, 
      { SC_(48.314647674560546875), SC_(8.095367431640625), SC_(0.1427296172407059518070162204755669355033e57) }, 
      { SC_(48.314647674560546875), SC_(8.50289630889892578125), SC_(0.6178437445359259537189632854102462421372e56) }, 
      { SC_(48.314647674560546875), SC_(11.04233455657958984375), SC_(0.2175959703396859431461145671433618592455e54) }, 
      { SC_(48.314647674560546875), SC_(12.6096343994140625), SC_(0.4851988770184323241722734711404662380424e52) }, 
      { SC_(48.314647674560546875), SC_(15.36791515350341796875), SC_(0.3723532137125122728520959694032265459223e49) }, 
      { SC_(48.314647674560546875), SC_(16.792018890380859375), SC_(0.7459775949955649520346980577491792943738e47) }, 
      { SC_(48.314647674560546875), SC_(28.25031280517578125), SC_(34907923415164509403117907607646.53722193) }, 
      { SC_(48.314647674560546875), SC_(28.2665882110595703125), SC_(33069816829479440699668352125658.38663931) }, 
      { SC_(48.314647674560546875), SC_(32.353244781494140625), SC_(31299246678925977138939639.90617886264583) }, 
      { SC_(48.314647674560546875), SC_(41.1067352294921875), SC_(720128584106.6087836526782406609570068993) }, 
      { SC_(48.314647674560546875), SC_(42.080410003662109375), SC_(19324958509.70535007498641753925442032779) }, 
      { SC_(48.314647674560546875), SC_(45.4780120849609375), SC_(53338.24300559389759659482368493053044794) }, 
      { SC_(48.314647674560546875), SC_(45.842041015625), SC_(13324.70203415436802789403082858739642048) }, 
      { SC_(48.314647674560546875), SC_(47.9603271484375), SC_(3.931281917217627621819257075277788356756) }, 
      { SC_(48.314647674560546875), SC_(48.314647674560546875), SC_(1) }, 
      { SC_(48.314647674560546875), SC_(48.4493560791015625), SC_(0.5938347750541714176389461988432523691244) }, 
      { SC_(48.314647674560546875), SC_(48.50565338134765625), SC_(0.4775592925396261684537108441552323912968) }, 
      { SC_(48.314647674560546875), SC_(49.65830230712890625), SC_(0.005433959359911218576127565211220850249772) }, 
      { SC_(48.314647674560546875), SC_(49.830142974853515625), SC_(0.002781632034956529012301208404739032139) }, 
      { SC_(48.4493560791015625), SC_(6.68193912506103515625), SC_(0.3672431860309275848096310352210359300824e58) }, 
      { SC_(48.4493560791015625), SC_(8.095367431640625), SC_(0.2403524064882958752535382968929406576241e57) }, 
      { SC_(48.4493560791015625), SC_(8.50289630889892578125), SC_(0.10404303865154484506684282843186831567e57) }, 
      { SC_(48.4493560791015625), SC_(11.04233455657958984375), SC_(0.3664251059056556189399723271043139520834e54) }, 
      { SC_(48.4493560791015625), SC_(12.6096343994140625), SC_(0.8170603969330880027592995122246579755182e52) }, 
      { SC_(48.4493560791015625), SC_(15.36791515350341796875), SC_(0.6270316750623859609930109821539157012572e49) }, 
      { SC_(48.4493560791015625), SC_(16.792018890380859375), SC_(0.1256203958293810938859662896531064488227e48) }, 
      { SC_(48.4493560791015625), SC_(28.25031280517578125), SC_(58783898959066690330084982311593.58176901) }, 
      { SC_(48.4493560791015625), SC_(28.2665882110595703125), SC_(55688582445281536842136128249815.7120894) }, 
      { SC_(48.4493560791015625), SC_(32.353244781494140625), SC_(52706995268289507777255328.00690150146548) }, 
      { SC_(48.4493560791015625), SC_(41.1067352294921875), SC_(1212674997083.012627418774018726582479038) }, 
      { SC_(48.4493560791015625), SC_(42.080410003662109375), SC_(32542652134.07629836961371382993080880478) }, 
      { SC_(48.4493560791015625), SC_(45.4780120849609375), SC_(89820.00591111933541455358836544680644042) }, 
      { SC_(48.4493560791015625), SC_(45.842041015625), SC_(22438.39969280823627579795031102918220746) }, 
      { SC_(48.4493560791015625), SC_(47.9603271484375), SC_(6.620161166646065997774784626825861718786) }, 
      { SC_(48.4493560791015625), SC_(48.314647674560546875), SC_(1.683970090685202719773354093869942575742) }, 
      { SC_(48.4493560791015625), SC_(48.4493560791015625), SC_(1) }, 
      { SC_(48.4493560791015625), SC_(48.50565338134765625), SC_(0.8041955651655155335585413108852507830832) }, 
      { SC_(48.4493560791015625), SC_(49.65830230712890625), SC_(0.009150625036089400870200249124096593983071) }, 
      { SC_(48.4493560791015625), SC_(49.830142974853515625), SC_(0.004684185150158611142693380272341727749532) }, 
      { SC_(48.50565338134765625), SC_(6.68193912506103515625), SC_(0.4566590540142352287532525189812939660212e58) }, 
      { SC_(48.50565338134765625), SC_(8.095367431640625), SC_(0.2988730812496183533966920676743957277123e57) }, 
      { SC_(48.50565338134765625), SC_(8.50289630889892578125), SC_(0.1293752952120933719032874782784950114307e57) }, 
      { SC_(48.50565338134765625), SC_(11.04233455657958984375), SC_(0.4556417888604494171080971046736770628338e54) }, 
      { SC_(48.50565338134765625), SC_(12.6096343994140625), SC_(0.1015997143387534962938471142842497266745e53) }, 
      { SC_(48.50565338134765625), SC_(15.36791515350341796875), SC_(0.779700488566277306704754402527940807414e49) }, 
      { SC_(48.50565338134765625), SC_(16.792018890380859375), SC_(0.1562062777646958653353788960127206831866e48) }, 
      { SC_(48.50565338134765625), SC_(28.25031280517578125), SC_(73096522171156316264505015125427.87849809) }, 
      { SC_(48.50565338134765625), SC_(28.2665882110595703125), SC_(69247562231731518727938759809179.17837236) }, 
      { SC_(48.50565338134765625), SC_(32.353244781494140625), SC_(65540022292266205196135588.37445817652441) }, 
      { SC_(48.50565338134765625), SC_(41.1067352294921875), SC_(1507935444574.885075047791039699544486501) }, 
      { SC_(48.50565338134765625), SC_(42.080410003662109375), SC_(40466092507.45934103380971787300376014527) }, 
      { SC_(48.50565338134765625), SC_(45.4780120849609375), SC_(111689.257938935572585547796542841786287) }, 
      { SC_(48.50565338134765625), SC_(45.842041015625), SC_(27901.67051989409614876831141855717974302) }, 
      { SC_(48.50565338134765625), SC_(47.9603271484375), SC_(8.23202894097474578256346862985747732831) }, 
      { SC_(48.50565338134765625), SC_(48.314647674560546875), SC_(2.093980822113357920271431337630760310643) }, 
      { SC_(48.50565338134765625), SC_(48.4493560791015625), SC_(1.243478630467434834721499987219186699646) }, 
      { SC_(48.50565338134765625), SC_(48.50565338134765625), SC_(1) }, 
      { SC_(48.50565338134765625), SC_(49.65830230712890625), SC_(0.01137860668779746965294028255799791422986) }, 
      { SC_(48.50565338134765625), SC_(49.830142974853515625), SC_(0.005824684135375125377888394010247691105308) }, 
      { SC_(49.65830230712890625), SC_(6.68193912506103515625), SC_(0.4013312583375967416661578325917486444011e60) }, 
      { SC_(49.65830230712890625), SC_(8.095367431640625), SC_(0.2626622832214886218015717184826554078257e59) }, 
      { SC_(49.65830230712890625), SC_(8.50289630889892578125), SC_(0.113700472089290789897629737177398002534e59) }, 
      { SC_(49.65830230712890625), SC_(11.04233455657958984375), SC_(0.4004372427681186817057187355081811104948e56) }, 
      { SC_(49.65830230712890625), SC_(12.6096343994140625), SC_(0.8929011884004219495315315213522833289702e54) }, 
      { SC_(49.65830230712890625), SC_(15.36791515350341796875), SC_(0.6852337109098215178887399704270903577856e51) }, 
      { SC_(49.65830230712890625), SC_(16.792018890380859375), SC_(0.1372806724501805853779867836918351364192e50) }, 
      { SC_(49.65830230712890625), SC_(28.25031280517578125), SC_(6424031006322219535859735319895730.406516) }, 
      { SC_(49.65830230712890625), SC_(28.2665882110595703125), SC_(6085768155251669725746553272367876.464595) }, 
      { SC_(49.65830230712890625), SC_(32.353244781494140625), SC_(5759933890900014436468813901.114329886265) }, 
      { SC_(49.65830230712890625), SC_(41.1067352294921875), SC_(132523733876135.2881084287595872245597653) }, 
      { SC_(49.65830230712890625), SC_(42.080410003662109375), SC_(3556331070908.319456261711716187098696346) }, 
      { SC_(49.65830230712890625), SC_(45.4780120849609375), SC_(9815723.577009849317698980162780336496513) }, 
      { SC_(49.65830230712890625), SC_(45.842041015625), SC_(2452116.61545662911113776272285650291177) }, 
      { SC_(49.65830230712890625), SC_(47.9603271484375), SC_(723.4654617074386650606404106270002904964) }, 
      { SC_(49.65830230712890625), SC_(48.314647674560546875), SC_(184.0278761334604933216410145833973305409) }, 
      { SC_(49.65830230712890625), SC_(48.4493560791015625), SC_(109.2821524274104329582796424993272683682) }, 
      { SC_(49.65830230712890625), SC_(48.50565338134765625), SC_(87.88422233386534838722699682176254064215) }, 
      { SC_(49.65830230712890625), SC_(49.65830230712890625), SC_(1) }, 
      { SC_(49.65830230712890625), SC_(49.830142974853515625), SC_(0.5118978355778457700907478004290928982057) }, 
      { SC_(49.830142974853515625), SC_(6.68193912506103515625), SC_(0.7840065545199304670108533691898249387968e60) }, 
      { SC_(49.830142974853515625), SC_(8.095367431640625), SC_(0.5131146587580068328804320686790697457432e59) }, 
      { SC_(49.830142974853515625), SC_(8.50289630889892578125), SC_(0.2221155554622383892333093987944533873854e59) }, 
      { SC_(49.830142974853515625), SC_(11.04233455657958984375), SC_(0.782260081869838348283677686535832364175e56) }, 
      { SC_(49.830142974853515625), SC_(12.6096343994140625), SC_(0.1744295690159517988946627267959914710007e55) }, 
      { SC_(49.830142974853515625), SC_(15.36791515350341796875), SC_(0.1338614198546686499416667263462438494101e52) }, 
      { SC_(49.830142974853515625), SC_(16.792018890380859375), SC_(0.26817982595143034220545161257463255727e50) }, 
      { SC_(49.830142974853515625), SC_(28.25031280517578125), SC_(12549439672997599030300754159544767.03381) }, 
      { SC_(49.830142974853515625), SC_(28.2665882110595703125), SC_(11888638185746322677793115992561779.63174) }, 
      { SC_(49.830142974853515625), SC_(32.353244781494140625), SC_(11252116126644737085315595239.69631493006) }, 
      { SC_(49.830142974853515625), SC_(41.1067352294921875), SC_(258887076024727.6417888699288378265039062) }, 
      { SC_(49.830142974853515625), SC_(42.080410003662109375), SC_(6947345395383.094961087609307748110446687) }, 
      { SC_(49.830142974853515625), SC_(45.4780120849609375), SC_(19175161.3208709184277483875675091000146) }, 
      { SC_(49.830142974853515625), SC_(45.842041015625), SC_(4790246.109731262408906051742019966433475) }, 
      { SC_(49.830142974853515625), SC_(47.9603271484375), SC_(1413.300489717384632443829918755401512936) }, 
      { SC_(49.830142974853515625), SC_(48.314647674560546875), SC_(359.5011803980852094949309930259792159491) }, 
      { SC_(49.830142974853515625), SC_(48.4493560791015625), SC_(213.4843025934060293962890224642100962277) }, 
      { SC_(49.830142974853515625), SC_(48.50565338134765625), SC_(171.6831293780700953348759427887881234575) }, 
      { SC_(49.830142974853515625), SC_(49.65830230712890625), SC_(1.953514804123306623532978094346942918559) }, 
      { SC_(49.830142974853515625), SC_(49.830142974853515625), SC_(1) }
   } };
#undef SC_

