#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-
""":synopsis: Support for asynchronous command/response protocols.
"""
class async_chat:


	"""
	This class is an abstract subclass of :class:`asyncore.dispatcher`. To make
	practical use of the code you must subclass :class:`async_chat`, providing
	meaningful :meth:`collect_incoming_data` and :meth:`found_terminator`
	methods.
	The :class:`asyncore.dispatcher` methods can be used, although not all make
	sense in a message/response context.
	
	Like :class:`asyncore.dispatcher`, :class:`async_chat` defines a set of
	events that are generated by an analysis of socket conditions after a
	:cfunc:`select` call. Once the polling loop has been started the
	:class:`async_chat` object's methods are called by the event-processing
	framework with no action on the part of the programmer.
	
	Two class attributes can be modified, to improve performance, or possibly
	even to conserve memory.
	
	
	"""
	
	
	def __init__(self, ):
		pass
	
	def close_when_done(self, ):
		"""
		Pushes a ``None`` on to the producer fifo. When this producer is popped off
		the fifo it causes the channel to be closed.
		
		
		"""
		pass
		
	def collect_incoming_data(self, data):
		"""
		Called with *data* holding an arbitrary amount of received data.  The
		default method, which must be overridden, raises a
		:exc:`NotImplementedError` exception.
		
		
		"""
		pass
		
	def discard_buffers(self, ):
		"""
		In emergencies this method will discard any data held in the input and/or
		output buffers and the producer fifo.
		
		
		"""
		pass
		
	def found_terminator(self, ):
		"""
		Called when the incoming data stream  matches the termination condition set
		by :meth:`set_terminator`. The default method, which must be overridden,
		raises a :exc:`NotImplementedError` exception. The buffered input data
		should be available via an instance attribute.
		
		
		"""
		pass
		
	def get_terminator(self, ):
		"""
		Returns the current terminator for the channel.
		
		
		"""
		pass
		
	def push(self, data):
		"""
		Pushes data on to the channel's fifo to ensure its transmission.
		This is all you need to do to have the channel write the data out to the
		network, although it is possible to use your own producers in more complex
		schemes to implement encryption and chunking, for example.
		
		
		"""
		pass
		
	def push_with_producer(self, producer):
		"""
		Takes a producer object and adds it to the producer fifo associated with
		the channel.  When all currently-pushed producers have been exhausted the
		channel will consume this producer's data by calling its :meth:`more`
		method and send the data to the remote endpoint.
		
		
		"""
		pass
		
	def set_terminator(self, term):
		"""
		Sets the terminating condition to be recognized on the channel.  ``term``
		may be any of three types of value, corresponding to three different ways
		to handle incoming protocol data.
		
		+-----------+---------------------------------------------+
		| term      | Description                                 |
		+===========+=============================================+
		| *string*  | Will call :meth:`found_terminator` when the |
		|           | string is found in the input stream         |
		+-----------+---------------------------------------------+
		| *integer* | Will call :meth:`found_terminator` when the |
		|           | indicated number of characters have been    |
		|           | received                                    |
		+-----------+---------------------------------------------+
		| ``None``  | The channel continues to collect data       |
		|           | forever                                     |
		+-----------+---------------------------------------------+
		
		Note that any data following the terminator will be available for reading
		by the channel after :meth:`found_terminator` is called.
		
		
		asynchat - Auxiliary Classes
		------------------------------------------
		
		"""
		pass
		
	"""
	The asynchronous input buffer size (default ``4096``).
	
	
	"""
	ac_in_buffer_size = None
	"""
	The asynchronous output buffer size (default ``4096``).
	
	Unlike :class:`asyncore.dispatcher`, :class:`async_chat` allows you to
	define a first-in-first-out queue (fifo) of *producers*. A producer need
	have only one method, :meth:`more`, which should return data to be
	transmitted on the channel.
	The producer indicates exhaustion (*i.e.* that it contains no more data) by
	having its :meth:`more` method return the empty string. At this point the
	:class:`async_chat` object removes the producer from the fifo and starts
	using the next producer, if any. When the producer fifo is empty the
	:meth:`handle_write` method does nothing. You use the channel object's
	:meth:`set_terminator` method to describe how to recognize the end of, or
	an important breakpoint in, an incoming transmission from the remote
	endpoint.
	
	To build a functioning :class:`async_chat` subclass your  input methods
	:meth:`collect_incoming_data` and :meth:`found_terminator` must handle the
	data that the channel receives asynchronously. The methods are described
	below.
	
	
	"""
	ac_out_buffer_size = None
	


class fifo:


	"""
	A :class:`fifo` holding data which has been pushed by the application but
	not yet popped for writing to the channel.  A :class:`fifo` is a list used
	to hold data and/or producers until they are required.  If the *list*
	argument is provided then it should contain producers or data items to be
	written to the channel.
	
	
	"""
	
	
	def __init__(self, ):
		pass
	
	def is_empty(self, ):
		"""
		Returns ``True`` if and only if the fifo is empty.
		
		
		"""
		pass
		
	def first(self, ):
		"""
		Returns the least-recently :meth:`push`\ ed item from the fifo.
		
		
		"""
		pass
		
	def push(self, data):
		"""
		Adds the given data (which may be a string or a producer object) to the
		producer fifo.
		
		
		"""
		pass
		
	def pop(self, ):
		"""
		If the fifo is not empty, returns ``True, first()``, deleting the popped
		item.  Returns ``False, None`` for an empty fifo.
		
		
		.. synchat Example
		"""
		pass
		
	


