package app;

import org.gnu.gdk.Pixbuf;
import org.gnu.gnome.About;
import org.gnu.gnome.App;
import org.gnu.gnome.AppBar;
import org.gnu.gnome.GnomeStockItem;
import org.gnu.gnome.PreferencesType;
import org.gnu.gnome.Program;
import org.gnu.gnome.UIInfo;
import org.gnu.gtk.Button;
import org.gnu.gtk.ButtonBox;
import org.gnu.gtk.Frame;
import org.gnu.gtk.Gtk;
import org.gnu.gtk.HBox;
import org.gnu.gtk.HButtonBox;
import org.gnu.gtk.ShadowType;
import org.gnu.gtk.event.ButtonEvent;
import org.gnu.gtk.event.ButtonListener;
import org.gnu.gtk.event.LifeCycleEvent;
import org.gnu.gtk.event.LifeCycleListener;
import org.gnu.gtk.event.MenuItemEvent;
import org.gnu.gtk.event.MenuItemListener;

public class AppExample implements MenuItemListener, ButtonListener {

	private App app;
	private AppBar appbar;

	public AppExample() {

		app = new App("appexample", "App Example");
		app.addListener(new LifeCycleListener() {
			public void lifeCycleEvent(LifeCycleEvent event) {}
			public boolean lifeCycleQuery(LifeCycleEvent event) {
				if (event.isOfType(LifeCycleEvent.Type.DELETE) || event.isOfType(LifeCycleEvent.Type.DESTROY))
					Gtk.mainQuit();
				return false;
			}
		});

		// Create and add the AppBar
		appbar = new AppBar(true, true, PreferencesType.ALWAYS);
		app.setStatusBar(appbar);

		// Create and add the Menu
		UIInfo[] menuInfo = buildMyMenus();
		app.createMenus(menuInfo);
		//app.installMenuHints(menuInfo);
		
		// create the ToolBar
		app.createToolBar(buildMyToolbar());

		// create the main window area
		app.setContent(buildMainView());
		
		app.showAll();
	}

	// build the menus for this app.
	private UIInfo[] buildMyMenus() {

		UIInfo fileMenu[] = {
			UIInfo.newItem("New Window", "Open a new application window", (MenuItemListener)this),
			UIInfo.separator(),
			UIInfo.openItem((MenuItemListener)this),
			UIInfo.saveItem((MenuItemListener)this),
			UIInfo.saveAsItem((MenuItemListener)this),
			UIInfo.revertItem((MenuItemListener)this),
			UIInfo.printItem((MenuItemListener)this),
			UIInfo.printSetupItem((MenuItemListener)this),
			UIInfo.separator(),
			UIInfo.closeItem((MenuItemListener)this),
			UIInfo.quitItem((MenuItemListener)this),
			UIInfo.end()
		};

		UIInfo editMenu[] = {
			UIInfo.undoItem((MenuItemListener)this),
			UIInfo.redoItem((MenuItemListener)this),
			UIInfo.separator(),
			UIInfo.cutItem((MenuItemListener)this),
			UIInfo.copyItem((MenuItemListener)this),
			UIInfo.pasteItem((MenuItemListener)this),
			UIInfo.clearItem((MenuItemListener)this),
			UIInfo.selectAllItem((MenuItemListener)this),
			UIInfo.separator(),
			UIInfo.findItem((MenuItemListener)this),
			UIInfo.findAgainItem((MenuItemListener)this),
			UIInfo.replaceItem((MenuItemListener)this),
			UIInfo.propertiesItem((MenuItemListener)this),
			UIInfo.end()
		};

		UIInfo helpMenu[] = {
			UIInfo.aboutItem(new MenuItemListener() {
				public void menuItemEvent(MenuItemEvent event) {
					helpAbout();
				}
			}),
			UIInfo.end()
		};

		UIInfo mainMenu[] = {
			UIInfo.subtree("_File", fileMenu),
			UIInfo.subtree("_Edit", editMenu),
			UIInfo.subtree("_Help", helpMenu),
			UIInfo.end()
		};

		return mainMenu;
	}

	private UIInfo[] buildMyToolbar() {
		UIInfo toolbar[] = {
			UIInfo.itemStock("Cut", "Cut", (ButtonListener)this, GnomeStockItem.CUT),
			UIInfo.itemStock("Copy", "Copy", (ButtonListener)this, GnomeStockItem.COPY),
			UIInfo.itemStock("Paste", "Paste", (ButtonListener)this, GnomeStockItem.PASTE),
			UIInfo.separator(),
			UIInfo.itemStock("Clear", "Clear", (ButtonListener)this, GnomeStockItem.CLEAR),
			UIInfo.separator(),
			UIInfo.itemStock("Quit", "Quit", (ButtonListener)this, GnomeStockItem.QUIT),
			UIInfo.end()
		};

		return toolbar;
	}
	
	private HBox buildMainView() {
		HBox main = new HBox(false, 10);
		
		Frame frame = new Frame("Popups");
		frame.setBorderWidth(10);
		frame.setShadow(ShadowType.ETCHED_IN);
		main.packStart(frame);
		
		ButtonBox bbox = new HButtonBox();
		// Add the message button
		Button button = new Button("_Message", true);
		button.addListener(new ButtonListener () {
			public void buttonEvent(ButtonEvent event) {
				if (event.isOfType(ButtonEvent.Type.CLICK))
					app.message("This is a message");
			}
		});
		bbox.add(button);
		// Add the warning button
		button = new Button("_Warning", true);
		button.addListener(new ButtonListener () {
			public void buttonEvent(ButtonEvent event) {
				if (event.isOfType(ButtonEvent.Type.CLICK))
					app.warning("This is a warning");
			}
		});
		bbox.add(button);
		// Add the error button
		button = new Button("_Error", true);
		button.addListener(new ButtonListener () {
			public void buttonEvent(ButtonEvent event) {
				if (event.isOfType(ButtonEvent.Type.CLICK))
					app.error("This is a error");
			}
		});
		bbox.add(button);
		// Add the flase button
		button = new Button("_Flash", true);
		button.addListener(new ButtonListener () {
			public void buttonEvent(ButtonEvent event) {
				if (event.isOfType(ButtonEvent.Type.CLICK))
					app.flash("This is a flash");
			}
		});
		bbox.add(button);

		frame.add(bbox);
		
		return main;
	}

	// Callback for the menu events
	public void menuItemEvent(MenuItemEvent event) {
		app.message("menu callback");
	}
	
	public void buttonEvent(ButtonEvent event) {
		app.message("button callback");
	}

	// Callback for the help->about menu
	public void helpAbout() {
		String title = "My about";
		String version = "Version 0.0.0";
		String license = "GPL";
		String comments = "My comments go here";
		String[] authors = { "Me", "Myself", "I" };
		String[] documenters = { "Me", "Myself", "I" };
		String translator = "Porkey";
		About about = new About(title, version, license, comments, authors, documenters, translator, (Pixbuf) null);
		about.show();
	}

	public static void main(String[] args) {

		Program prog = Program.initGnomeUI("AppExample", "1.0", args);

		AppExample abar = new AppExample();

		Gtk.main();
	}
}
