/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;
import org.gnu.glib.Handle;

/**
 *
 */
public class TearoffMenuItem extends MenuItem 
{
	/**
	 * Construct a new TearoffMenuItem
	 */
	public TearoffMenuItem() {
		super(gtk_tearoff_menu_item_new());
	}
	
	/**
	 * Construct a TearoffMenuItem using a handle to a native resource.
	 */
	public TearoffMenuItem(Handle handle) {
	    super(handle);
	}

    /**
     * Internal static factory method to be used by Java-Gnome only.
     */
    public static TearoffMenuItem getTearOffMenuItem(Handle handle) {
        if (handle == null)
            return null;
        
        TearoffMenuItem obj = (TearoffMenuItem) getGObjectFromHandle(handle);
        if (obj == null)
            obj = new TearoffMenuItem(handle);
        
        return obj;
    }
    
	public boolean getTornOff() {
		return getTornOff(getHandle());
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_tearoff_menu_item_get_type());
	}

    native static final protected int gtk_tearoff_menu_item_get_type ();
    native static final protected Handle gtk_tearoff_menu_item_new ();
    native static final protected boolean getTornOff(Handle menu);
}

