/*  This file is part of FreeDoko.
    FreeDoko is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version (see <http://www.gnu.org/licenses/>).

    Diese Datei ist Teil von FreeDoko.
    FreeDoko ist Freie Software: Sie können es unter den Bedingungen der GNU General Public License, wie von der Free Software Foundation, Version 3 der Lizenz oder (nach Ihrer Wahl) jeder neueren veröffentlichten Version, weiter verteilen und/oder modifizieren (siehe <https://www.gnu.org/licenses/>).
    */

#include "constants.h"

#include "base_player.h"

#include "../../player/player.h"
#include "../../utils/string.h"

namespace GameplayActions {

template<Type type>
BasePlayer<type>::BasePlayer(unsigned const player) :
  Base<type>(),
  player(player)
{ }

template<Type type>
BasePlayer<type>::BasePlayer(Player const& player) :
  BasePlayer(player.no())
{ }

template<Type type>
BasePlayer<type>::BasePlayer(string const& line) :
  Base<type>()
{
  // ex: swines = 0
  string const pre = to_string(this->type()) + " =";
  if (string(line, 0, pre.length()) != pre)
    return ;

  istringstream istr(string(line, pre.length()));
  istr >> this->player;
}

template<Type type>
auto BasePlayer<type>::equal(GameplayAction const& action) const -> bool
{
  return (   this->Base<type>::equal(action)
	  && (this->player == static_cast<BasePlayer<type> const&>(action).player));
}

template<Type type>
void BasePlayer<type>::write(ostream& ostr) const
{
  ostr << this->type();
  ostr << " = " << this->player;
}

template<Type type>
auto BasePlayer<type>::data_translation() const -> string
{
  return {};
}

} // namespace GameplayActions
