/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.PluginsCollector;
import org.java.plugin.util.ExtendedProperties;
import org.java.plugin.util.IoUtil;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultPluginsCollector
implements PluginsCollector {
    protected static final String PARAM_PLUGINS_REPOSITORIES = "org.java.plugin.boot.pluginsRepositories";
    protected static final String PARAM_PLUGINS_LOCATIONS_DESCRIPTORS = "org.java.plugin.boot.pluginsLocationsDescriptors";
    protected Log log = LogFactory.getLog(this.getClass());
    private List repositories;
    private List descriptors;

    public void configure(ExtendedProperties extendedProperties) throws Exception {
        String string;
        this.repositories = new LinkedList();
        StringTokenizer stringTokenizer = new StringTokenizer(extendedProperties.getProperty(PARAM_PLUGINS_REPOSITORIES, '.' + File.separator + "plugins"), ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken().trim();
            if (string.length() == 0) continue;
            this.repositories.add(new File(string).getCanonicalFile());
        }
        this.log.debug((Object)("found " + this.repositories.size() + " local plug-ins repositories"));
        this.descriptors = new LinkedList();
        stringTokenizer = new StringTokenizer(extendedProperties.getProperty(PARAM_PLUGINS_LOCATIONS_DESCRIPTORS, ""), ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken().trim();
            if (string.length() == 0) continue;
            this.descriptors.add(new URL(string));
        }
        this.log.debug((Object)("found " + this.descriptors.size() + " plug-ins locations descriptors"));
    }

    public Collection collectPluginLocations() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.repositories.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (file.isDirectory()) {
                this.processFolder(file, linkedList);
                continue;
            }
            if (!file.isFile()) continue;
            this.processFile(file, linkedList);
        }
        iterator = this.descriptors.iterator();
        while (iterator.hasNext()) {
            this.processDescriptor((URL)iterator.next(), linkedList);
        }
        return linkedList;
    }

    protected void processFolder(File file, List list) {
        this.log.debug((Object)("processing folder - " + file));
        URL uRL = this.getManifestUrl(file);
        if (uRL != null) {
            try {
                URL uRL2 = IoUtil.file2url(file);
                list.add(new PluginLocationImpl(uRL, uRL2));
            }
            catch (MalformedURLException malformedURLException) {
                this.log.warn((Object)("failed collecting plug-in folder " + file + ", ignoring it"), (Throwable)malformedURLException);
            }
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                this.processFolder(file2, list);
                continue;
            }
            if (!file2.isFile()) continue;
            this.processFile(file2, list);
        }
    }

    protected void processFile(File file, List list) {
        this.log.debug((Object)("processing file - " + file));
        String string = file.getName().toLowerCase(Locale.getDefault());
        if (!string.endsWith(".jar") && !string.endsWith(".zip")) {
            return;
        }
        URL uRL = this.getManifestUrl(file);
        if (uRL == null) {
            return;
        }
        try {
            URL uRL2 = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/");
            list.add(new PluginLocationImpl(uRL, uRL2));
        }
        catch (MalformedURLException malformedURLException) {
            this.log.warn((Object)("failed collecting plug-in file " + file + ", ignoring it"), (Throwable)malformedURLException);
        }
    }

    protected URL getManifestUrl(File file) {
        try {
            if (file.isDirectory()) {
                File file2 = new File(file, "plugin.xml");
                if (file2.isFile()) {
                    return IoUtil.file2url(file2);
                }
                file2 = new File(file, "plugin-fragment.xml");
                if (file2.isFile()) {
                    return IoUtil.file2url(file2);
                }
                return null;
            }
            if (!file.isFile()) {
                return null;
            }
            URL uRL = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/plugin.xml");
            if (IoUtil.isResourceExists(uRL)) {
                return uRL;
            }
            uRL = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/plugin-fragment.xml");
            if (IoUtil.isResourceExists(uRL)) {
                return uRL;
            }
            uRL = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/META-INF/plugin.xml");
            if (IoUtil.isResourceExists(uRL)) {
                return uRL;
            }
            uRL = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/META-INF/plugin-fragment.xml");
            if (IoUtil.isResourceExists(uRL)) {
                return uRL;
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.log.warn((Object)("failed extracting manifest from file " + file), (Throwable)malformedURLException);
        }
        return null;
    }

    private void processDescriptor(URL uRL, List list) {
        this.log.debug((Object)("processing plug-ins locations descriptor, URL=" + uRL));
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(uRL.toExternalForm(), (DefaultHandler)new LocationsDescriptorHandler(list));
        }
        catch (Exception exception) {
            this.log.warn((Object)("failed processing plug-ins locations descriptor, URL=" + uRL), (Throwable)exception);
        }
    }

    private static final class PluginLocationImpl
    implements PluginManager.PluginLocation {
        private final URL manifestLocation;
        private final URL contextLocation;

        protected PluginLocationImpl(URL uRL, URL uRL2) {
            this.manifestLocation = uRL;
            this.contextLocation = uRL2;
        }

        public URL getManifestLocation() {
            return this.manifestLocation;
        }

        public URL getContextLocation() {
            return this.contextLocation;
        }
    }

    private final class LocationsDescriptorHandler
    extends DefaultHandler {
        private final List resultData;

        LocationsDescriptorHandler(List list) {
            this.resultData = list;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            URL uRL;
            URL uRL2;
            if (!"plugin".equals(string3)) {
                return;
            }
            String string4 = attributes.getValue("manifest");
            if (string4 == null) {
                DefaultPluginsCollector.this.log.warn((Object)"manifest attribute missing");
                return;
            }
            try {
                uRL2 = new URL(string4);
            }
            catch (MalformedURLException malformedURLException) {
                DefaultPluginsCollector.this.log.warn((Object)("invalid manifest URL - " + string4), (Throwable)malformedURLException);
                return;
            }
            String string5 = attributes.getValue("context");
            if (string5 == null) {
                DefaultPluginsCollector.this.log.warn((Object)"context attribute missing");
                return;
            }
            try {
                uRL = new URL(string5);
            }
            catch (MalformedURLException malformedURLException) {
                DefaultPluginsCollector.this.log.warn((Object)("invalid context URL - " + string5), (Throwable)malformedURLException);
                return;
            }
            this.resultData.add(new PluginLocationImpl(uRL2, uRL));
            DefaultPluginsCollector.this.log.debug((Object)("got plug-in location from descriptor, manifestUrl=" + uRL2 + ", contextURL=" + uRL));
        }
    }
}

