/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.StringTokenizer;

public final class Version
implements Serializable,
Comparable {
    private static final long serialVersionUID = -3054349171116917643L;
    public static final char SEPARATOR = '.';
    private transient int major;
    private transient int minor;
    private transient int build;
    private transient String name;
    private transient String asString;

    public static Version parse(String string) {
        Version version = new Version();
        version.parseString(string);
        return version;
    }

    private Version() {
    }

    private void parseString(String string) {
        this.major = 0;
        this.minor = 0;
        this.build = 0;
        this.name = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        String string2 = stringTokenizer.nextToken();
        try {
            this.major = Integer.parseInt(string2, 10);
        }
        catch (NumberFormatException numberFormatException) {
            this.name = string2;
            while (stringTokenizer.hasMoreTokens()) {
                this.name = this.name + stringTokenizer.nextToken();
            }
            return;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        string2 = stringTokenizer.nextToken();
        try {
            this.minor = Integer.parseInt(string2, 10);
        }
        catch (NumberFormatException numberFormatException) {
            this.name = string2;
            while (stringTokenizer.hasMoreTokens()) {
                this.name = this.name + stringTokenizer.nextToken();
            }
            return;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        string2 = stringTokenizer.nextToken();
        try {
            this.build = Integer.parseInt(string2, 10);
        }
        catch (NumberFormatException numberFormatException) {
            this.name = string2;
            while (stringTokenizer.hasMoreTokens()) {
                this.name = this.name + stringTokenizer.nextToken();
            }
            return;
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.name = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                this.name = this.name + stringTokenizer.nextToken();
            }
        }
    }

    public Version(int n, int n2, int n3, String string) {
        this.major = n;
        this.minor = n2;
        this.build = n3;
        this.name = string == null ? "" : string;
    }

    public int getBuild() {
        return this.build;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getName() {
        return this.name;
    }

    public boolean isGreaterOrEqualTo(Version version) {
        if (version == null) {
            return false;
        }
        if (this.major > version.major) {
            return true;
        }
        if (this.major == version.major && this.minor > version.minor) {
            return true;
        }
        if (this.major == version.major && this.minor == version.minor && this.build > version.build) {
            return true;
        }
        return this.major == version.major && this.minor == version.minor && this.build == version.build && this.name.equalsIgnoreCase(version.name);
    }

    public boolean isCompatibleWith(Version version) {
        if (version == null) {
            return false;
        }
        if (this.major != version.major) {
            return false;
        }
        if (this.minor > version.minor) {
            return true;
        }
        if (this.minor < version.minor) {
            return false;
        }
        return this.build >= version.build;
    }

    public boolean isEquivalentTo(Version version) {
        if (version == null) {
            return false;
        }
        if (this.major != version.major) {
            return false;
        }
        if (this.minor != version.minor) {
            return false;
        }
        return this.build >= version.build;
    }

    public boolean isGreaterThan(Version version) {
        if (version == null) {
            return false;
        }
        if (this.major > version.major) {
            return true;
        }
        if (this.major < version.major) {
            return false;
        }
        if (this.minor > version.minor) {
            return true;
        }
        if (this.minor < version.minor) {
            return false;
        }
        return this.build > version.build;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        return this.major == version.major && this.minor == version.minor && this.build == version.build && this.name.equalsIgnoreCase(version.name);
    }

    public String toString() {
        if (this.asString == null) {
            this.asString = "" + this.major + '.' + this.minor + '.' + this.build + (this.name.length() == 0 ? "" : '.' + this.name);
        }
        return this.asString;
    }

    public int compareTo(Object object) {
        if (this.equals(object)) {
            return 0;
        }
        if (!(object instanceof Version)) {
            throw new ClassCastException();
        }
        Version version = (Version)object;
        if (this.major != version.major) {
            return this.major - version.major;
        }
        if (this.minor != version.minor) {
            return this.minor - version.minor;
        }
        if (this.build != version.build) {
            return this.build - version.build;
        }
        return this.name.toLowerCase(Locale.ENGLISH).compareTo(version.name.toLowerCase(Locale.ENGLISH));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.parseString(objectInputStream.readUTF());
    }
}

