/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.gnupg;

import com.freiheit.gnupg.GnuPGContext;
import com.freiheit.gnupg.GnuPGData;
import com.freiheit.gnupg.GnuPGKey;
import com.freiheit.gnupg.GnuPGPassphraseWindow;
import com.freiheit.gnupg.GnuPGSignature;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class GnuPGTestSuite
extends TestCase {
    private static String PLAINTEXT = "I am a not so secret text.";
    private static String CD_FPR = "1C12878CFAA2ECDC81DC43DB12262834A6123FF6";
    private static String SR_FPR = "F05F385DFA40962D0075AB9C2B80170D";

    public static Test suite() {
        TestSuite suite = new TestSuite(GnuPGTestSuite.class);
        return suite;
    }

    public void testEngine() {
        GnuPGContext ctx = new GnuPGContext();
        ctx.getVersion();
        ctx.getFilename();
        ctx.getRequiredVersion();
    }

    public void testContextSetterAndGetter() {
        GnuPGContext ctx = new GnuPGContext();
        GnuPGTestSuite.assertTrue((boolean)ctx.isArmor());
        ctx.setArmor(false);
        GnuPGTestSuite.assertFalse((boolean)ctx.isArmor());
        ctx.setArmor(true);
        GnuPGTestSuite.assertTrue((boolean)ctx.isArmor());
        GnuPGTestSuite.assertTrue((boolean)ctx.isTextmode());
        ctx.setTextmode(false);
        GnuPGTestSuite.assertFalse((boolean)ctx.isTextmode());
        ctx.setTextmode(true);
        GnuPGTestSuite.assertTrue((boolean)ctx.isTextmode());
    }

    public void testKeySearch() {
        GnuPGContext ctx = new GnuPGContext();
        GnuPGKey[] keys = ctx.searchKeys("stefan");
        GnuPGTestSuite.assertNotNull((Object)keys);
        for (int i = 0; keys != null && i < keys.length; ++i) {
            GnuPGTestSuite.assertNotNull((Object)keys[i]);
            Iterator iter = keys[i].getSignatures();
            System.out.println(keys[i]);
            while (iter.hasNext()) {
                GnuPGTestSuite.assertNotNull((Object)((GnuPGSignature)iter.next()));
            }
        }
    }

    public void testEncryptForOneRecipient() {
        GnuPGContext ctx = new GnuPGContext();
        ctx.setPassphraseListener(new GnuPGPassphraseWindow());
        GnuPGData plain = ctx.createDataObject(PLAINTEXT);
        GnuPGData cipher = ctx.createDataObject();
        GnuPGKey[] recipient = ctx.generateEmptyKeyArray(1);
        recipient[0] = ctx.getKeyByFingerprint(SR_FPR);
        ctx.encrypt(recipient, plain, cipher);
        GnuPGTestSuite.assertNotNull((Object)cipher.toString());
    }

    public void testEncryptForTwoRecipients() {
        GnuPGContext ctx = new GnuPGContext();
        ctx.setPassphraseListener(new GnuPGPassphraseWindow());
        GnuPGData plain = ctx.createDataObject(PLAINTEXT);
        GnuPGData cipher = ctx.createDataObject();
        GnuPGKey[] recipients = ctx.generateEmptyKeyArray(2);
        recipients[0] = ctx.getKeyByFingerprint(SR_FPR);
        recipients[1] = ctx.getKeyByFingerprint(CD_FPR);
        ctx.encrypt(recipients, plain, cipher);
        GnuPGTestSuite.assertNotNull((Object)cipher.toString());
    }

    public void testDecryptFromOneRecipient() {
        GnuPGContext ctx = new GnuPGContext();
        ctx.setPassphraseListener(new GnuPGPassphraseWindow());
        GnuPGData plain = ctx.createDataObject(PLAINTEXT);
        GnuPGData cipher = ctx.createDataObject();
        GnuPGData decrypted = ctx.createDataObject();
        GnuPGKey[] recipient = ctx.generateEmptyKeyArray(1);
        recipient[0] = ctx.getKeyByFingerprint(SR_FPR);
        ctx.encrypt(recipient, plain, cipher);
        ctx.decrypt(cipher, decrypted);
        GnuPGTestSuite.assertNotNull((Object)decrypted.toString());
        GnuPGTestSuite.assertEquals((String)decrypted.toString(), (String)PLAINTEXT);
    }

    public void testAddAndClearSigners() {
        GnuPGContext ctx = new GnuPGContext();
        GnuPGKey signer1 = ctx.getKeyByFingerprint(SR_FPR);
        GnuPGKey signer2 = ctx.getKeyByFingerprint(CD_FPR);
        ctx.addSigner(signer1);
        ctx.addSigner(signer2);
        ctx.clearSigners();
    }

    public void testSign() {
        GnuPGContext ctx = new GnuPGContext();
        ctx.setPassphraseListener(new GnuPGPassphraseWindow());
        GnuPGData plain = ctx.createDataObject(PLAINTEXT);
        GnuPGData signature = ctx.createDataObject();
        GnuPGKey signer = ctx.getKeyByFingerprint(SR_FPR);
        ctx.addSigner(signer);
        ctx.sign(plain, signature);
        GnuPGTestSuite.assertNotNull((Object)signature.toString());
    }
}

