/* eclean-kernel2
 * (c) 2017 Michał Górny
 * 2-clause BSD license
 */

#pragma once

#ifndef EK2_BOOTLOADERS_GRUB2_H
#define EK2_BOOTLOADERS_GRUB2_H 1

#include "ek2/bootloader.h"
#include "ek2/util/directorystream.h"
#include "ek2/util/relativepath.h"

#include <memory>

class GRUB2 : public BootLoader
{
	std::shared_ptr<DirectoryStream> grub_dir_;
	std::unique_ptr<RelativePath> grub_cfg_;

	bool is_autogenerated_;
	bool is_multislot_;

	bool is_installed() const;
	void process_config();

public:
	GRUB2(const Options& opts);
	static std::unique_ptr<BootLoader> construct(const Options& opts);

	virtual void postrm();
};

#endif /*EK2_BOOTLOADERS_GRUB2_H*/
