/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.widgets;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.tm4e.core.internal.utils.StringUtils;

public final class ColumnViewerComparator
extends ViewerComparator {
    private int[] sortColumns = new int[1];
    private int sortOrder = 1;

    public int getDirection() {
        return this.sortOrder == 1 ? 1024 : 128;
    }

    public void setDirection(int value) {
        this.sortOrder = value == 1024 ? 1 : -1;
    }

    public void setColumnsOrDirection(int primaryColumn, int ... secondaryColumns) {
        this.sortOrder = primaryColumn == this.sortColumns[0] ? (this.sortOrder *= -1) : 1;
        this.setColumns(primaryColumn, secondaryColumns);
    }

    public void setColumns(int primaryColumn, int ... secondaryColumns) {
        if (secondaryColumns.length == 0) {
            this.sortColumns = new int[]{primaryColumn};
        } else {
            this.sortColumns = new int[secondaryColumns.length + 1];
            System.arraycopy(secondaryColumns, 0, this.sortColumns, 1, secondaryColumns.length);
            this.sortColumns[0] = primaryColumn;
        }
    }

    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
        TableViewer tableViewer;
        IBaseLabelProvider iBaseLabelProvider;
        if (viewer instanceof TableViewer && (iBaseLabelProvider = (tableViewer = (TableViewer)viewer).getLabelProvider()) instanceof ITableLabelProvider) {
            ITableLabelProvider labelProvider = (ITableLabelProvider)iBaseLabelProvider;
            int[] nArray = this.sortColumns;
            int n = this.sortColumns.length;
            int n2 = 0;
            while (n2 < n) {
                int column = nArray[n2];
                String left = StringUtils.nullToEmpty((String)labelProvider.getColumnText(e1, column));
                String right = StringUtils.nullToEmpty((String)labelProvider.getColumnText(e2, column));
                if (!left.isEmpty() || !right.isEmpty()) {
                    if (left.isEmpty()) {
                        return 1 * this.sortOrder;
                    }
                    if (right.isEmpty()) {
                        return -1 * this.sortOrder;
                    }
                    int sortResult = this.getComparator().compare(left, right);
                    if (sortResult != 0) {
                        return sortResult * this.sortOrder;
                    }
                }
                ++n2;
            }
            return 0;
        }
        return super.compare(viewer, e1, e2);
    }
}

