/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.jsf.facesconfig.common.logging.Logger;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.wizard.ISummaryDataSource;
import org.eclipse.jst.jsf.facesconfig.ui.wizard.ManagedBeanClassSelectionPage;
import org.eclipse.jst.jsf.facesconfig.ui.wizard.ManagedBeanPropertyPage;
import org.eclipse.jst.jsf.facesconfig.ui.wizard.NewJavaClassPage;
import org.eclipse.jst.jsf.facesconfig.ui.wizard.SummaryPage;
import org.eclipse.jst.jsf.facesconfig.ui.wizard.WizardsResourcesNLS;

public class NewManagedBeanWizard
extends Wizard
implements ISummaryDataSource {
    private static final Logger log;
    private ManagedBeanClassSelectionPage managedBeanClassSelectionPage;
    private NewJavaClassPage newJavaClassPage;
    private ManagedBeanPropertyPage managedBeanPropertyPage;
    public String managedBeanName;
    public String managedBeanScope;
    public String managedBeanClass;
    public String managedBeanDescription;
    private IProject project;
    private String suggestedBeanName;
    private String defaultScope;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsf.facesconfig.ui.wizard.NewManagedBeanWizard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = EditorPlugin.getLogger(clazz);
    }

    public NewManagedBeanWizard(IProject project) {
        this.setWindowTitle(WizardsResourcesNLS.NewManagedBeanWizardBase_Title);
        this.project = project;
    }

    public void addPages() {
        this.setDialogSettings(EditorPlugin.getDefault().getDialogSettings());
        this.managedBeanClassSelectionPage = new ManagedBeanClassSelectionPage(this.project);
        this.addPage((IWizardPage)this.managedBeanClassSelectionPage);
        this.newJavaClassPage = new NewJavaClassPage(this.project);
        this.addPage((IWizardPage)this.newJavaClassPage);
        this.managedBeanPropertyPage = new ManagedBeanPropertyPage(this.defaultScope, this.project);
        this.addPage((IWizardPage)this.managedBeanPropertyPage);
        SummaryPage summaryPage = new SummaryPage(this);
        this.addPage((IWizardPage)summaryPage);
        summaryPage.setDescription(WizardsResourcesNLS.NewJavaManagedBeanWizard_SummaryPage_Description);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (page instanceof ManagedBeanClassSelectionPage && !((ManagedBeanClassSelectionPage)page).isCreateNewJavaClass()) {
            ((WizardPage)nextPage).setPageComplete(true);
            return this.getNextPage(nextPage);
        }
        return nextPage;
    }

    public boolean performFinish() {
        this.managedBeanName = this.managedBeanPropertyPage.getManagedBeanName();
        this.managedBeanClass = this.managedBeanPropertyPage.getManagedBeanClass();
        this.managedBeanScope = this.managedBeanPropertyPage.getManagedBeanScope();
        this.managedBeanDescription = this.managedBeanPropertyPage.getManagedBeanDescription();
        if (this.managedBeanClassSelectionPage.isCreateNewJavaClass()) {
            this.createNewJavaClass();
        }
        return true;
    }

    private void createNewJavaClass() {
        try {
            this.newJavaClassPage.createType((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            log.info("NewJavaManagedBeanWizard.Error.CreateType", (Throwable)e);
            EditorPlugin.getAlerts().error("NewJavaManagedBeanWizard.Alert.CreateType.Title", "NewJavaManagedBeanWizard.Alert.CreateType.Description");
            return;
        }
        catch (InterruptedException e) {
            log.info("NewJavaManagedBeanWizard.Error.CreateType", (Throwable)e);
            EditorPlugin.getAlerts().error("NewJavaManagedBeanWizard.Alert.CreateType.Title", "NewJavaManagedBeanWizard.Alert.CreateType.Description");
            return;
        }
        this.newJavaClassPage.getCreatedType();
    }

    public String getSuggestedBeanName() {
        return this.suggestedBeanName;
    }

    public void setSuggestedBeanName(String suggestedBeanName) {
        this.suggestedBeanName = suggestedBeanName;
    }

    public String getDefaultScope() {
        return this.defaultScope;
    }

    public void setDefaultScope(String defaultScope) {
        this.defaultScope = defaultScope;
    }

    public String getManagedBeanClass() {
        return this.managedBeanClass;
    }

    public String getManagedBeanDescription() {
        return this.managedBeanDescription;
    }

    public String getManagedBeanName() {
        return this.managedBeanName;
    }

    public String getManagedBeanScope() {
        return this.managedBeanScope;
    }

    public List getSummaryData() {
        ArrayList data = new ArrayList();
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            if (pages[i] instanceof ISummaryDataSource) {
                data.addAll(((ISummaryDataSource)pages[i]).getSummaryData());
            }
            ++i;
        }
        return data;
    }
}

