/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.preference.ColorFontFieldEditor;
import org.eclipse.jst.jsf.facesconfig.ui.preference.ComboFieldEditor;
import org.eclipse.jst.jsf.facesconfig.ui.preference.CompoundNodeFigure;
import org.eclipse.jst.jsf.facesconfig.ui.preference.IconFigure;
import org.eclipse.jst.jsf.facesconfig.ui.preference.InputPortFigure;
import org.eclipse.jst.jsf.facesconfig.ui.preference.LinkFigure;
import org.eclipse.jst.jsf.facesconfig.ui.preference.OutputPortFigure;
import org.eclipse.jst.jsf.facesconfig.ui.preference.WindowFigure;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GEMPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String USE_SYSTEM_COLORS = "UseSystemColors";
    public static final String CANVAS_COLOR = "CanvasColor";
    public static final String FIGURE_LABEL_FONT = "FigureLabelFont";
    public static final String FIGURE_LABEL_FONT_COLOR = "FigureLabelFontColor";
    public static final String LABEL_PLACEMENT = "LabelPlacement";
    public static final String INPUT_PORT_COLOR = "InputPortColor";
    public static final String OUTPUT_PORT_COLOR = "OutputPortColor";
    public static final String SHOW_LINE_LABELS = "ShowLineLabels";
    public static final String LINE_LABEL_FONT = "LineLabelFont";
    public static final String LINE_LABEL_FONT_COLOR = "LineLabelFontColor";
    public static final String LINE_LABEL_COLOR = "LineLabelColor";
    public static final String LINE_WIDTH = "LineWidth";
    public static final String LINE_COLOR = "LineColor";
    public static final String LINE_ROUTING = "LineRouting";
    public static final String SNAP_TO_GRID = "SnapToGrid";
    public static final String SNAP_TO_GEOMETRY = "SnapToGeometry";
    public static final String GRID_WIDTH = "GridWidth";
    public static final String GRID_HEIGHT = "GridHeight";
    public static final String GRID_COLOR = "GridColor";
    public static final String LABEL_PLACEMENT_TOP = "Top";
    public static final String LABEL_PLACEMENT_BOTTOM = "Bottom";
    public static final String LABEL_PLACEMENT_LEFT = "Left";
    public static final String LABEL_PLACEMENT_RIGHT = "Right";
    public static final String LINE_ROUTING_MANHATTAN = "Manhattan";
    public static final String LINE_ROUTING_MANUAL = "Manaul";
    private static final String[][] m_lineRoutingLabels = new String[][]{{EditorPlugin.getResourceString("CanvasPreferences.LABEL.Manual"), "Manaul"}, {EditorPlugin.getResourceString("CanvasPreferences.LABEL.Manhattan"), "Manhattan"}};
    private static final String[][] m_labelPlacementLabels = new String[][]{{EditorPlugin.getResourceString("CanvasPreferences.LABEL.Top"), "Top"}, {EditorPlugin.getResourceString("CanvasPreferences.LABEL.Bottom"), "Bottom"}, {EditorPlugin.getResourceString("CanvasPreferences.LABEL.Left"), "Left"}, {EditorPlugin.getResourceString("CanvasPreferences.LABEL.Right"), "Right"}};
    private Group canvasGroup;
    private Group iconGroup;
    private Group lineGroup;
    private BooleanField useSystemColors;
    private ColorFieldEditor canvasColor;
    private BooleanField snapToGrid;
    private IntegerFieldEditor gridWidth;
    private IntegerFieldEditor gridHeight;
    private ColorFieldEditor gridColor;
    private BooleanField showLineLabels;
    private ColorFieldEditor lineLabelColor;
    private ColorFieldEditor lineColor;
    private ColorFontFieldEditor iconFont;
    private ColorFontFieldEditor lineFont;
    private ColorFieldEditor inputPortColor;
    private ColorFieldEditor outputPortColor;
    private static Hashtable resourceRegistry = new Hashtable();

    public GEMPreferences() {
        super(1);
        this.setPreferenceStore(EditorPlugin.getDefault().getPreferenceStore());
        this.setDescription("Preferences for the graphical page of FacesConfig editor.");
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        store.setDefault(USE_SYSTEM_COLORS, true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)CANVAS_COLOR, (RGB)new RGB(255, 255, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)FIGURE_LABEL_FONT, (FontData[])f.getFontData());
        store.setDefault(LINE_WIDTH, 1);
        store.setDefault(LINE_ROUTING, GEMPreferences.getLineRoutingLabels()[0][1]);
        store.setDefault(SHOW_LINE_LABELS, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)LINE_COLOR, (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)LINE_LABEL_COLOR, (RGB)new RGB(255, 255, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)LINE_LABEL_FONT, (FontData[])f.getFontData());
        store.setDefault(SNAP_TO_GEOMETRY, true);
        store.setDefault(SNAP_TO_GRID, true);
        store.setDefault(GRID_WIDTH, 12);
        store.setDefault(GRID_HEIGHT, 12);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)GRID_COLOR, (RGB)new RGB(230, 230, 230));
    }

    public void createFieldEditors() {
        this.useSystemColors = this.addBooleanField(USE_SYSTEM_COLORS, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.UseSystemColors"), this.getFieldEditorParent());
        this.canvasGroup = new Group(this.getFieldEditorParent(), 0);
        this.lineGroup = new Group(this.getFieldEditorParent(), 0);
        this.iconGroup = new Group(this.getFieldEditorParent(), 0);
        this.canvasGroup.setText(EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.Canvas"));
        this.canvasColor = this.addColorField(CANVAS_COLOR, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.BackgroundColor"), (Composite)this.canvasGroup);
        this.addBooleanField(SNAP_TO_GEOMETRY, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.SnapToGeometry"), (Composite)this.canvasGroup);
        this.snapToGrid = this.addBooleanField(SNAP_TO_GRID, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.SnapToGrid"), (Composite)this.canvasGroup);
        this.gridColor = this.addColorField(GRID_COLOR, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.GridLineColor"), (Composite)this.canvasGroup);
        this.gridWidth = this.addIntegerField(GRID_WIDTH, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.GridWidth"), (Composite)this.canvasGroup);
        this.gridHeight = this.addIntegerField(GRID_HEIGHT, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.GridHeight"), (Composite)this.canvasGroup);
        this.iconGroup.setText(EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.IconGroup"));
        this.iconFont = this.addFontField(FIGURE_LABEL_FONT, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.IconLabelFont"), (Composite)this.iconGroup);
        this.addComboField(LABEL_PLACEMENT, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.LabelPlacement"), GEMPreferences.getLabelPlacementLabels(), (Composite)this.iconGroup);
        this.inputPortColor = this.addColorField(INPUT_PORT_COLOR, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.InputPortColor"), (Composite)this.iconGroup);
        this.outputPortColor = this.addColorField(OUTPUT_PORT_COLOR, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.OutputPortColor"), (Composite)this.iconGroup);
        this.lineGroup.setText(EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.LineGroup"));
        this.showLineLabels = this.addBooleanField(SHOW_LINE_LABELS, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.ShowLineLabels"), (Composite)this.lineGroup);
        this.lineFont = this.addFontField(LINE_LABEL_FONT, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.LineLabelFont"), (Composite)this.lineGroup);
        this.lineLabelColor = this.addColorField(LINE_LABEL_COLOR, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.LineLabelColor"), (Composite)this.lineGroup);
        this.lineColor = this.addColorField(LINE_COLOR, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.LineColor"), (Composite)this.lineGroup);
        this.addIntegerField(LINE_WIDTH, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.LineWidth"), (Composite)this.lineGroup);
        this.addComboField(LINE_ROUTING, EditorPlugin.getResourceString("CanvasPreferenceTab.LABEL.LineRouting"), GEMPreferences.getLineRoutingLabels(), (Composite)this.lineGroup);
    }

    protected void initialize() {
        super.initialize();
        ((GridLayout)this.getFieldEditorParent().getLayout()).numColumns = 2;
        this.canvasGroup.setLayout((Layout)new GridLayout(3, false));
        this.canvasGroup.setLayoutData((Object)new GridData(770));
        this.canvasColor.fillIntoGrid((Composite)this.canvasGroup, 3);
        this.gridColor.fillIntoGrid((Composite)this.canvasGroup, 3);
        this.iconGroup.setLayout((Layout)new GridLayout(3, false));
        this.iconGroup.setLayoutData((Object)new GridData(770));
        this.iconFont.fillIntoGrid((Composite)this.iconGroup, 3);
        this.lineGroup.setLayout((Layout)new GridLayout(3, false));
        this.lineGroup.setLayoutData((Object)new GridData(770));
        this.lineColor.fillIntoGrid((Composite)this.lineGroup, 3);
        this.lineLabelColor.fillIntoGrid((Composite)this.lineGroup, 3);
        this.lineFont.fillIntoGrid((Composite)this.lineGroup, 3);
        boolean userColorsValue = !this.useSystemColors.getBooleanValue();
        boolean showLineLabelsValue = this.showLineLabels.getBooleanValue();
        boolean snapToGridValue = this.snapToGrid.getBooleanValue();
        this.canvasColor.setEnabled(userColorsValue, (Composite)this.canvasGroup);
        this.gridColor.setEnabled(snapToGridValue && userColorsValue, (Composite)this.canvasGroup);
        this.iconFont.setEnabled(userColorsValue, (Composite)this.iconGroup);
        this.inputPortColor.setEnabled(userColorsValue, (Composite)this.iconGroup);
        this.outputPortColor.setEnabled(userColorsValue, (Composite)this.iconGroup);
        this.lineColor.setEnabled(userColorsValue, (Composite)this.lineGroup);
        this.lineLabelColor.setEnabled(showLineLabelsValue && userColorsValue, (Composite)this.lineGroup);
        this.lineFont.setEnabled(showLineLabelsValue && userColorsValue, (Composite)this.lineGroup);
        this.gridWidth.setEnabled(snapToGridValue, (Composite)this.canvasGroup);
        this.gridHeight.setEnabled(snapToGridValue, (Composite)this.canvasGroup);
        this.useSystemColors.getButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean userColorsValue = !GEMPreferences.this.useSystemColors.getBooleanValue();
                boolean showLineLabelsValue = GEMPreferences.this.showLineLabels.getBooleanValue();
                boolean snapToGridValue = GEMPreferences.this.snapToGrid.getBooleanValue();
                GEMPreferences.this.canvasColor.setEnabled(userColorsValue, (Composite)GEMPreferences.this.canvasGroup);
                GEMPreferences.this.gridColor.setEnabled(snapToGridValue && userColorsValue, (Composite)GEMPreferences.this.canvasGroup);
                GEMPreferences.this.iconFont.setEnabled(userColorsValue, (Composite)GEMPreferences.this.iconGroup);
                GEMPreferences.this.inputPortColor.setEnabled(userColorsValue, (Composite)GEMPreferences.this.iconGroup);
                GEMPreferences.this.outputPortColor.setEnabled(userColorsValue, (Composite)GEMPreferences.this.iconGroup);
                GEMPreferences.this.lineColor.setEnabled(userColorsValue, (Composite)GEMPreferences.this.lineGroup);
                GEMPreferences.this.lineLabelColor.setEnabled(showLineLabelsValue && userColorsValue, (Composite)GEMPreferences.this.lineGroup);
                GEMPreferences.this.lineFont.setEnabled(showLineLabelsValue && userColorsValue, (Composite)GEMPreferences.this.lineGroup);
            }
        });
        this.showLineLabels.getButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean userColorsValue = !GEMPreferences.this.useSystemColors.getBooleanValue();
                boolean showLineLabelsValue = GEMPreferences.this.showLineLabels.getBooleanValue();
                GEMPreferences.this.lineLabelColor.setEnabled(showLineLabelsValue && userColorsValue, (Composite)GEMPreferences.this.lineGroup);
                GEMPreferences.this.lineFont.setEnabled(showLineLabelsValue && userColorsValue, (Composite)GEMPreferences.this.lineGroup);
            }
        });
        this.snapToGrid.getButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean userColorsValue = !GEMPreferences.this.useSystemColors.getBooleanValue();
                boolean snapToGridValue = GEMPreferences.this.snapToGrid.getBooleanValue();
                GEMPreferences.this.gridColor.setEnabled(snapToGridValue && userColorsValue, (Composite)GEMPreferences.this.canvasGroup);
                GEMPreferences.this.gridWidth.setEnabled(snapToGridValue, (Composite)GEMPreferences.this.canvasGroup);
                GEMPreferences.this.gridHeight.setEnabled(snapToGridValue, (Composite)GEMPreferences.this.canvasGroup);
            }
        });
    }

    public void init(IWorkbench workbench) {
    }

    protected ColorFieldEditor addColorField(String name, String labelText, Composite parent) {
        ColorFieldEditor f = new ColorFieldEditor(name, labelText, parent);
        this.addField((FieldEditor)f);
        return f;
    }

    protected ComboFieldEditor addComboField(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        ComboFieldEditor f = new ComboFieldEditor(name, labelText, entryNamesAndValues, parent);
        this.addField(f);
        return f;
    }

    protected IntegerFieldEditor addIntegerField(String name, String labelText, Composite parent) {
        IntegerFieldEditor f = new IntegerFieldEditor(name, labelText, parent);
        this.addField((FieldEditor)f);
        return f;
    }

    protected BooleanField addBooleanField(String name, String labelText, Composite parent) {
        BooleanField f = new BooleanField(name, labelText, parent);
        this.addField((FieldEditor)f);
        return f;
    }

    protected StringFieldEditor addStringField(String name, String labelText, Composite parent) {
        StringFieldEditor f = new StringFieldEditor(name, labelText, parent);
        this.addField((FieldEditor)f);
        return f;
    }

    protected ColorFontFieldEditor addFontField(String name, String labelText, Composite parent) {
        ColorFontFieldEditor f = new ColorFontFieldEditor(name, labelText, parent);
        this.addField(f);
        return f;
    }

    public static String[][] getLineRoutingLabels() {
        return m_lineRoutingLabels;
    }

    public static String[][] getLabelPlacementLabels() {
        return m_labelPlacementLabels;
    }

    public static void propagateProperty(String property, EditPart part) {
        Iterator iter = part.getChildren().iterator();
        while (iter.hasNext()) {
            EditPart child = (EditPart)iter.next();
            Figure fig = (Figure)((GraphicalEditPart)child).getFigure();
            GEMPreferences.propagateProperty(property, fig);
            GEMPreferences.propagateProperty(property, child);
        }
    }

    public static Color getColor(IPreferenceStore store, String property) {
        boolean useSystemColors = store.getBoolean(USE_SYSTEM_COLORS);
        Color c = ColorConstants.black;
        if (useSystemColors) {
            if (GRID_COLOR.equals(property)) {
                c = ColorConstants.button;
            }
            if (LINE_COLOR.equals(property)) {
                c = ColorConstants.listForeground;
            }
            if (LINE_LABEL_FONT_COLOR.equals(property)) {
                c = ColorConstants.listForeground;
            }
            if (LINE_LABEL_COLOR.equals(property)) {
                c = ColorConstants.listBackground;
            }
            if (CANVAS_COLOR.equals(property)) {
                c = ColorConstants.listBackground;
            }
            if (INPUT_PORT_COLOR.equals(property)) {
                c = ColorConstants.listForeground;
            }
            if (OUTPUT_PORT_COLOR.equals(property)) {
                c = ColorConstants.listForeground;
            }
            if (FIGURE_LABEL_FONT_COLOR.equals(property)) {
                c = ColorConstants.listForeground;
            }
        } else {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)property);
            if (resourceRegistry.containsKey(rgb.toString())) {
                return (Color)resourceRegistry.get(rgb.toString());
            }
            c = new Color((Device)Display.getCurrent(), rgb);
            resourceRegistry.put(rgb.toString(), c);
        }
        return c;
    }

    public static Font getFont(IPreferenceStore store, String property) {
        FontData fd = PreferenceConverter.getFontData((IPreferenceStore)store, (String)property);
        if (resourceRegistry.containsKey(fd.toString())) {
            return (Font)resourceRegistry.get(fd.toString());
        }
        Font f = new Font(null, fd);
        resourceRegistry.put(fd.toString(), f);
        return f;
    }

    public static void propagateProperty(String property, Figure fig) {
        IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
        WindowFigure window = null;
        IconFigure icon = null;
        LinkFigure link = null;
        if (fig instanceof CompoundNodeFigure) {
            window = ((CompoundNodeFigure)fig).getWindowFigure();
            icon = ((CompoundNodeFigure)fig).getIconFigure();
        } else if (fig instanceof WindowFigure) {
            window = (WindowFigure)fig;
        } else if (fig instanceof LinkFigure) {
            link = (LinkFigure)fig;
        }
        if (property != null && property.equals(USE_SYSTEM_COLORS)) {
            property = null;
        }
        if (property == null || SNAP_TO_GRID.equals(property)) {
            boolean b;
            WindowFigure.defaultGridEnabled = b = store.getBoolean(SNAP_TO_GRID);
            if (window != null) {
                window.getGridLayer().setVisible(b);
            }
        }
        if (property == null || GRID_WIDTH.equals(property) || GRID_HEIGHT.equals(property)) {
            Dimension d;
            WindowFigure.defaultGridSpacing = d = new Dimension(store.getInt(GRID_WIDTH), store.getInt(GRID_HEIGHT));
            if (window != null) {
                window.getGridLayer().setSpacing(d);
            }
        }
        if (property == null || GRID_COLOR.equals(property)) {
            Color c;
            WindowFigure.defaultGridColor = c = GEMPreferences.getColor(store, GRID_COLOR);
            if (window != null) {
                window.getGridLayer().setForegroundColor(c);
            }
        }
        if (property == null || LINE_ROUTING.equals(property)) {
            String s = store.getString(LINE_ROUTING);
            int style = LINE_ROUTING_MANHATTAN.equals(s) ? WindowFigure.LINE_ROUTING_MANHATTAN : WindowFigure.LINE_ROUTING_MANUAL;
            WindowFigure.defaultLineRoutingStyle = style;
            if (window != null) {
                window.setLineRoutingStyle(style);
            }
        }
        if (property == null || LINE_WIDTH.equals(property)) {
            int w;
            LinkFigure.defaultLineWidth = w = store.getInt(LINE_WIDTH);
            if (link != null) {
                link.setLineWidth(w);
            }
        }
        if (property == null || LINE_COLOR.equals(property)) {
            Color c;
            LinkFigure.defaultLineColor = c = GEMPreferences.getColor(store, LINE_COLOR);
            if (link != null) {
                link.setForegroundColor(c);
            }
        }
        if (property == null || SHOW_LINE_LABELS.equals(property)) {
            boolean b;
            LinkFigure.defaultLabelVisible = b = store.getBoolean(SHOW_LINE_LABELS);
            if (link != null) {
                link.setLabelVisible(b);
            }
        }
        if (property == null || LINE_LABEL_FONT.equals(property) || LINE_LABEL_FONT_COLOR.equals(property)) {
            Font f = GEMPreferences.getFont(store, LINE_LABEL_FONT);
            Color c = GEMPreferences.getColor(store, LINE_LABEL_FONT_COLOR);
            LinkFigure.defaultFont = f;
            LinkFigure.defaultLabelForeground = c;
            if (link != null) {
                link.setFont(f);
                link.setLabelForeground(c);
            }
        }
        if (property == null || LINE_LABEL_COLOR.equals(property)) {
            Color c;
            LinkFigure.defaultLabelBackground = c = GEMPreferences.getColor(store, LINE_LABEL_COLOR);
            if (link != null) {
                link.setLabelBackground(c);
            }
        }
        if (property == null || CANVAS_COLOR.equals(property)) {
            Color c;
            WindowFigure.defaultBackgroundColor = c = GEMPreferences.getColor(store, CANVAS_COLOR);
            if (window != null) {
                window.setBackgroundColor(c);
            }
            if (icon != null) {
                icon.setBackgroundColor(c);
            }
        }
        if (property == null || INPUT_PORT_COLOR.equals(property)) {
            Color c;
            InputPortFigure.defaultForegroundColor = c = GEMPreferences.getColor(store, INPUT_PORT_COLOR);
            if (fig instanceof InputPortFigure) {
                fig.setForegroundColor(c);
            }
        }
        if (property == null || OUTPUT_PORT_COLOR.equals(property)) {
            Color c;
            OutputPortFigure.defaultForegroundColor = c = GEMPreferences.getColor(store, OUTPUT_PORT_COLOR);
            if (fig instanceof OutputPortFigure) {
                fig.setForegroundColor(c);
            }
        }
        if (property == null || FIGURE_LABEL_FONT.equals(property) || FIGURE_LABEL_FONT_COLOR.equals(property)) {
            Font f = GEMPreferences.getFont(store, FIGURE_LABEL_FONT);
            Color c = GEMPreferences.getColor(store, FIGURE_LABEL_FONT_COLOR);
            IconFigure.defaultFont = f;
            IconFigure.defaultForegroundColor = c;
            WindowFigure.defaultFont = f;
            WindowFigure.defaultForegroundColor = c;
            if (window != null) {
                window.setFont(f);
                window.setForegroundColor(c);
            }
            if (icon != null) {
                icon.setFont(f);
                icon.setForegroundColor(c);
            }
            if (fig instanceof IconFigure) {
                fig.setFont(f);
                fig.setForegroundColor(c);
            }
        }
        if (property == null || LABEL_PLACEMENT.equals(property)) {
            int placement = 4;
            String s = store.getString(LABEL_PLACEMENT);
            if (LABEL_PLACEMENT_TOP.equals(s)) {
                placement = 1;
            }
            if (LABEL_PLACEMENT_BOTTOM.equals(s)) {
                placement = 4;
            }
            if (LABEL_PLACEMENT_LEFT.equals(s)) {
                placement = 8;
            }
            if (LABEL_PLACEMENT_RIGHT.equals(s)) {
                placement = 16;
            }
            IconFigure.defaultTextPlacement = placement;
            if (icon != null) {
                icon.setTextPlacement(placement);
            }
            if (fig instanceof IconFigure) {
                ((IconFigure)fig).setTextPlacement(placement);
            }
        }
        Iterator iter = fig.getChildren().iterator();
        while (iter.hasNext()) {
            Figure child = (Figure)iter.next();
            GEMPreferences.propagateProperty(property, child);
        }
    }

    private class BooleanField
    extends BooleanFieldEditor {
        private Composite parent;

        public BooleanField(String name, String label, Composite parent) {
            super(name, label, parent);
            this.parent = parent;
        }

        public Button getButton() {
            return this.getChangeControl(this.parent);
        }
    }
}

