/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.iterators.NullListIterator;

public class NullListIteratorTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.NullListIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.NullListIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public NullListIteratorTests(String name) {
        super(name);
    }

    public void testHasNext() {
        int i = 0;
        ListIterator stream = NullListIterator.instance();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        NullListIteratorTests.assertEquals((int)0, (int)i);
    }

    public void testNext() {
        ListIterator stream = NullListIterator.instance();
        while (stream.hasNext()) {
            NullListIteratorTests.fail((String)("bogus element: " + stream.next()));
        }
    }

    public void testNextIndex() {
        ListIterator stream = NullListIterator.instance();
        NullListIteratorTests.assertEquals((int)0, (int)stream.nextIndex());
    }

    public void testHasPrevious() {
        ListIterator stream = NullListIterator.instance();
        int i = 0;
        while (stream.hasPrevious()) {
            stream.previous();
            ++i;
        }
        NullListIteratorTests.assertEquals((int)0, (int)i);
        while (stream.hasNext()) {
            stream.next();
        }
        i = 0;
        while (stream.hasPrevious()) {
            stream.previous();
            ++i;
        }
        NullListIteratorTests.assertEquals((int)0, (int)i);
    }

    public void testPrevious() {
        ListIterator stream = NullListIterator.instance();
        while (stream.hasPrevious()) {
            NullListIteratorTests.fail((String)("bogus element: " + stream.previous()));
        }
        while (stream.hasNext()) {
            stream.next();
        }
        while (stream.hasPrevious()) {
            NullListIteratorTests.fail((String)("bogus element: " + stream.previous()));
        }
    }

    public void testPreviousIndex() {
        ListIterator stream = NullListIterator.instance();
        NullListIteratorTests.assertEquals((int)-1, (int)stream.previousIndex());
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        ListIterator stream = NullListIterator.instance();
        Object element = null;
        while (stream.hasNext()) {
            element = stream.next();
        }
        try {
            element = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        NullListIteratorTests.assertTrue((String)("NoSuchElementException not thrown (next): " + element), (boolean)exCaught);
        while (stream.hasPrevious()) {
            element = stream.previous();
        }
        try {
            element = stream.previous();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        NullListIteratorTests.assertTrue((String)("NoSuchElementException not thrown (previous): " + element), (boolean)exCaught);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        try {
            NullListIterator.instance().remove();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        NullListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown (remove)", (boolean)exCaught);
        try {
            NullListIterator.instance().set(new Object());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        NullListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown (set)", (boolean)exCaught);
        try {
            NullListIterator.instance().add(new Object());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        NullListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown (add)", (boolean)exCaught);
    }
}

