/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.iterators.IteratorEnumeration;

public class IteratorEnumerationTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.IteratorEnumerationTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.IteratorEnumerationTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public IteratorEnumerationTests(String name) {
        super(name);
    }

    public void testHasMoreElements() {
        int i = 0;
        Enumeration stream = this.buildEnumeration();
        while (stream.hasMoreElements()) {
            stream.nextElement();
            ++i;
        }
        IteratorEnumerationTests.assertEquals((int)this.buildVector().size(), (int)i);
    }

    public void testNextElement() {
        Iterator iterator = this.buildIterator();
        Enumeration stream = this.buildEnumeration();
        while (stream.hasMoreElements()) {
            IteratorEnumerationTests.assertEquals((String)"bogus element", iterator.next(), stream.nextElement());
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Enumeration stream = this.buildEnumeration();
        String string = null;
        while (stream.hasMoreElements()) {
            string = (String)stream.nextElement();
        }
        try {
            string = (String)stream.nextElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        IteratorEnumerationTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    private Enumeration buildEnumeration() {
        return this.buildEnumeration(this.buildIterator());
    }

    private Enumeration buildEnumeration(Iterator iterator) {
        return new IteratorEnumeration(iterator);
    }

    private Iterator buildIterator() {
        return this.buildVector().iterator();
    }

    private Vector buildVector() {
        Vector<String> v = new Vector<String>();
        v.addElement("one");
        v.addElement("two");
        v.addElement("three");
        v.addElement("four");
        v.addElement("five");
        v.addElement("six");
        v.addElement("seven");
        v.addElement("eight");
        return v;
    }
}

