/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.Range;
import org.eclipse.dali.utility.tests.TestTools;

public class RangeTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.RangeTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.RangeTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public RangeTests(String name) {
        super(name);
    }

    public void testIncludes() {
        Range range = new Range(5, 17);
        RangeTests.assertFalse((boolean)range.includes(-55));
        RangeTests.assertFalse((boolean)range.includes(0));
        RangeTests.assertFalse((boolean)range.includes(4));
        RangeTests.assertTrue((boolean)range.includes(5));
        RangeTests.assertTrue((boolean)range.includes(6));
        RangeTests.assertTrue((boolean)range.includes(16));
        RangeTests.assertTrue((boolean)range.includes(17));
        RangeTests.assertFalse((boolean)range.includes(18));
        RangeTests.assertFalse((boolean)range.includes(200));
    }

    public void testEquals() {
        Range range1 = new Range(5, 17);
        Range range2 = new Range(5, 17);
        RangeTests.assertNotSame((Object)range1, (Object)range2);
        RangeTests.assertEquals((Object)range1, (Object)range1);
        RangeTests.assertEquals((Object)range1, (Object)range2);
        RangeTests.assertEquals((Object)range2, (Object)range1);
        RangeTests.assertEquals((int)range1.hashCode(), (int)range2.hashCode());
        range2 = new Range(17, 5);
        RangeTests.assertFalse((boolean)range1.equals((Object)range2));
        RangeTests.assertFalse((boolean)range2.equals((Object)range1));
        RangeTests.assertEquals((int)range1.hashCode(), (int)range2.hashCode());
        range2 = new Range(5, 15);
        RangeTests.assertFalse((boolean)range1.equals((Object)range2));
        RangeTests.assertFalse((boolean)range2.equals((Object)range1));
    }

    public void testClone() {
        Range range1 = new Range(5, 17);
        Range range2 = (Range)range1.clone();
        RangeTests.assertNotSame((Object)range1, (Object)range2);
        RangeTests.assertEquals((Object)range1, (Object)range1);
        RangeTests.assertEquals((Object)range1, (Object)range2);
        RangeTests.assertEquals((Object)range2, (Object)range1);
        RangeTests.assertEquals((int)range1.hashCode(), (int)range2.hashCode());
    }

    public void testSerialization() throws Exception {
        Range range1 = new Range(5, 17);
        Range range2 = (Range)TestTools.serialize(range1);
        RangeTests.assertNotSame((Object)range1, (Object)range2);
        RangeTests.assertEquals((Object)range1, (Object)range1);
        RangeTests.assertEquals((Object)range1, (Object)range2);
        RangeTests.assertEquals((Object)range2, (Object)range1);
        RangeTests.assertEquals((int)range1.hashCode(), (int)range2.hashCode());
    }
}

