/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.packaging;

import java.io.IOException;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.packaging.PackagingFactory;
import org.eclipse.dali.packaging.PackagingResource;
import org.eclipse.dali.packaging.Persistence;
import org.eclipse.dali.packaging.PersistenceUnit;
import org.eclipse.dali.packaging.PersistenceUnitTransactionType;
import org.eclipse.dali.packaging.Properties;
import org.eclipse.dali.packaging.Property;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;

public class PackagingModelTranslatorTests
extends TestCase {
    private static String PROJECTNAME = "TestPackagingModelProject";
    static /* synthetic */ Class class$0;

    public static TestSuite suite() {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.dali.core.tests.packaging.PackagingModelTranslatorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.packaging.PackagingModelTranslatorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite(clazz2, ClassTools.shortNameFor((Class)clazz));
    }

    public PackagingModelTranslatorTests() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.packaging.PackagingModelTranslatorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(ClassTools.shortNameFor((Class)clazz));
    }

    protected void setUp() throws Exception {
        super.setUp();
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.getRoot().getProject(PROJECTNAME).isAccessible()) {
            return;
        }
        final IProjectDescription description = workspace.newProjectDescription(PROJECTNAME);
        description.setLocation(null);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                PackagingModelTranslatorTests.this.createProject(description, workspace.getRoot().getProject(PROJECTNAME), monitor);
            }
        };
        try {
            op.run(null);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    public void testCreateModel() {
        IProject testProj = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECTNAME);
        URI fileURI = URI.createPlatformResourceURI((String)("/" + testProj.getName() + "/persistence.xml"));
        PackagingResource res = (PackagingResource)this.getResourceSet().createResource(fileURI);
        Persistence persistence = PackagingFactory.eINSTANCE.createPersistence();
        persistence.setVersion("1.0");
        this.addPersistenceUnit1(persistence);
        this.addPersistenceUnit2(persistence);
        this.addPersistenceUnit3(persistence);
        res.getContents().add((Object)persistence);
        try {
            res.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addPersistenceUnit1(Persistence persistence) {
        PersistenceUnit pUnit = PackagingFactory.eINSTANCE.createPersistenceUnit();
        pUnit.setName("pu1");
        pUnit.setTransactionType(PersistenceUnitTransactionType.JTA_LITERAL);
        pUnit.setDescription("Persistence Unit 1");
        pUnit.setProvider("Oracle");
        pUnit.setJtaDataSource("Oracle_DB");
        pUnit.getMappingFiles().add((Object)"orm.xml");
        pUnit.setExcludeUnlistedClasses(false);
        persistence.getPersistenceUnits().add((Object)pUnit);
    }

    private void addPersistenceUnit2(Persistence persistence) {
        PersistenceUnit pUnit = PackagingFactory.eINSTANCE.createPersistenceUnit();
        pUnit.setName("pu2");
        pUnit.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL_LITERAL);
        pUnit.setDescription("Persistence Unit 2");
        pUnit.setProvider("Hibernate");
        pUnit.setNonJtaDataSource("Hibernate_DB");
        pUnit.getJarFiles().add((Object)"classes.jar");
        pUnit.setExcludeUnlistedClasses(false);
        Properties properties = PackagingFactory.eINSTANCE.createProperties();
        pUnit.setProperties(properties);
        Property property = PackagingFactory.eINSTANCE.createProperty();
        property.setName("configure-combobulator");
        property.setValue("true");
        properties.getProperties().add((Object)property);
        persistence.getPersistenceUnits().add((Object)pUnit);
    }

    private void addPersistenceUnit3(Persistence persistence) {
        PersistenceUnit pUnit = PackagingFactory.eINSTANCE.createPersistenceUnit();
        pUnit.setName("pu3");
        pUnit.getClasses().add((Object)"com.example.Entity");
        pUnit.getClasses().add((Object)"com.example.Embeddable");
        pUnit.setExcludeUnlistedClasses(true);
        Properties properties = PackagingFactory.eINSTANCE.createProperties();
        pUnit.setProperties(properties);
        Property property = PackagingFactory.eINSTANCE.createProperty();
        property.setName("extractor-method");
        property.setValue("extract");
        properties.getProperties().add((Object)property);
        persistence.getPersistenceUnits().add((Object)pUnit);
    }

    public void testLoadModel() {
        URI fileURI;
        IProject testProj = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECTNAME);
        ResourceSet set = this.getResourceSet();
        PackagingResource res = (PackagingResource)set.getResource(fileURI = URI.createPlatformResourceURI((String)("/" + testProj.getName() + "/persistence.xml")), true);
        if (!res.getContents().isEmpty()) {
            PackagingModelTranslatorTests.assertTrue((((Persistence)res.getContents().get(0)).getPersistenceUnits().size() == 3 ? 1 : 0) != 0);
        }
    }

    private ResourceSet getResourceSet() {
        ResourceSetImpl set = new ResourceSetImpl();
        set.setResourceFactoryRegistry((Resource.Factory.Registry)WTPResourceFactoryRegistry.INSTANCE);
        return set;
    }
}

