/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.openwebbeans.initialiser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.naming.ContextAccessController;
import org.apache.tomcat.InstanceManager;
import org.apache.webbeans.web.tomcat.TomcatUtil;
import org.eclipse.virgo.web.enterprise.openwebbeans.initialiser.VirgoInstanceManager;

public class VirgoContextLifecycleListener
implements PropertyChangeListener,
LifecycleListener,
ContainerListener {
    private StandardServer standardServer;

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            if (event.getSource() instanceof StandardServer) {
                if (event.getType().equals("start")) {
                    this.standardServer = (StandardServer)event.getSource();
                    this.start();
                }
            } else if (event.getSource() instanceof StandardContext) {
                StandardContext context = (StandardContext)event.getSource();
                if (event.getType().equals("configure_start")) {
                    context.addContainerListener((ContainerListener)this);
                    System.setProperty("org.apache.webbeans.application.jsp", "true");
                    String[] oldListeners = context.findApplicationListeners();
                    this.addWebBeansConfigListenerAtFront(context, oldListeners);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addWebBeansConfigListenerAtFront(StandardContext context, String[] oldListeners) {
        LinkedList<String> listeners = new LinkedList<String>();
        listeners.addFirst("org.apache.webbeans.servlet.WebBeansConfigurationListener");
        String[] stringArray = oldListeners;
        int n = oldListeners.length;
        int n2 = 0;
        while (n2 < n) {
            String listener = stringArray[n2];
            listeners.add(listener);
            context.removeApplicationListener(listener);
            ++n2;
        }
        for (String listener : listeners) {
            context.addApplicationListener(listener);
        }
    }

    public void containerEvent(ContainerEvent event) {
        StandardContext context = null;
        try {
            if (event.getSource() instanceof StandardContext) {
                Object listener;
                context = (StandardContext)event.getSource();
                if (event.getType().equals("beforeContextInitialized")) {
                    ClassLoader loader = context.getLoader().getClassLoader();
                    Object listener2 = event.getData();
                    if (listener2.getClass().getName().equals("org.apache.webbeans.servlet.WebBeansConfigurationListener")) {
                        ContextAccessController.setWritable((Object)context.getNamingContextListener().getName(), (Object)context);
                        return;
                    }
                    TomcatUtil.inject((Object)listener2, (ClassLoader)loader);
                } else if (event.getType().equals("afterContextInitialized")) {
                    ClassLoader loader = context.getLoader().getClassLoader();
                    Object listener3 = event.getData();
                    if (listener3.getClass().getName().equals("org.apache.webbeans.servlet.WebBeansConfigurationListener")) {
                        Object[] listeners;
                        InstanceManager processor = context.getInstanceManager();
                        VirgoInstanceManager custom = new VirgoInstanceManager(context.getLoader().getClassLoader(), processor);
                        context.setInstanceManager((InstanceManager)custom);
                        context.getServletContext().setAttribute(InstanceManager.class.getName(), (Object)custom);
                        ContextAccessController.setReadOnly((Object)context.getNamingContextListener().getName());
                        Object[] objectArray = listeners = context.getApplicationEventListeners();
                        int n = listeners.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object instance = objectArray[n2];
                            if (!instance.getClass().getName().equals("org.apache.webbeans.servlet.WebBeansConfigurationListener")) {
                                TomcatUtil.inject((Object)instance, (ClassLoader)loader);
                            }
                            ++n2;
                        }
                    }
                } else if (event.getType().equals("beforeContextDestroyed") && (listener = event.getData()).getClass().getName().equals("org.apache.webbeans.servlet.WebBeansConfigurationListener")) {
                    ContextAccessController.setWritable((Object)context.getNamingContextListener().getName(), (Object)context);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        this.standardServer.addPropertyChangeListener((PropertyChangeListener)this);
        this.standardServer.addLifecycleListener((LifecycleListener)this);
        Service[] serviceArray = this.standardServer.findServices();
        int n = serviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Service service = serviceArray[n2];
            this.serviceAdded(service);
            ++n2;
        }
    }

    public void stop() {
        this.standardServer.removePropertyChangeListener((PropertyChangeListener)this);
    }

    private void serviceAdded(Service service) {
        Container container = service.getContainer();
        if (container instanceof StandardEngine) {
            StandardEngine engine = (StandardEngine)container;
            this.engineAdded(engine);
        }
    }

    private void serviceRemoved(Service service) {
        Container container = service.getContainer();
        if (container instanceof StandardEngine) {
            StandardEngine engine = (StandardEngine)container;
            this.engineRemoved(engine);
        }
    }

    private void engineAdded(StandardEngine engine) {
        this.addContextListener((ContainerBase)engine);
        Container[] containerArray = engine.findChildren();
        int n = containerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Container child = containerArray[n2];
            if (child instanceof StandardHost) {
                StandardHost host = (StandardHost)child;
                this.hostAdded(host);
            }
            ++n2;
        }
    }

    private void engineRemoved(StandardEngine engine) {
        Container[] containerArray = engine.findChildren();
        int n = containerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Container child = containerArray[n2];
            if (child instanceof StandardHost) {
                StandardHost host = (StandardHost)child;
                this.hostRemoved(host);
            }
            ++n2;
        }
    }

    private void hostAdded(StandardHost host) {
        this.addContextListener((ContainerBase)host);
        host.addLifecycleListener((LifecycleListener)this);
        Container[] containerArray = host.findChildren();
        int n = containerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Container child = containerArray[n2];
            if (child instanceof StandardContext) {
                StandardContext context = (StandardContext)child;
                this.contextAdded(context);
            }
            ++n2;
        }
    }

    private void hostRemoved(StandardHost host) {
        Container[] containerArray = host.findChildren();
        int n = containerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Container child = containerArray[n2];
            if (child instanceof StandardContext) {
                StandardContext context = (StandardContext)child;
                this.contextRemoved(context);
            }
            ++n2;
        }
    }

    private void contextAdded(StandardContext context) {
        this.forceFirstLifecycleListener(context);
    }

    private void forceFirstLifecycleListener(StandardContext context) {
        LifecycleListener listener;
        LifecycleListener[] listeners = context.findLifecycleListeners();
        if (listeners.length > 0 && listeners[0] == this) {
            return;
        }
        LifecycleListener[] lifecycleListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            listener = lifecycleListenerArray[n2];
            context.removeLifecycleListener(listener);
            ++n2;
        }
        context.addLifecycleListener((LifecycleListener)this);
        context.addContainerListener((ContainerListener)this);
        lifecycleListenerArray = listeners;
        n = listeners.length;
        n2 = 0;
        while (n2 < n) {
            listener = lifecycleListenerArray[n2];
            if (listener != this) {
                context.addLifecycleListener(listener);
            }
            ++n2;
        }
    }

    private void contextRemoved(StandardContext context) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("service".equals(event.getPropertyName())) {
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            if (oldValue == null && newValue instanceof Service) {
                this.serviceAdded((Service)newValue);
            }
            if (oldValue instanceof Service && newValue == null) {
                this.serviceRemoved((Service)oldValue);
            }
        }
        if ("children".equals(event.getPropertyName())) {
            Object source = event.getSource();
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            if (source instanceof StandardEngine) {
                if (oldValue == null && newValue instanceof StandardHost) {
                    this.hostAdded((StandardHost)newValue);
                }
                if (oldValue instanceof StandardHost && newValue == null) {
                    this.hostRemoved((StandardHost)oldValue);
                }
            }
            if (source instanceof StandardHost) {
                if (oldValue == null && newValue instanceof StandardContext) {
                    this.contextAdded((StandardContext)newValue);
                }
                if (oldValue instanceof StandardContext && newValue == null) {
                    this.contextRemoved((StandardContext)oldValue);
                }
            }
        }
    }

    private void addContextListener(ContainerBase containerBase) {
        try {
            Field field = (Field)AccessController.doPrivileged(new PrivilegedActionForClass(ContainerBase.class, "children"));
            AccessController.doPrivileged(new PrivilegedActionForAccessibleObject(field, true));
            Map children = (Map)field.get(containerBase);
            if (children instanceof MoniterableHashMap) {
                return;
            }
            children = new MoniterableHashMap(children, containerBase, "children", this);
            field.set(containerBase, children);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class MoniterableHashMap
    extends HashMap<Object, Object> {
        private static final long serialVersionUID = 1L;
        private final Object source;
        private final String propertyName;
        private final PropertyChangeListener listener;

        public MoniterableHashMap(Map<Object, Object> m, Object source, String propertyName, PropertyChangeListener listener) {
            super(m);
            this.source = source;
            this.propertyName = propertyName;
            this.listener = listener;
        }

        @Override
        public Object put(Object key, Object value) {
            Object oldValue = super.put(key, value);
            PropertyChangeEvent event = new PropertyChangeEvent(this.source, this.propertyName, null, value);
            this.listener.propertyChange(event);
            return oldValue;
        }

        @Override
        public Object remove(Object key) {
            Object value = super.remove(key);
            PropertyChangeEvent event = new PropertyChangeEvent(this.source, this.propertyName, value, null);
            this.listener.propertyChange(event);
            return value;
        }
    }

    protected static class PrivilegedActionForAccessibleObject
    implements PrivilegedAction<Object> {
        AccessibleObject object;
        boolean flag;

        protected PrivilegedActionForAccessibleObject(AccessibleObject object, boolean flag) {
            this.object = object;
            this.flag = flag;
        }

        @Override
        public Object run() {
            this.object.setAccessible(this.flag);
            return null;
        }
    }

    protected static class PrivilegedActionForClass
    implements PrivilegedAction<Object> {
        Class<?> clazz;
        Object parameters;

        protected PrivilegedActionForClass(Class<?> clazz, Object parameters) {
            this.clazz = clazz;
            this.parameters = parameters;
        }

        @Override
        public Object run() {
            try {
                return this.clazz.getDeclaredField((String)this.parameters);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

