/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.virgo.ide.runtime.internal.ui.PDEHelper;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;

public class RuntimeListener
implements IRuntimeLifecycleListener {
    private static RuntimeListener self = new RuntimeListener();

    private RuntimeListener() {
    }

    public static RuntimeListener getDefault() {
        return self;
    }

    public void runtimeAdded(IRuntime runtime) {
    }

    public void runtimeChanged(IRuntime runtime) {
    }

    public void runtimeRemoved(IRuntime runtime) {
        if (runtime.getRuntimeType().getId().startsWith("org.eclipse.virgo.server.runtime.virgo")) {
            final String name = runtime.getName();
            WorkbenchJob job = new WorkbenchJob("RemoveVirgoTargetPlatform"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    boolean delete;
                    if (PDEHelper.existsTargetDefinition(name) && (delete = MessageDialog.openQuestion((Shell)this.getDisplay().getActiveShell(), (String)"Delete target platform?", (String)"A Virgo Runtime has been deleted. Do you also want to delete the associated PDE Target Platform?"))) {
                        PDEHelper.deleteTargetDefinition(name);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }
}

