/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.symbols;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.ui.symbols.BasicSymbolProvider;
import org.eclipse.tracecompass.internal.tmf.ui.symbols.BasicSymbolProviderFactory;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.TmfResolvedSymbol;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.tests.symbols.MappingFileTest;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicSymbolProviderTest {
    private @Nullable ITmfTrace fTrace = null;

    @Before
    public void setupTest() {
        this.fTrace = TmfTestTrace.A_TEST_10K.getTrace();
    }

    @After
    public void cleanUp() {
        ITmfTrace trace = this.fTrace;
        if (trace != null) {
            trace.dispose();
        }
    }

    private BasicSymbolProvider getSymbolProvider() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        BasicSymbolProviderFactory factory = new BasicSymbolProviderFactory();
        ISymbolProvider symbolProvider = factory.createProvider(trace);
        Assert.assertTrue((boolean)(symbolProvider instanceof BasicSymbolProvider));
        BasicSymbolProvider bsp = (BasicSymbolProvider)symbolProvider;
        return bsp;
    }

    @Test
    public void testBasicProvider() {
        BasicSymbolProvider symbolProvider = this.getSymbolProvider();
        symbolProvider.setMappingFiles(MappingFileTest.getMappingFiles());
        TmfResolvedSymbol symbol = symbolProvider.getSymbol(Long.parseUnsignedLong("601050", 16));
        Assert.assertNotNull((Object)symbol);
        Assert.assertEquals((Object)"__dso_handle", (Object)symbol.getSymbolName());
        symbol = symbolProvider.getSymbol(Long.parseUnsignedLong("400752", 16));
        Assert.assertNotNull((Object)symbol);
        Assert.assertEquals((Object)"A little bit after nm_ouput's frame_dummy", (Object)symbol.getSymbolName());
        symbol = symbolProvider.getSymbol(1, 0L, Long.parseUnsignedLong("400752", 16));
        Assert.assertNotNull((Object)symbol);
        Assert.assertEquals((Object)"frame_dummy", (Object)symbol.getSymbolName());
        symbol = symbolProvider.getSymbol(123, 0L, Long.parseUnsignedLong("4005d0", 16));
        Assert.assertNotNull((Object)symbol);
        Assert.assertEquals((Object)"same address as nm_output", (Object)symbol.getSymbolName());
        symbol = symbolProvider.getSymbol(123, 0L, Long.parseUnsignedLong("400735", 16));
        Assert.assertNotNull((Object)symbol);
        Assert.assertEquals((Object)"A little bit before nm_ouput's frame_dummy", (Object)symbol.getSymbolName());
        symbol = symbolProvider.getSymbol(123, 0L, Long.parseUnsignedLong("ffeeddccbbaa0090", 16));
        Assert.assertNotNull((Object)symbol);
        Assert.assertEquals((Object)"One huge symbol from nm mapping", (Object)symbol.getSymbolName());
        symbol = symbolProvider.getSymbol(1, 0L, Long.parseUnsignedLong("ffeeddccbbaa0090", 16));
        Assert.assertNull((Object)symbol);
    }
}

